/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.type.IpAddressType;
import com.facebook.presto.type.IpPrefixType;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.Test;

public class TestIpPrefixFunctions
extends AbstractTestFunctions {
    @Test
    public void testIpAddressIpPrefix() {
        this.assertFunction("IP_PREFIX(IPADDRESS '1.2.3.4', 24)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("IP_PREFIX(IPADDRESS '1.2.3.4', 32)", (Type)IpPrefixType.IPPREFIX, "1.2.3.4/32");
        this.assertFunction("IP_PREFIX(IPADDRESS '1.2.3.4', 0)", (Type)IpPrefixType.IPPREFIX, "0.0.0.0/0");
        this.assertFunction("IP_PREFIX(IPADDRESS '::ffff:1.2.3.4', 24)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("IP_PREFIX(IPADDRESS '64:ff9b::17', 64)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::/64");
        this.assertFunction("IP_PREFIX(IPADDRESS '64:ff9b::17', 127)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::16/127");
        this.assertFunction("IP_PREFIX(IPADDRESS '64:ff9b::17', 128)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::17/128");
        this.assertFunction("IP_PREFIX(IPADDRESS '64:ff9b::17', 0)", (Type)IpPrefixType.IPPREFIX, "::/0");
        this.assertInvalidFunction("IP_PREFIX(IPADDRESS '::ffff:1.2.3.4', -1)", "IPv4 subnet size must be in range [0, 32]");
        this.assertInvalidFunction("IP_PREFIX(IPADDRESS '::ffff:1.2.3.4', 33)", "IPv4 subnet size must be in range [0, 32]");
        this.assertInvalidFunction("IP_PREFIX(IPADDRESS '64:ff9b::10', -1)", "IPv6 subnet size must be in range [0, 128]");
        this.assertInvalidFunction("IP_PREFIX(IPADDRESS '64:ff9b::10', 129)", "IPv6 subnet size must be in range [0, 128]");
    }

    @Test
    public void testStringIpPrefix() {
        this.assertFunction("IP_PREFIX('1.2.3.4', 24)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("IP_PREFIX('1.2.3.4', 32)", (Type)IpPrefixType.IPPREFIX, "1.2.3.4/32");
        this.assertFunction("IP_PREFIX('1.2.3.4', 0)", (Type)IpPrefixType.IPPREFIX, "0.0.0.0/0");
        this.assertFunction("IP_PREFIX('::ffff:1.2.3.4', 24)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("IP_PREFIX('64:ff9b::17', 64)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::/64");
        this.assertFunction("IP_PREFIX('64:ff9b::17', 127)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::16/127");
        this.assertFunction("IP_PREFIX('64:ff9b::17', 128)", (Type)IpPrefixType.IPPREFIX, "64:ff9b::17/128");
        this.assertFunction("IP_PREFIX('64:ff9b::17', 0)", (Type)IpPrefixType.IPPREFIX, "::/0");
        this.assertInvalidFunction("IP_PREFIX('::ffff:1.2.3.4', -1)", "IPv4 subnet size must be in range [0, 32]");
        this.assertInvalidFunction("IP_PREFIX('::ffff:1.2.3.4', 33)", "IPv4 subnet size must be in range [0, 32]");
        this.assertInvalidFunction("IP_PREFIX('64:ff9b::10', -1)", "IPv6 subnet size must be in range [0, 128]");
        this.assertInvalidFunction("IP_PREFIX('64:ff9b::10', 129)", "IPv6 subnet size must be in range [0, 128]");
        this.assertInvalidCast("IP_PREFIX('localhost', 24)", "Cannot cast value to IPADDRESS: localhost");
        this.assertInvalidCast("IP_PREFIX('64::ff9b::10', 24)", "Cannot cast value to IPADDRESS: 64::ff9b::10");
        this.assertInvalidCast("IP_PREFIX('64:face:book::10', 24)", "Cannot cast value to IPADDRESS: 64:face:book::10");
        this.assertInvalidCast("IP_PREFIX('123.456.789.012', 24)", "Cannot cast value to IPADDRESS: 123.456.789.012");
    }

    @Test
    public void testIpSubnetMin() {
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '1.2.3.4/24')", (Type)IpAddressType.IPADDRESS, "1.2.3.0");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '1.2.3.4/32')", (Type)IpAddressType.IPADDRESS, "1.2.3.4");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '64:ff9b::17/64')", (Type)IpAddressType.IPADDRESS, "64:ff9b::");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '64:ff9b::17/127')", (Type)IpAddressType.IPADDRESS, "64:ff9b::16");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '64:ff9b::17/128')", (Type)IpAddressType.IPADDRESS, "64:ff9b::17");
        this.assertFunction("IP_SUBNET_MIN(IPPREFIX '64:ff9b::17/0')", (Type)IpAddressType.IPADDRESS, "::");
    }

    @Test
    public void testIpSubnetMax() {
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '1.2.3.128/26')", (Type)IpAddressType.IPADDRESS, "1.2.3.191");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '192.168.128.4/32')", (Type)IpAddressType.IPADDRESS, "192.168.128.4");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '10.1.16.3/9')", (Type)IpAddressType.IPADDRESS, "10.127.255.255");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '2001:db8::16/127')", (Type)IpAddressType.IPADDRESS, "2001:db8::17");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '2001:db8::16/128')", (Type)IpAddressType.IPADDRESS, "2001:db8::16");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '64:ff9b::17/64')", (Type)IpAddressType.IPADDRESS, "64:ff9b::ffff:ffff:ffff:ffff");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '64:ff9b::17/72')", (Type)IpAddressType.IPADDRESS, "64:ff9b::ff:ffff:ffff:ffff");
        this.assertFunction("IP_SUBNET_MAX(IPPREFIX '64:ff9b::17/0')", (Type)IpAddressType.IPADDRESS, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
    }

    @Test
    public void testIpSubnetRange() {
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '1.2.3.160/24')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"1.2.3.0", (Object)"1.2.3.255"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '1.2.3.128/31')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"1.2.3.128", (Object)"1.2.3.129"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '10.1.6.46/32')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"10.1.6.46", (Object)"10.1.6.46"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '10.1.6.46/0')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"0.0.0.0", (Object)"255.255.255.255"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '64:ff9b::17/64')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"64:ff9b::", (Object)"64:ff9b::ffff:ffff:ffff:ffff"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '64:ff9b::52f4/120')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"64:ff9b::5200", (Object)"64:ff9b::52ff"));
        this.assertFunction("IP_SUBNET_RANGE(IPPREFIX '64:ff9b::17/128')", (Type)new ArrayType((Type)IpAddressType.IPADDRESS), ImmutableList.of((Object)"64:ff9b::17", (Object)"64:ff9b::17"));
    }

    @Test
    public void testIsSubnetOf() {
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/26', IPADDRESS '1.2.3.129')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/26', IPADDRESS '1.2.5.1')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/32', IPADDRESS '1.2.3.128')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/0', IPADDRESS '192.168.5.1')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '64:ff9b::17/64', IPADDRESS '64:ff9b::ffff:ff')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '64:ff9b::17/64', IPADDRESS '64:ffff::17')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '192.168.3.131/26', IPPREFIX '192.168.3.144/30')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/26', IPPREFIX '1.2.5.1/30')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '1.2.3.128/26', IPPREFIX '1.2.3.128/26')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '64:ff9b::17/64', IPPREFIX '64:ff9b::ff:25/80')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '64:ff9b::17/64', IPPREFIX '64:ffff::17/64')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '2804:431:b000::/37', IPPREFIX '2804:431:b000::/38')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '2804:431:b000::/38', IPPREFIX '2804:431:b000::/37')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '170.0.52.0/22', IPPREFIX '170.0.52.0/24')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IS_SUBNET_OF(IPPREFIX '170.0.52.0/24', IPPREFIX '170.0.52.0/22')", (Type)BooleanType.BOOLEAN, false);
    }
}

