/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.util.JsonUtil;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJsonHashTable {
    private static final long SEED = 3078728941L;
    private static final int NUM_ROUNDS = 100000;
    private static final int NUM_RANDOM_VALUES_IN_ROUND = 5;
    private static final int NUM_EXISTING_VALUES_IN_ROUND = 5;

    @Test
    public void testBigint() {
        Random rand = new Random(3078728941L);
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1000000);
        JsonUtil.HashTable hashTable = new JsonUtil.HashTable((Type)BigintType.BIGINT, blockBuilder);
        HashSet<Long> valueSet = new HashSet<Long>();
        ArrayList<Long> valueList = new ArrayList<Long>();
        for (int i = 0; i < 100000; ++i) {
            long value;
            int j;
            for (j = 0; j < 5; ++j) {
                value = rand.nextLong();
                BigintType.BIGINT.writeLong(blockBuilder, value);
                if (valueSet.contains(value)) {
                    Assert.assertTrue((boolean)hashTable.contains(blockBuilder.getPositionCount() - 1));
                    Assert.assertFalse((boolean)hashTable.addIfAbsent(blockBuilder.getPositionCount() - 1));
                    continue;
                }
                valueSet.add(value);
                valueList.add(value);
                Assert.assertFalse((boolean)hashTable.contains(blockBuilder.getPositionCount() - 1));
                Assert.assertTrue((boolean)hashTable.addIfAbsent(blockBuilder.getPositionCount() - 1));
            }
            for (j = 0; j < 5; ++j) {
                value = (Long)valueList.get(rand.nextInt(valueList.size()));
                BigintType.BIGINT.writeLong(blockBuilder, value);
                Assert.assertTrue((boolean)hashTable.contains(blockBuilder.getPositionCount() - 1));
                Assert.assertFalse((boolean)hashTable.addIfAbsent(blockBuilder.getPositionCount() - 1));
            }
        }
    }

    @Test
    public void testVarchar() {
        Random rand = new Random(3078728941L);
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1000000);
        JsonUtil.HashTable hashTable = new JsonUtil.HashTable((Type)VarcharType.VARCHAR, blockBuilder);
        HashSet<Slice> valueSet = new HashSet<Slice>();
        ArrayList<Slice> valueList = new ArrayList<Slice>();
        for (int i = 0; i < 100000; ++i) {
            Slice value;
            int j;
            for (j = 0; j < 5; ++j) {
                value = this.generateRandomSlice(rand, 10);
                VarcharType.VARCHAR.writeSlice(blockBuilder, value);
                if (valueSet.contains(value)) {
                    Assert.assertTrue((boolean)hashTable.contains(blockBuilder.getPositionCount() - 1));
                    Assert.assertFalse((boolean)hashTable.addIfAbsent(blockBuilder.getPositionCount() - 1));
                    continue;
                }
                valueSet.add(value);
                valueList.add(value);
                Assert.assertFalse((boolean)hashTable.contains(blockBuilder.getPositionCount() - 1));
                Assert.assertTrue((boolean)hashTable.addIfAbsent(blockBuilder.getPositionCount() - 1));
            }
            for (j = 0; j < 5; ++j) {
                value = (Slice)valueList.get(rand.nextInt(valueList.size()));
                VarcharType.VARCHAR.writeSlice(blockBuilder, value);
                Assert.assertTrue((boolean)hashTable.contains(blockBuilder.getPositionCount() - 1));
                Assert.assertFalse((boolean)hashTable.addIfAbsent(blockBuilder.getPositionCount() - 1));
            }
        }
    }

    private Slice generateRandomSlice(Random rand, int maxSliceLength) {
        int length = rand.nextInt(maxSliceLength) + 1;
        byte[] randomBytes = new byte[length];
        rand.nextBytes(randomBytes);
        return Slices.wrappedBuffer((byte[])randomBytes);
    }
}

