/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Joiner;
import java.util.Collections;
import org.testng.annotations.Test;

public class TestMathFunctions
extends AbstractTestFunctions {
    private static final double[] DOUBLE_VALUES = new double[]{123.0, -123.0, 123.45, -123.45, 0.0};
    private static final int[] intLefts = new int[]{9, 10, 11, -9, -10, -11, 0};
    private static final int[] intRights = new int[]{3, -3};
    private static final double[] doubleLefts = new double[]{9.0, 10.0, 11.0, -9.0, -10.0, -11.0, 9.1, 10.1, 11.1, -9.1, -10.1, -11.1};
    private static final double[] doubleRights = new double[]{3.0, -3.0, 3.1, -3.1};
    private static final double GREATEST_DOUBLE_LESS_THAN_HALF = 0.49999999999999994;

    @Test
    public void testAbs() {
        this.assertFunction("abs(TINYINT'123')", (Type)TinyintType.TINYINT, (byte)123);
        this.assertFunction("abs(TINYINT'-123')", (Type)TinyintType.TINYINT, (byte)123);
        this.assertFunction("abs(CAST(NULL AS TINYINT))", (Type)TinyintType.TINYINT, null);
        this.assertFunction("abs(SMALLINT'123')", (Type)SmallintType.SMALLINT, (short)123);
        this.assertFunction("abs(SMALLINT'-123')", (Type)SmallintType.SMALLINT, (short)123);
        this.assertFunction("abs(CAST(NULL AS SMALLINT))", (Type)SmallintType.SMALLINT, null);
        this.assertFunction("abs(123)", (Type)IntegerType.INTEGER, 123);
        this.assertFunction("abs(-123)", (Type)IntegerType.INTEGER, 123);
        this.assertFunction("abs(CAST(NULL AS INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("abs(BIGINT '123')", (Type)BigintType.BIGINT, 123L);
        this.assertFunction("abs(BIGINT '-123')", (Type)BigintType.BIGINT, 123L);
        this.assertFunction("abs(12300000000)", (Type)BigintType.BIGINT, 12300000000L);
        this.assertFunction("abs(-12300000000)", (Type)BigintType.BIGINT, 12300000000L);
        this.assertFunction("abs(CAST(NULL AS BIGINT))", (Type)BigintType.BIGINT, null);
        this.assertFunction("abs(123.0E0)", (Type)DoubleType.DOUBLE, 123.0);
        this.assertFunction("abs(-123.0E0)", (Type)DoubleType.DOUBLE, 123.0);
        this.assertFunction("abs(123.45E0)", (Type)DoubleType.DOUBLE, 123.45);
        this.assertFunction("abs(-123.45E0)", (Type)DoubleType.DOUBLE, 123.45);
        this.assertFunction("abs(CAST(NULL AS DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("abs(REAL '-754.1985')", (Type)RealType.REAL, Float.valueOf(754.1985f));
        this.assertInvalidFunction("abs(TINYINT'-128')", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("abs(SMALLINT'-32768')", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("abs(INTEGER'-2147483648')", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("abs(-9223372036854775807 - if(rand() < 10, 1, 1))", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertFunction("abs(DECIMAL '123.45')", (Type)DecimalType.createDecimalType((int)5, (int)2), SqlDecimal.of((String)"12345", (int)5, (int)2));
        this.assertFunction("abs(DECIMAL '-123.45')", (Type)DecimalType.createDecimalType((int)5, (int)2), SqlDecimal.of((String)"12345", (int)5, (int)2));
        this.assertFunction("abs(DECIMAL '1234567890123456.78')", (Type)DecimalType.createDecimalType((int)18, (int)2), SqlDecimal.of((String)"123456789012345678", (int)18, (int)2));
        this.assertFunction("abs(DECIMAL '-1234567890123456.78')", (Type)DecimalType.createDecimalType((int)18, (int)2), SqlDecimal.of((String)"123456789012345678", (int)18, (int)2));
        this.assertFunction("abs(DECIMAL '12345678901234560.78')", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"1234567890123456078", (int)18, (int)2));
        this.assertFunction("abs(DECIMAL '-12345678901234560.78')", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"1234567890123456078", (int)18, (int)2));
        this.assertFunction("abs(CAST(NULL AS DECIMAL(1,0)))", (Type)DecimalType.createDecimalType((int)1, (int)0), null);
    }

    @Test
    public void testAcos() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("acos(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.acos(doubleValue));
            this.assertFunction("acos(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.acos((float)doubleValue));
        }
        this.assertFunction("acos(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testAsin() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("asin(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.asin(doubleValue));
            this.assertFunction("asin(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.asin((float)doubleValue));
        }
        this.assertFunction("asin(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testAtan() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("atan(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.atan(doubleValue));
            this.assertFunction("atan(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.atan((float)doubleValue));
        }
        this.assertFunction("atan(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testAtan2() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("atan2(" + doubleValue + ", " + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.atan2(doubleValue, doubleValue));
            this.assertFunction("atan2(REAL '" + (float)doubleValue + "', REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.atan2((float)doubleValue, (float)doubleValue));
        }
        this.assertFunction("atan2(NULL, NULL)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("atan2(1.0E0, NULL)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("atan2(NULL, 1.0E0)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testCbrt() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("cbrt(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.cbrt(doubleValue));
            this.assertFunction("cbrt(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.cbrt((float)doubleValue));
        }
        this.assertFunction("cbrt(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testCeil() {
        this.assertFunction("ceil(TINYINT'123')", (Type)TinyintType.TINYINT, (byte)123);
        this.assertFunction("ceil(TINYINT'-123')", (Type)TinyintType.TINYINT, (byte)-123);
        this.assertFunction("ceil(CAST(NULL AS TINYINT))", (Type)TinyintType.TINYINT, null);
        this.assertFunction("ceil(SMALLINT'123')", (Type)SmallintType.SMALLINT, (short)123);
        this.assertFunction("ceil(SMALLINT'-123')", (Type)SmallintType.SMALLINT, (short)-123);
        this.assertFunction("ceil(CAST(NULL AS SMALLINT))", (Type)SmallintType.SMALLINT, null);
        this.assertFunction("ceil(123)", (Type)IntegerType.INTEGER, 123);
        this.assertFunction("ceil(-123)", (Type)IntegerType.INTEGER, -123);
        this.assertFunction("ceil(CAST(NULL AS INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("ceil(BIGINT '123')", (Type)BigintType.BIGINT, 123L);
        this.assertFunction("ceil(BIGINT '-123')", (Type)BigintType.BIGINT, -123L);
        this.assertFunction("ceil(12300000000)", (Type)BigintType.BIGINT, 12300000000L);
        this.assertFunction("ceil(-12300000000)", (Type)BigintType.BIGINT, -12300000000L);
        this.assertFunction("ceil(CAST(NULL as BIGINT))", (Type)BigintType.BIGINT, null);
        this.assertFunction("ceil(123.0E0)", (Type)DoubleType.DOUBLE, 123.0);
        this.assertFunction("ceil(-123.0E0)", (Type)DoubleType.DOUBLE, -123.0);
        this.assertFunction("ceil(123.45E0)", (Type)DoubleType.DOUBLE, 124.0);
        this.assertFunction("ceil(-123.45E0)", (Type)DoubleType.DOUBLE, -123.0);
        this.assertFunction("ceil(CAST(NULL as DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("ceil(REAL '123.0')", (Type)RealType.REAL, Float.valueOf(123.0f));
        this.assertFunction("ceil(REAL '-123.0')", (Type)RealType.REAL, Float.valueOf(-123.0f));
        this.assertFunction("ceil(REAL '123.45')", (Type)RealType.REAL, Float.valueOf(124.0f));
        this.assertFunction("ceil(REAL '-123.45')", (Type)RealType.REAL, Float.valueOf(-123.0f));
        this.assertFunction("ceiling(12300000000)", (Type)BigintType.BIGINT, 12300000000L);
        this.assertFunction("ceiling(-12300000000)", (Type)BigintType.BIGINT, -12300000000L);
        this.assertFunction("ceiling(CAST(NULL AS BIGINT))", (Type)BigintType.BIGINT, null);
        this.assertFunction("ceiling(123.0E0)", (Type)DoubleType.DOUBLE, 123.0);
        this.assertFunction("ceiling(-123.0E0)", (Type)DoubleType.DOUBLE, -123.0);
        this.assertFunction("ceiling(123.45E0)", (Type)DoubleType.DOUBLE, 124.0);
        this.assertFunction("ceiling(-123.45E0)", (Type)DoubleType.DOUBLE, -123.0);
        this.assertFunction("ceiling(REAL '123.0')", (Type)RealType.REAL, Float.valueOf(123.0f));
        this.assertFunction("ceiling(REAL '-123.0')", (Type)RealType.REAL, Float.valueOf(-123.0f));
        this.assertFunction("ceiling(REAL '123.45')", (Type)RealType.REAL, Float.valueOf(124.0f));
        this.assertFunction("ceiling(REAL '-123.45')", (Type)RealType.REAL, Float.valueOf(-123.0f));
        this.assertFunction("ceiling(DECIMAL '0')", (Type)DecimalType.createDecimalType((int)1), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '0.00' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '0.00' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '0.01' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"1"));
        this.assertFunction("ceiling(CAST(DECIMAL '-0.01' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '0.49' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"1"));
        this.assertFunction("ceiling(CAST(DECIMAL '-0.49' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '0.50' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"1"));
        this.assertFunction("ceiling(CAST(DECIMAL '-0.50' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '0.99' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"1"));
        this.assertFunction("ceiling(CAST(DECIMAL '-0.99' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(DECIMAL '123')", (Type)DecimalType.createDecimalType((int)3), SqlDecimal.of((String)"123"));
        this.assertFunction("ceiling(DECIMAL '-123')", (Type)DecimalType.createDecimalType((int)3), SqlDecimal.of((String)"-123"));
        this.assertFunction("ceiling(DECIMAL '123.00')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"123"));
        this.assertFunction("ceiling(DECIMAL '-123.00')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-123"));
        this.assertFunction("ceiling(DECIMAL '123.01')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"124"));
        this.assertFunction("ceiling(DECIMAL '-123.01')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-123"));
        this.assertFunction("ceiling(DECIMAL '123.45')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"124"));
        this.assertFunction("ceiling(DECIMAL '-123.45')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-123"));
        this.assertFunction("ceiling(DECIMAL '123.49')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"124"));
        this.assertFunction("ceiling(DECIMAL '-123.49')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-123"));
        this.assertFunction("ceiling(DECIMAL '123.50')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"124"));
        this.assertFunction("ceiling(DECIMAL '-123.50')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-123"));
        this.assertFunction("ceiling(DECIMAL '123.99')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"124"));
        this.assertFunction("ceiling(DECIMAL '-123.99')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-123"));
        this.assertFunction("ceiling(DECIMAL '999.9')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"1000"));
        this.assertFunction("ceiling(CAST(DECIMAL '0000000000000000000' AS DECIMAL(19,0)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '000000000000000000.00' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '000000000000000000.01' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"1"));
        this.assertFunction("ceiling(CAST(DECIMAL '-000000000000000000.01' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '000000000000000000.49' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"1"));
        this.assertFunction("ceiling(CAST(DECIMAL '-000000000000000000.49' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '000000000000000000.50' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"1"));
        this.assertFunction("ceiling(CAST(DECIMAL '-000000000000000000.50' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(CAST(DECIMAL '000000000000000000.99' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"1"));
        this.assertFunction("ceiling(CAST(DECIMAL '-000000000000000000.99' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("ceiling(DECIMAL '123456789012345678')", (Type)DecimalType.createDecimalType((int)18), SqlDecimal.of((String)"123456789012345678"));
        this.assertFunction("ceiling(DECIMAL '-123456789012345678')", (Type)DecimalType.createDecimalType((int)18), SqlDecimal.of((String)"-123456789012345678"));
        this.assertFunction("ceiling(DECIMAL '123456789012345678.00')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345678"));
        this.assertFunction("ceiling(DECIMAL '-123456789012345678.00')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345678"));
        this.assertFunction("ceiling(DECIMAL '123456789012345678.01')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345679"));
        this.assertFunction("ceiling(DECIMAL '-123456789012345678.01')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345678"));
        this.assertFunction("ceiling(DECIMAL '123456789012345678.99')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345679"));
        this.assertFunction("ceiling(DECIMAL '-123456789012345678.99')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345678"));
        this.assertFunction("ceiling(DECIMAL '123456789012345678.49')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345679"));
        this.assertFunction("ceiling(DECIMAL '-123456789012345678.49')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345678"));
        this.assertFunction("ceiling(DECIMAL '123456789012345678.50')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345679"));
        this.assertFunction("ceiling(DECIMAL '-123456789012345678.50')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345678"));
        this.assertFunction("ceiling(DECIMAL '999999999999999999.9')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"1000000000000000000"));
        this.assertFunction("ceiling(DECIMAL '1234567890123456.78')", (Type)DecimalType.createDecimalType((int)17), SqlDecimal.of((String)"1234567890123457"));
        this.assertFunction("ceiling(DECIMAL '-1234567890123456.78')", (Type)DecimalType.createDecimalType((int)17), SqlDecimal.of((String)"-1234567890123456"));
        this.assertFunction("ceiling(CAST(NULL AS DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("ceiling(CAST(NULL AS REAL))", (Type)RealType.REAL, null);
        this.assertFunction("ceiling(CAST(NULL AS DECIMAL(1,0)))", (Type)DecimalType.createDecimalType((int)1), null);
        this.assertFunction("ceiling(CAST(NULL AS DECIMAL(25,5)))", (Type)DecimalType.createDecimalType((int)21), null);
    }

    @Test
    public void testTruncate() {
        String maxDouble = Double.toString(Double.MAX_VALUE);
        String minDouble = Double.toString(-1.7976931348623157E308);
        this.assertFunction("truncate(17.18E0)", (Type)DoubleType.DOUBLE, 17.0);
        this.assertFunction("truncate(-17.18E0)", (Type)DoubleType.DOUBLE, -17.0);
        this.assertFunction("truncate(17.88E0)", (Type)DoubleType.DOUBLE, 17.0);
        this.assertFunction("truncate(-17.88E0)", (Type)DoubleType.DOUBLE, -17.0);
        this.assertFunction("truncate(REAL '17.18')", (Type)RealType.REAL, Float.valueOf(17.0f));
        this.assertFunction("truncate(REAL '-17.18')", (Type)RealType.REAL, Float.valueOf(-17.0f));
        this.assertFunction("truncate(REAL '17.88')", (Type)RealType.REAL, Float.valueOf(17.0f));
        this.assertFunction("truncate(REAL '-17.88')", (Type)RealType.REAL, Float.valueOf(-17.0f));
        this.assertFunction("truncate(DOUBLE '" + maxDouble + "')", (Type)DoubleType.DOUBLE, Double.MAX_VALUE);
        this.assertFunction("truncate(DOUBLE '" + minDouble + "')", (Type)DoubleType.DOUBLE, -1.7976931348623157E308);
        this.assertFunction("truncate(DECIMAL '1234')", (Type)DecimalType.createDecimalType((int)4, (int)0), SqlDecimal.of((String)"1234"));
        this.assertFunction("truncate(DECIMAL '-1234')", (Type)DecimalType.createDecimalType((int)4, (int)0), SqlDecimal.of((String)"-1234"));
        this.assertFunction("truncate(DECIMAL '1234.56')", (Type)DecimalType.createDecimalType((int)4, (int)0), SqlDecimal.of((String)"1234"));
        this.assertFunction("truncate(DECIMAL '-1234.56')", (Type)DecimalType.createDecimalType((int)4, (int)0), SqlDecimal.of((String)"-1234"));
        this.assertFunction("truncate(DECIMAL '123456789123456.999')", (Type)DecimalType.createDecimalType((int)15, (int)0), SqlDecimal.of((String)"123456789123456"));
        this.assertFunction("truncate(DECIMAL '-123456789123456.999')", (Type)DecimalType.createDecimalType((int)15, (int)0), SqlDecimal.of((String)"-123456789123456"));
        this.assertFunction("truncate(DECIMAL '1.99999999999999999999999999')", (Type)DecimalType.createDecimalType((int)1, (int)0), SqlDecimal.of((String)"1"));
        this.assertFunction("truncate(DECIMAL '-1.99999999999999999999999999')", (Type)DecimalType.createDecimalType((int)1, (int)0), SqlDecimal.of((String)"-1"));
        this.assertFunction("truncate(DECIMAL '1234567890123456789012')", (Type)DecimalType.createDecimalType((int)22, (int)0), SqlDecimal.of((String)"1234567890123456789012"));
        this.assertFunction("truncate(DECIMAL '-1234567890123456789012')", (Type)DecimalType.createDecimalType((int)22, (int)0), SqlDecimal.of((String)"-1234567890123456789012"));
        this.assertFunction("truncate(DECIMAL '1234567890123456789012.999')", (Type)DecimalType.createDecimalType((int)22, (int)0), SqlDecimal.of((String)"1234567890123456789012"));
        this.assertFunction("truncate(DECIMAL '-1234567890123456789012.999')", (Type)DecimalType.createDecimalType((int)22, (int)0), SqlDecimal.of((String)"-1234567890123456789012"));
        this.assertFunction("truncate(DECIMAL '1234', 1)", (Type)DecimalType.createDecimalType((int)4, (int)0), SqlDecimal.of((String)"1234"));
        this.assertFunction("truncate(DECIMAL '1234', -1)", (Type)DecimalType.createDecimalType((int)4, (int)0), SqlDecimal.of((String)"1230"));
        this.assertFunction("truncate(DECIMAL '1234.56', 1)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"1234.50"));
        this.assertFunction("truncate(DECIMAL '1234.56', -1)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"1230.00"));
        this.assertFunction("truncate(DECIMAL '-1234.56', 1)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"-1234.50"));
        this.assertFunction("truncate(DECIMAL '1239.99', 1)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"1239.90"));
        this.assertFunction("truncate(DECIMAL '-1239.99', 1)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"-1239.90"));
        this.assertFunction("truncate(DECIMAL '1239.999', 2)", (Type)DecimalType.createDecimalType((int)7, (int)3), SqlDecimal.of((String)"1239.990"));
        this.assertFunction("truncate(DECIMAL '1239.999', -2)", (Type)DecimalType.createDecimalType((int)7, (int)3), SqlDecimal.of((String)"1200.000"));
        this.assertFunction("truncate(DECIMAL '123456789123456.999', 2)", (Type)DecimalType.createDecimalType((int)18, (int)3), SqlDecimal.of((String)"123456789123456.990"));
        this.assertFunction("truncate(DECIMAL '123456789123456.999', -2)", (Type)DecimalType.createDecimalType((int)18, (int)3), SqlDecimal.of((String)"123456789123400.000"));
        this.assertFunction("truncate(DECIMAL '1234', -4)", (Type)DecimalType.createDecimalType((int)4, (int)0), SqlDecimal.of((String)"0000"));
        this.assertFunction("truncate(DECIMAL '1234.56', -4)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"0000.00"));
        this.assertFunction("truncate(DECIMAL '-1234.56', -4)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"0000.00"));
        this.assertFunction("truncate(DECIMAL '1234.56', 3)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"1234.56"));
        this.assertFunction("truncate(DECIMAL '-1234.56', 3)", (Type)DecimalType.createDecimalType((int)6, (int)2), SqlDecimal.of((String)"-1234.56"));
        this.assertFunction("truncate(DECIMAL '1234567890123456789012', 1)", (Type)DecimalType.createDecimalType((int)22, (int)0), SqlDecimal.of((String)"1234567890123456789012"));
        this.assertFunction("truncate(DECIMAL '1234567890123456789012', -1)", (Type)DecimalType.createDecimalType((int)22, (int)0), SqlDecimal.of((String)"1234567890123456789010"));
        this.assertFunction("truncate(DECIMAL '1234567890123456789012.23', 1)", (Type)DecimalType.createDecimalType((int)24, (int)2), SqlDecimal.of((String)"1234567890123456789012.20"));
        this.assertFunction("truncate(DECIMAL '1234567890123456789012.23', -1)", (Type)DecimalType.createDecimalType((int)24, (int)2), SqlDecimal.of((String)"1234567890123456789010.00"));
        this.assertFunction("truncate(DECIMAL '123456789012345678999.99', -1)", (Type)DecimalType.createDecimalType((int)23, (int)2), SqlDecimal.of((String)"123456789012345678990.00"));
        this.assertFunction("truncate(DECIMAL '-123456789012345678999.99', -1)", (Type)DecimalType.createDecimalType((int)23, (int)2), SqlDecimal.of((String)"-123456789012345678990.00"));
        this.assertFunction("truncate(DECIMAL '123456789012345678999.999', 2)", (Type)DecimalType.createDecimalType((int)24, (int)3), SqlDecimal.of((String)"123456789012345678999.990"));
        this.assertFunction("truncate(DECIMAL '123456789012345678999.999', -2)", (Type)DecimalType.createDecimalType((int)24, (int)3), SqlDecimal.of((String)"123456789012345678900.000"));
        this.assertFunction("truncate(DECIMAL '123456789012345678901', -21)", (Type)DecimalType.createDecimalType((int)21, (int)0), SqlDecimal.of((String)"000000000000000000000"));
        this.assertFunction("truncate(DECIMAL '123456789012345678901.23', -21)", (Type)DecimalType.createDecimalType((int)23, (int)2), SqlDecimal.of((String)"000000000000000000000.00"));
        this.assertFunction("truncate(DECIMAL '123456789012345678901.23', 3)", (Type)DecimalType.createDecimalType((int)23, (int)2), SqlDecimal.of((String)"123456789012345678901.23"));
        this.assertFunction("truncate(DECIMAL '-123456789012345678901.23', 3)", (Type)DecimalType.createDecimalType((int)23, (int)2), SqlDecimal.of((String)"-123456789012345678901.23"));
        this.assertFunction("truncate(CAST(NULL AS DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("truncate(CAST(NULL AS DECIMAL(1,0)), -1)", (Type)DecimalType.createDecimalType((int)1, (int)0), null);
        this.assertFunction("truncate(CAST(NULL AS DECIMAL(1,0)))", (Type)DecimalType.createDecimalType((int)1, (int)0), null);
        this.assertFunction("truncate(CAST(NULL AS DECIMAL(18,5)))", (Type)DecimalType.createDecimalType((int)13, (int)0), null);
        this.assertFunction("truncate(CAST(NULL AS DECIMAL(25,2)))", (Type)DecimalType.createDecimalType((int)23, (int)0), null);
        this.assertFunction("truncate(NULL, NULL)", (Type)DecimalType.createDecimalType((int)1, (int)0), null);
    }

    @Test
    public void testCos() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("cos(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.cos(doubleValue));
            this.assertFunction("cos(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.cos((float)doubleValue));
        }
        this.assertFunction("cos(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testCosh() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("cosh(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.cosh(doubleValue));
            this.assertFunction("cosh(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.cosh((float)doubleValue));
        }
        this.assertFunction("cosh(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testDegrees() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction(String.format("degrees(%s)", doubleValue), (Type)DoubleType.DOUBLE, Math.toDegrees(doubleValue));
            this.assertFunction(String.format("degrees(REAL '%s')", Float.valueOf((float)doubleValue)), (Type)DoubleType.DOUBLE, Math.toDegrees((float)doubleValue));
        }
        this.assertFunction("degrees(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testE() {
        this.assertFunction("e()", (Type)DoubleType.DOUBLE, Math.E);
    }

    @Test
    public void testExp() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("exp(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.exp(doubleValue));
            this.assertFunction("exp(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.exp((float)doubleValue));
        }
        this.assertFunction("exp(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testFloor() {
        this.assertFunction("floor(TINYINT'123')", (Type)TinyintType.TINYINT, (byte)123);
        this.assertFunction("floor(TINYINT'-123')", (Type)TinyintType.TINYINT, (byte)-123);
        this.assertFunction("floor(CAST(NULL AS TINYINT))", (Type)TinyintType.TINYINT, null);
        this.assertFunction("floor(SMALLINT'123')", (Type)SmallintType.SMALLINT, (short)123);
        this.assertFunction("floor(SMALLINT'-123')", (Type)SmallintType.SMALLINT, (short)-123);
        this.assertFunction("floor(CAST(NULL AS SMALLINT))", (Type)SmallintType.SMALLINT, null);
        this.assertFunction("floor(123)", (Type)IntegerType.INTEGER, 123);
        this.assertFunction("floor(-123)", (Type)IntegerType.INTEGER, -123);
        this.assertFunction("floor(CAST(NULL AS INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("floor(BIGINT '123')", (Type)BigintType.BIGINT, 123L);
        this.assertFunction("floor(BIGINT '-123')", (Type)BigintType.BIGINT, -123L);
        this.assertFunction("floor(12300000000)", (Type)BigintType.BIGINT, 12300000000L);
        this.assertFunction("floor(-12300000000)", (Type)BigintType.BIGINT, -12300000000L);
        this.assertFunction("floor(CAST(NULL as BIGINT))", (Type)BigintType.BIGINT, null);
        this.assertFunction("floor(123.0E0)", (Type)DoubleType.DOUBLE, 123.0);
        this.assertFunction("floor(-123.0E0)", (Type)DoubleType.DOUBLE, -123.0);
        this.assertFunction("floor(123.45E0)", (Type)DoubleType.DOUBLE, 123.0);
        this.assertFunction("floor(-123.45E0)", (Type)DoubleType.DOUBLE, -124.0);
        this.assertFunction("floor(REAL '123.0')", (Type)RealType.REAL, Float.valueOf(123.0f));
        this.assertFunction("floor(REAL '-123.0')", (Type)RealType.REAL, Float.valueOf(-123.0f));
        this.assertFunction("floor(REAL '123.45')", (Type)RealType.REAL, Float.valueOf(123.0f));
        this.assertFunction("floor(REAL '-123.45')", (Type)RealType.REAL, Float.valueOf(-124.0f));
        this.assertFunction("floor(DECIMAL '0')", (Type)DecimalType.createDecimalType((int)1), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '0.00' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '0.00' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '0.01' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '-0.01' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"-1"));
        this.assertFunction("floor(CAST(DECIMAL '0.49' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '-0.49' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"-1"));
        this.assertFunction("floor(CAST(DECIMAL '0.50' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '-0.50' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"-1"));
        this.assertFunction("floor(CAST(DECIMAL '0.99' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '-0.99' AS DECIMAL(3,2)))", (Type)DecimalType.createDecimalType((int)2), SqlDecimal.of((String)"-1"));
        this.assertFunction("floor(DECIMAL '123')", (Type)DecimalType.createDecimalType((int)3), SqlDecimal.of((String)"123"));
        this.assertFunction("floor(DECIMAL '-123')", (Type)DecimalType.createDecimalType((int)3), SqlDecimal.of((String)"-123"));
        this.assertFunction("floor(DECIMAL '123.00')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"123"));
        this.assertFunction("floor(DECIMAL '-123.00')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-123"));
        this.assertFunction("floor(DECIMAL '123.01')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"123"));
        this.assertFunction("floor(DECIMAL '-123.01')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-124"));
        this.assertFunction("floor(DECIMAL '123.45')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"123"));
        this.assertFunction("floor(DECIMAL '-123.45')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-124"));
        this.assertFunction("floor(DECIMAL '123.49')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"123"));
        this.assertFunction("floor(DECIMAL '-123.49')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-124"));
        this.assertFunction("floor(DECIMAL '123.50')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"123"));
        this.assertFunction("floor(DECIMAL '-123.50')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-124"));
        this.assertFunction("floor(DECIMAL '123.99')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"123"));
        this.assertFunction("floor(DECIMAL '-123.99')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-124"));
        this.assertFunction("floor(DECIMAL '-999.9')", (Type)DecimalType.createDecimalType((int)4), SqlDecimal.of((String)"-1000"));
        this.assertFunction("floor(CAST(DECIMAL '0000000000000000000' AS DECIMAL(19,0)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '000000000000000000.00' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '000000000000000000.01' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '-000000000000000000.01' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-1"));
        this.assertFunction("floor(CAST(DECIMAL '000000000000000000.49' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '-000000000000000000.49' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-1"));
        this.assertFunction("floor(CAST(DECIMAL '000000000000000000.50' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '-000000000000000000.50' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-1"));
        this.assertFunction("floor(CAST(DECIMAL '000000000000000000.99' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"0"));
        this.assertFunction("floor(CAST(DECIMAL '-000000000000000000.99' AS DECIMAL(20,2)))", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-1"));
        this.assertFunction("floor(DECIMAL '123456789012345678')", (Type)DecimalType.createDecimalType((int)18), SqlDecimal.of((String)"123456789012345678"));
        this.assertFunction("floor(DECIMAL '-123456789012345678')", (Type)DecimalType.createDecimalType((int)18), SqlDecimal.of((String)"-123456789012345678"));
        this.assertFunction("floor(DECIMAL '123456789012345678.00')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345678"));
        this.assertFunction("floor(DECIMAL '-123456789012345678.00')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345678"));
        this.assertFunction("floor(DECIMAL '123456789012345678.01')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345678"));
        this.assertFunction("floor(DECIMAL '-123456789012345678.01')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345679"));
        this.assertFunction("floor(DECIMAL '123456789012345678.99')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345678"));
        this.assertFunction("floor(DECIMAL '-123456789012345678.49')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345679"));
        this.assertFunction("floor(DECIMAL '123456789012345678.49')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345678"));
        this.assertFunction("floor(DECIMAL '-123456789012345678.50')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345679"));
        this.assertFunction("floor(DECIMAL '123456789012345678.50')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"123456789012345678"));
        this.assertFunction("floor(DECIMAL '-123456789012345678.99')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-123456789012345679"));
        this.assertFunction("floor(DECIMAL '-999999999999999999.9')", (Type)DecimalType.createDecimalType((int)19), SqlDecimal.of((String)"-1000000000000000000"));
        this.assertFunction("floor(DECIMAL '1234567890123456.78')", (Type)DecimalType.createDecimalType((int)17), SqlDecimal.of((String)"1234567890123456"));
        this.assertFunction("floor(DECIMAL '-1234567890123456.78')", (Type)DecimalType.createDecimalType((int)17), SqlDecimal.of((String)"-1234567890123457"));
        this.assertFunction("floor(CAST(NULL as REAL))", (Type)RealType.REAL, null);
        this.assertFunction("floor(CAST(NULL as DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("floor(CAST(NULL as DECIMAL(1,0)))", (Type)DecimalType.createDecimalType((int)1), null);
        this.assertFunction("floor(CAST(NULL as DECIMAL(25,5)))", (Type)DecimalType.createDecimalType((int)21), null);
    }

    @Test
    public void testLn() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("ln(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.log(doubleValue));
        }
        this.assertFunction("ln(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testLog2() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("log2(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.log(doubleValue) / Math.log(2.0));
        }
        this.assertFunction("log2(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testLog10() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("log10(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.log10(doubleValue));
        }
        this.assertFunction("log10(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testLog() {
        for (double doubleValue : DOUBLE_VALUES) {
            for (double base : DOUBLE_VALUES) {
                this.assertFunction("log(" + doubleValue + ", " + base + ")", (Type)DoubleType.DOUBLE, Math.log(doubleValue) / Math.log(base));
                this.assertFunction("log(REAL '" + (float)doubleValue + "', REAL'" + (float)base + "')", (Type)DoubleType.DOUBLE, Math.log((float)doubleValue) / Math.log((float)base));
            }
        }
        this.assertFunction("log(NULL, NULL)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("log(5.0E0, NULL)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("log(NULL, 5.0E0)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testMod() {
        long right;
        int right2;
        int n;
        int n2;
        for (int left : intLefts) {
            int[] nArray = intRights;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int right22 = nArray[n];
                this.assertFunction("mod(" + left + ", " + right22 + ")", (Type)IntegerType.INTEGER, left % right22);
            }
        }
        for (int left : intLefts) {
            int[] nArray = intRights;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                right2 = nArray[n];
                this.assertFunction("mod( BIGINT '" + left + "' , BIGINT '" + right2 + "')", (Type)BigintType.BIGINT, left % right2);
            }
        }
        int[] nArray = intLefts;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            long left = nArray[i];
            int[] nArray2 = intRights;
            n = nArray2.length;
            for (right2 = 0; right2 < n; ++right2) {
                right = nArray2[right2];
                this.assertFunction("mod(" + left * 10000000000L + ", " + right * 10000000000L + ")", (Type)BigintType.BIGINT, left * 10000000000L % (right * 10000000000L));
            }
        }
        for (int left : intLefts) {
            double[] dArray = doubleRights;
            int n4 = dArray.length;
            for (n = 0; n < n4; ++n) {
                double right3 = dArray[n];
                this.assertFunction("mod(" + left + ", DOUBLE '" + right3 + "')", (Type)DoubleType.DOUBLE, (double)left % right3);
            }
        }
        for (int left : intLefts) {
            for (double right4 : doubleRights) {
                this.assertFunction("mod(" + left + ", REAL '" + (float)right4 + "')", (Type)RealType.REAL, Float.valueOf((float)left % (float)right4));
            }
        }
        for (double left : doubleLefts) {
            int[] nArray3 = intRights;
            n = nArray3.length;
            for (int i = 0; i < n; ++i) {
                right = nArray3[i];
                this.assertFunction("mod(DOUBLE '" + left + "', " + right + ")", (Type)DoubleType.DOUBLE, left % (double)right);
            }
        }
        for (double left : doubleLefts) {
            int[] nArray4 = intRights;
            n = nArray4.length;
            for (int i = 0; i < n; ++i) {
                right = nArray4[i];
                this.assertFunction("mod(REAL '" + (float)left + "', " + right + ")", (Type)RealType.REAL, Float.valueOf((float)left % (float)right));
            }
        }
        for (double left : doubleLefts) {
            for (double right5 : doubleRights) {
                this.assertFunction("mod(DOUBLE '" + left + "', DOUBLE '" + right5 + "')", (Type)DoubleType.DOUBLE, left % right5);
            }
        }
        for (double left : doubleLefts) {
            for (double right6 : doubleRights) {
                this.assertFunction("mod(REAL '" + (float)left + "', REAL '" + (float)right6 + "')", (Type)RealType.REAL, Float.valueOf((float)left % (float)right6));
            }
        }
        this.assertFunction("mod(5.0E0, NULL)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("mod(NULL, 5.0E0)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("mod(DECIMAL '0.0', DECIMAL '2.0')", (Type)DecimalType.createDecimalType((int)1, (int)1), SqlDecimal.of((String)"0.0"));
        this.assertFunction("mod(DECIMAL '13.0', DECIMAL '5.0')", (Type)DecimalType.createDecimalType((int)2, (int)1), SqlDecimal.of((String)"3.0"));
        this.assertFunction("mod(DECIMAL '-13.0', DECIMAL '5.0')", (Type)DecimalType.createDecimalType((int)2, (int)1), SqlDecimal.of((String)"-3.0"));
        this.assertFunction("mod(DECIMAL '13.0', DECIMAL '-5.0')", (Type)DecimalType.createDecimalType((int)2, (int)1), SqlDecimal.of((String)"3.0"));
        this.assertFunction("mod(DECIMAL '-13.0', DECIMAL '-5.0')", (Type)DecimalType.createDecimalType((int)2, (int)1), SqlDecimal.of((String)"-3.0"));
        this.assertFunction("mod(DECIMAL '5.0', DECIMAL '2.5')", (Type)DecimalType.createDecimalType((int)2, (int)1), SqlDecimal.of((String)"0.0"));
        this.assertFunction("mod(DECIMAL '5.0', DECIMAL '2.05')", (Type)DecimalType.createDecimalType((int)3, (int)2), SqlDecimal.of((String)"0.90"));
        this.assertFunction("mod(DECIMAL '5.0', DECIMAL '2.55')", (Type)DecimalType.createDecimalType((int)3, (int)2), SqlDecimal.of((String)"2.45"));
        this.assertFunction("mod(DECIMAL '5.0001', DECIMAL '2.55')", (Type)DecimalType.createDecimalType((int)5, (int)4), SqlDecimal.of((String)"2.4501"));
        this.assertFunction("mod(DECIMAL '123456789012345670', DECIMAL '123456789012345669')", (Type)DecimalType.createDecimalType((int)18, (int)0), SqlDecimal.of((String)"0.01"));
        this.assertFunction("mod(DECIMAL '12345678901234567.90', DECIMAL '12345678901234567.89')", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"0.01"));
        this.assertFunction("mod(DECIMAL '5.0', CAST(NULL as DECIMAL(1,0)))", (Type)DecimalType.createDecimalType((int)2, (int)1), null);
        this.assertFunction("mod(CAST(NULL as DECIMAL(1,0)), DECIMAL '5.0')", (Type)DecimalType.createDecimalType((int)2, (int)1), null);
        this.assertInvalidFunction("mod(DECIMAL '5.0', DECIMAL '0')", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testPi() {
        this.assertFunction("pi()", (Type)DoubleType.DOUBLE, Math.PI);
    }

    @Test
    public void testNaN() {
        this.assertFunction("nan()", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("0.0E0 / 0.0E0", (Type)DoubleType.DOUBLE, Double.NaN);
    }

    @Test
    public void testInfinity() {
        this.assertFunction("infinity()", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("-rand() / 0.0", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testIsInfinite() {
        this.assertFunction("is_infinite(1.0E0 / 0.0E0)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_infinite(0.0E0 / 0.0E0)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("is_infinite(1.0E0 / 1.0E0)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("is_infinite(REAL '1.0' / REAL '0.0')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_infinite(REAL '0.0' / REAL '0.0')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("is_infinite(REAL '1.0' / REAL '1.0')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("is_infinite(NULL)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testIsFinite() {
        this.assertFunction("is_finite(100000)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_finite(rand() / 0.0E0)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("is_finite(REAL '754.2008E0')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_finite(rand() / REAL '0.0E0')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("is_finite(NULL)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testIsNaN() {
        this.assertFunction("is_nan(0.0E0 / 0.0E0)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_nan(0.0E0 / 1.0E0)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("is_nan(infinity() / infinity())", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_nan(nan())", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_nan(REAL '0.0' / REAL '0.0')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_nan(REAL '0.0' / 1.0E0)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("is_nan(infinity() / infinity())", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_nan(nan())", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("is_nan(NULL)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testPower() {
        long right;
        int n;
        int n2;
        int n3;
        int[] objectArray = intLefts;
        int n4 = objectArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            long left = objectArray[n3];
            int[] nArray = intRights;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                right = nArray[n];
                this.assertFunction("power(" + left + ", " + right + ")", (Type)DoubleType.DOUBLE, Math.pow(left, right));
            }
        }
        for (int left : intLefts) {
            for (int right2 : intRights) {
                this.assertFunction("power( BIGINT '" + left + "' , BIGINT '" + right2 + "')", (Type)DoubleType.DOUBLE, Math.pow(left, right2));
            }
        }
        int[] nArray = intLefts;
        n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            long left = nArray[n3];
            int[] nArray2 = intRights;
            n2 = nArray2.length;
            for (n = 0; n < n2; ++n) {
                right = nArray2[n];
                this.assertFunction("power(" + left * 10000000000L + ", " + right + ")", (Type)DoubleType.DOUBLE, Math.pow(left * 10000000000L, right));
            }
        }
        int[] nArray3 = intLefts;
        n4 = nArray3.length;
        for (n3 = 0; n3 < n4; ++n3) {
            long left = nArray3[n3];
            for (double right3 : doubleRights) {
                this.assertFunction("power(" + left + ", " + right3 + ")", (Type)DoubleType.DOUBLE, Math.pow(left, right3));
                this.assertFunction("power(" + left + ", REAL '" + (float)right3 + "')", (Type)DoubleType.DOUBLE, Math.pow(left, (float)right3));
            }
        }
        for (double left : doubleLefts) {
            int[] nArray4 = intRights;
            n2 = nArray4.length;
            for (n = 0; n < n2; ++n) {
                long right4 = nArray4[n];
                this.assertFunction("power(" + left + ", " + right4 + ")", (Type)DoubleType.DOUBLE, Math.pow(left, right4));
                this.assertFunction("power(REAL '" + (float)left + "', " + right4 + ")", (Type)DoubleType.DOUBLE, Math.pow((float)left, right4));
            }
        }
        for (double left : doubleLefts) {
            for (double right5 : doubleRights) {
                this.assertFunction("power(" + left + ", " + right5 + ")", (Type)DoubleType.DOUBLE, Math.pow(left, right5));
                this.assertFunction("power(REAL '" + left + "', REAL '" + right5 + "')", (Type)DoubleType.DOUBLE, Math.pow((float)left, (float)right5));
            }
        }
        this.assertFunction("power(NULL, NULL)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("power(5.0E0, NULL)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("power(NULL, 5.0E0)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("pow(5.0E0, 2.0E0)", (Type)DoubleType.DOUBLE, 25.0);
    }

    @Test
    public void testRadians() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction(String.format("radians(%s)", doubleValue), (Type)DoubleType.DOUBLE, Math.toRadians(doubleValue));
            this.assertFunction(String.format("radians(REAL '%s')", Float.valueOf((float)doubleValue)), (Type)DoubleType.DOUBLE, Math.toRadians((float)doubleValue));
        }
        this.assertFunction("radians(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testRandom() {
        this.functionAssertions.tryEvaluateWithAll("rand()", (Type)DoubleType.DOUBLE, SessionTestUtils.TEST_SESSION);
        this.functionAssertions.tryEvaluateWithAll("random()", (Type)DoubleType.DOUBLE, SessionTestUtils.TEST_SESSION);
        this.functionAssertions.tryEvaluateWithAll("rand(1000)", (Type)IntegerType.INTEGER, SessionTestUtils.TEST_SESSION);
        this.functionAssertions.tryEvaluateWithAll("random(2000)", (Type)IntegerType.INTEGER, SessionTestUtils.TEST_SESSION);
        this.functionAssertions.tryEvaluateWithAll("random(3000000000)", (Type)BigintType.BIGINT, SessionTestUtils.TEST_SESSION);
        this.assertInvalidFunction("rand(-1)", "bound must be positive");
        this.assertInvalidFunction("rand(-3000000000)", "bound must be positive");
    }

    @Test
    public void testRound() {
        this.assertFunction("round(TINYINT '3')", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("round(TINYINT '-3')", (Type)TinyintType.TINYINT, (byte)-3);
        this.assertFunction("round(CAST(NULL as TINYINT))", (Type)TinyintType.TINYINT, null);
        this.assertFunction("round(SMALLINT '3')", (Type)SmallintType.SMALLINT, (short)3);
        this.assertFunction("round(SMALLINT '-3')", (Type)SmallintType.SMALLINT, (short)-3);
        this.assertFunction("round(CAST(NULL as SMALLINT))", (Type)SmallintType.SMALLINT, null);
        this.assertFunction("round(3)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("round(-3)", (Type)IntegerType.INTEGER, -3);
        this.assertFunction("round(CAST(NULL as INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("round(BIGINT '3')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("round(BIGINT '-3')", (Type)BigintType.BIGINT, -3L);
        this.assertFunction("round(CAST(NULL as BIGINT))", (Type)BigintType.BIGINT, null);
        this.assertFunction("round( 3000000000)", (Type)BigintType.BIGINT, 3000000000L);
        this.assertFunction("round(-3000000000)", (Type)BigintType.BIGINT, -3000000000L);
        this.assertFunction("round(3.0E0)", (Type)DoubleType.DOUBLE, 3.0);
        this.assertFunction("round(-3.0E0)", (Type)DoubleType.DOUBLE, -3.0);
        this.assertFunction("round(3.499E0)", (Type)DoubleType.DOUBLE, 3.0);
        this.assertFunction("round(-3.499E0)", (Type)DoubleType.DOUBLE, -3.0);
        this.assertFunction("round(3.5E0)", (Type)DoubleType.DOUBLE, 4.0);
        this.assertFunction("round(-3.5E0)", (Type)DoubleType.DOUBLE, -4.0);
        this.assertFunction("round(-3.5001E0)", (Type)DoubleType.DOUBLE, -4.0);
        this.assertFunction("round(-3.99E0)", (Type)DoubleType.DOUBLE, -4.0);
        this.assertFunction("round(REAL '3.0')", (Type)RealType.REAL, Float.valueOf(3.0f));
        this.assertFunction("round(REAL '-3.0')", (Type)RealType.REAL, Float.valueOf(-3.0f));
        this.assertFunction("round(REAL '3.499')", (Type)RealType.REAL, Float.valueOf(3.0f));
        this.assertFunction("round(REAL '-3.499')", (Type)RealType.REAL, Float.valueOf(-3.0f));
        this.assertFunction("round(REAL '3.5')", (Type)RealType.REAL, Float.valueOf(4.0f));
        this.assertFunction("round(REAL '-3.5')", (Type)RealType.REAL, Float.valueOf(-4.0f));
        this.assertFunction("round(REAL '-3.5001')", (Type)RealType.REAL, Float.valueOf(-4.0f));
        this.assertFunction("round(REAL '-3.99')", (Type)RealType.REAL, Float.valueOf(-4.0f));
        this.assertFunction("round(CAST(NULL as DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("round(DOUBLE '0.49999999999999994')", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("round(DOUBLE '-0.5')", (Type)DoubleType.DOUBLE, -1.0);
        this.assertFunction("round(DOUBLE '-0.49999999999999994')", (Type)DoubleType.DOUBLE, -0.0);
        this.assertFunction("round(TINYINT '3', TINYINT '0')", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("round(TINYINT '3', 0)", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("round(SMALLINT '3', SMALLINT '0')", (Type)SmallintType.SMALLINT, (short)3);
        this.assertFunction("round(SMALLINT '3', 0)", (Type)SmallintType.SMALLINT, (short)3);
        this.assertFunction("round(3, 0)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("round(-3, 0)", (Type)IntegerType.INTEGER, -3);
        this.assertFunction("round(-3, INTEGER '0')", (Type)IntegerType.INTEGER, -3);
        this.assertFunction("round(BIGINT '3', 0)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("round( 3000000000, 0)", (Type)BigintType.BIGINT, 3000000000L);
        this.assertFunction("round(-3000000000, 0)", (Type)BigintType.BIGINT, -3000000000L);
        this.assertFunction("round(3.0E0, 0)", (Type)DoubleType.DOUBLE, 3.0);
        this.assertFunction("round(-3.0E0, 0)", (Type)DoubleType.DOUBLE, -3.0);
        this.assertFunction("round(3.499E0, 0)", (Type)DoubleType.DOUBLE, 3.0);
        this.assertFunction("round(-3.499E0, 0)", (Type)DoubleType.DOUBLE, -3.0);
        this.assertFunction("round(3.5E0, 0)", (Type)DoubleType.DOUBLE, 4.0);
        this.assertFunction("round(-3.5E0, 0)", (Type)DoubleType.DOUBLE, -4.0);
        this.assertFunction("round(-3.5001E0, 0)", (Type)DoubleType.DOUBLE, -4.0);
        this.assertFunction("round(-3.99E0, 0)", (Type)DoubleType.DOUBLE, -4.0);
        this.assertFunction("round(DOUBLE '0.49999999999999994', 0)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("round(DOUBLE '-0.5')", (Type)DoubleType.DOUBLE, -1.0);
        this.assertFunction("round(DOUBLE '-0.49999999999999994', 0)", (Type)DoubleType.DOUBLE, -0.0);
        this.assertFunction("round(0.3E0)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("round(-0.3E0)", (Type)DoubleType.DOUBLE, -0.0);
        this.assertFunction("round(TINYINT '3', TINYINT '1')", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("round(TINYINT '3', 1)", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("round(SMALLINT '3', SMALLINT '1')", (Type)SmallintType.SMALLINT, (short)3);
        this.assertFunction("round(SMALLINT '3', 1)", (Type)SmallintType.SMALLINT, (short)3);
        this.assertFunction("round(REAL '3.0', 0)", (Type)RealType.REAL, Float.valueOf(3.0f));
        this.assertFunction("round(REAL '-3.0', 0)", (Type)RealType.REAL, Float.valueOf(-3.0f));
        this.assertFunction("round(REAL '3.499', 0)", (Type)RealType.REAL, Float.valueOf(3.0f));
        this.assertFunction("round(REAL '-3.499', 0)", (Type)RealType.REAL, Float.valueOf(-3.0f));
        this.assertFunction("round(REAL '3.5', 0)", (Type)RealType.REAL, Float.valueOf(4.0f));
        this.assertFunction("round(REAL '-3.5', 0)", (Type)RealType.REAL, Float.valueOf(-4.0f));
        this.assertFunction("round(REAL '-3.5001', 0)", (Type)RealType.REAL, Float.valueOf(-4.0f));
        this.assertFunction("round(REAL '-3.99', 0)", (Type)RealType.REAL, Float.valueOf(-4.0f));
        this.assertFunction("round(3, 1)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("round(-3, 1)", (Type)IntegerType.INTEGER, -3);
        this.assertFunction("round(-3, INTEGER '1')", (Type)IntegerType.INTEGER, -3);
        this.assertFunction("round(-3, CAST(NULL as INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("round(BIGINT '3', 1)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("round( 3000000000, 1)", (Type)BigintType.BIGINT, 3000000000L);
        this.assertFunction("round(-3000000000, 1)", (Type)BigintType.BIGINT, -3000000000L);
        this.assertFunction("round(CAST(NULL as BIGINT), CAST(NULL as INTEGER))", (Type)BigintType.BIGINT, null);
        this.assertFunction("round(CAST(NULL as BIGINT), 1)", (Type)BigintType.BIGINT, null);
        this.assertFunction("round(3.0E0, 1)", (Type)DoubleType.DOUBLE, 3.0);
        this.assertFunction("round(-3.0E0, 1)", (Type)DoubleType.DOUBLE, -3.0);
        this.assertFunction("round(3.499E0, 1)", (Type)DoubleType.DOUBLE, 3.5);
        this.assertFunction("round(-3.499E0, 1)", (Type)DoubleType.DOUBLE, -3.5);
        this.assertFunction("round(3.5E0, 1)", (Type)DoubleType.DOUBLE, 3.5);
        this.assertFunction("round(-3.5E0, 1)", (Type)DoubleType.DOUBLE, -3.5);
        this.assertFunction("round(-3.5001E0, 1)", (Type)DoubleType.DOUBLE, -3.5);
        this.assertFunction("round(-3.99E0, 1)", (Type)DoubleType.DOUBLE, -4.0);
        this.assertFunction("round(REAL '3.0', 1)", (Type)RealType.REAL, Float.valueOf(3.0f));
        this.assertFunction("round(REAL '-3.0', 1)", (Type)RealType.REAL, Float.valueOf(-3.0f));
        this.assertFunction("round(REAL '3.499', 1)", (Type)RealType.REAL, Float.valueOf(3.5f));
        this.assertFunction("round(REAL '-3.499', 1)", (Type)RealType.REAL, Float.valueOf(-3.5f));
        this.assertFunction("round(REAL '3.5', 1)", (Type)RealType.REAL, Float.valueOf(3.5f));
        this.assertFunction("round(REAL '-3.5', 1)", (Type)RealType.REAL, Float.valueOf(-3.5f));
        this.assertFunction("round(REAL '-3.5001', 1)", (Type)RealType.REAL, Float.valueOf(-3.5f));
        this.assertFunction("round(REAL '-3.99', 1)", (Type)RealType.REAL, Float.valueOf(-4.0f));
        this.assertFunction("round(DECIMAL '0')", (Type)DecimalType.createDecimalType((int)1, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(DECIMAL '0.1')", (Type)DecimalType.createDecimalType((int)1, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(DECIMAL '-0.1')", (Type)DecimalType.createDecimalType((int)1, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(DECIMAL '3')", (Type)DecimalType.createDecimalType((int)1, (int)0), SqlDecimal.of((String)"3"));
        this.assertFunction("round(DECIMAL '-3')", (Type)DecimalType.createDecimalType((int)1, (int)0), SqlDecimal.of((String)"-3"));
        this.assertFunction("round(DECIMAL '3.0')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"3"));
        this.assertFunction("round(DECIMAL '-3.0')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"-3"));
        this.assertFunction("round(DECIMAL '3.49')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"3"));
        this.assertFunction("round(DECIMAL '-3.49')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"-3"));
        this.assertFunction("round(DECIMAL '3.50')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"4"));
        this.assertFunction("round(DECIMAL '-3.50')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"-4"));
        this.assertFunction("round(DECIMAL '3.99')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"4"));
        this.assertFunction("round(DECIMAL '-3.99')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"-4"));
        this.assertFunction("round(DECIMAL '9.99')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"10"));
        this.assertFunction("round(DECIMAL '-9.99')", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"-10"));
        this.assertFunction("round(DECIMAL '9999.9')", (Type)DecimalType.createDecimalType((int)5, (int)0), SqlDecimal.of((String)"10000"));
        this.assertFunction("round(DECIMAL '-9999.9')", (Type)DecimalType.createDecimalType((int)5, (int)0), SqlDecimal.of((String)"-10000"));
        this.assertFunction("round(DECIMAL '1000000000000.9999')", (Type)DecimalType.createDecimalType((int)14, (int)0), SqlDecimal.of((String)"1000000000001"));
        this.assertFunction("round(DECIMAL '-1000000000000.9999')", (Type)DecimalType.createDecimalType((int)14, (int)0), SqlDecimal.of((String)"-1000000000001"));
        this.assertFunction("round(DECIMAL '10000000000000000')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"10000000000000000"));
        this.assertFunction("round(DECIMAL '-10000000000000000')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"-10000000000000000"));
        this.assertFunction("round(DECIMAL '9999999999999999.99')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"10000000000000000"));
        this.assertFunction("round(DECIMAL '99999999999999999.9')", (Type)DecimalType.createDecimalType((int)18, (int)0), SqlDecimal.of((String)"100000000000000000"));
        this.assertFunction("round(CAST(0 AS DECIMAL(18,0)))", (Type)DecimalType.createDecimalType((int)18, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(CAST(0 AS DECIMAL(18,1)))", (Type)DecimalType.createDecimalType((int)18, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(CAST(0 AS DECIMAL(18,2)))", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(CAST(DECIMAL '0.1' AS DECIMAL(18,1)))", (Type)DecimalType.createDecimalType((int)18, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(CAST(DECIMAL '-0.1' AS DECIMAL(18,1)))", (Type)DecimalType.createDecimalType((int)18, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(DECIMAL '3000000000000000000000')", (Type)DecimalType.createDecimalType((int)22, (int)0), SqlDecimal.of((String)"3000000000000000000000"));
        this.assertFunction("round(DECIMAL '-3000000000000000000000')", (Type)DecimalType.createDecimalType((int)22, (int)0), SqlDecimal.of((String)"-3000000000000000000000"));
        this.assertFunction("round(DECIMAL '3000000000000000000000.0')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"3000000000000000000000"));
        this.assertFunction("round(DECIMAL '-3000000000000000000000.0')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"-3000000000000000000000"));
        this.assertFunction("round(DECIMAL '3000000000000000000000.49')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"3000000000000000000000"));
        this.assertFunction("round(DECIMAL '-3000000000000000000000.49')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"-3000000000000000000000"));
        this.assertFunction("round(DECIMAL '3000000000000000000000.50')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"3000000000000000000001"));
        this.assertFunction("round(DECIMAL '-3000000000000000000000.50')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"-3000000000000000000001"));
        this.assertFunction("round(DECIMAL '3000000000000000000000.99')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"3000000000000000000001"));
        this.assertFunction("round(DECIMAL '-3000000000000000000000.99')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"-3000000000000000000001"));
        this.assertFunction("round(DECIMAL '9999999999999999999999.99')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"10000000000000000000000"));
        this.assertFunction("round(DECIMAL '-9999999999999999999999.99')", (Type)DecimalType.createDecimalType((int)23, (int)0), SqlDecimal.of((String)"-10000000000000000000000"));
        this.assertFunction("round(DECIMAL '1000000000000000000000000000000000.9999')", (Type)DecimalType.createDecimalType((int)35, (int)0), SqlDecimal.of((String)"1000000000000000000000000000000001"));
        this.assertFunction("round(DECIMAL '-1000000000000000000000000000000000.9999')", (Type)DecimalType.createDecimalType((int)35, (int)0), SqlDecimal.of((String)"-1000000000000000000000000000000001"));
        this.assertFunction("round(DECIMAL '10000000000000000000000000000000000000')", (Type)DecimalType.createDecimalType((int)38, (int)0), SqlDecimal.of((String)"10000000000000000000000000000000000000"));
        this.assertFunction("round(DECIMAL '-10000000000000000000000000000000000000')", (Type)DecimalType.createDecimalType((int)38, (int)0), SqlDecimal.of((String)"-10000000000000000000000000000000000000"));
        this.assertFunction("round(DECIMAL '3000000000000000.000000')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"3000000000000000"));
        this.assertFunction("round(DECIMAL '-3000000000000000.000000')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"-3000000000000000"));
        this.assertFunction("round(DECIMAL '3000000000000000.499999')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"3000000000000000"));
        this.assertFunction("round(DECIMAL '-3000000000000000.499999')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"-3000000000000000"));
        this.assertFunction("round(DECIMAL '3000000000000000.500000')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"3000000000000001"));
        this.assertFunction("round(DECIMAL '-3000000000000000.500000')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"-3000000000000001"));
        this.assertFunction("round(DECIMAL '3000000000000000.999999')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"3000000000000001"));
        this.assertFunction("round(DECIMAL '-3000000000000000.999999')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"-3000000000000001"));
        this.assertFunction("round(DECIMAL '9999999999999999.999999')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"10000000000000000"));
        this.assertFunction("round(DECIMAL '-9999999999999999.999999')", (Type)DecimalType.createDecimalType((int)17, (int)0), SqlDecimal.of((String)"-10000000000000000"));
        this.assertFunction("round(DECIMAL '3', 1)", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"3"));
        this.assertFunction("round(DECIMAL '-3', 1)", (Type)DecimalType.createDecimalType((int)2, (int)0), SqlDecimal.of((String)"-3"));
        this.assertFunction("round(DECIMAL '3.0', 1)", (Type)DecimalType.createDecimalType((int)3, (int)1), SqlDecimal.of((String)"3.0"));
        this.assertFunction("round(DECIMAL '-3.0', 1)", (Type)DecimalType.createDecimalType((int)3, (int)1), SqlDecimal.of((String)"-3.0"));
        this.assertFunction("round(DECIMAL '3.449', 1)", (Type)DecimalType.createDecimalType((int)5, (int)3), SqlDecimal.of((String)"3.400"));
        this.assertFunction("round(DECIMAL '-3.449', 1)", (Type)DecimalType.createDecimalType((int)5, (int)3), SqlDecimal.of((String)"-3.400"));
        this.assertFunction("round(DECIMAL '3.450', 1)", (Type)DecimalType.createDecimalType((int)5, (int)3), SqlDecimal.of((String)"3.500"));
        this.assertFunction("round(DECIMAL '-3.450', 1)", (Type)DecimalType.createDecimalType((int)5, (int)3), SqlDecimal.of((String)"-3.500"));
        this.assertFunction("round(DECIMAL '3.99', 1)", (Type)DecimalType.createDecimalType((int)4, (int)2), SqlDecimal.of((String)"4.00"));
        this.assertFunction("round(DECIMAL '-3.99', 1)", (Type)DecimalType.createDecimalType((int)4, (int)2), SqlDecimal.of((String)"-4.00"));
        this.assertFunction("round(DECIMAL '9.99', 1)", (Type)DecimalType.createDecimalType((int)4, (int)2), SqlDecimal.of((String)"10.00"));
        this.assertFunction("round(DECIMAL '-9.99', 1)", (Type)DecimalType.createDecimalType((int)4, (int)2), SqlDecimal.of((String)"-10.00"));
        this.assertFunction("round(DECIMAL '0.00', 1)", (Type)DecimalType.createDecimalType((int)3, (int)2), SqlDecimal.of((String)"0.00"));
        this.assertFunction("round(DECIMAL '1234', 7)", (Type)DecimalType.createDecimalType((int)5, (int)0), SqlDecimal.of((String)"1234"));
        this.assertFunction("round(DECIMAL '-1234', 7)", (Type)DecimalType.createDecimalType((int)5, (int)0), SqlDecimal.of((String)"-1234"));
        this.assertFunction("round(DECIMAL '1234', -7)", (Type)DecimalType.createDecimalType((int)5, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(DECIMAL '-1234', -7)", (Type)DecimalType.createDecimalType((int)5, (int)0), SqlDecimal.of((String)"0"));
        this.assertFunction("round(DECIMAL '1234.5678', 7)", (Type)DecimalType.createDecimalType((int)9, (int)4), SqlDecimal.of((String)"1234.5678"));
        this.assertFunction("round(DECIMAL '-1234.5678', 7)", (Type)DecimalType.createDecimalType((int)9, (int)4), SqlDecimal.of((String)"-1234.5678"));
        this.assertFunction("round(DECIMAL '1234.5678', -2)", (Type)DecimalType.createDecimalType((int)9, (int)4), SqlDecimal.of((String)"1200.0000"));
        this.assertFunction("round(DECIMAL '-1234.5678', -2)", (Type)DecimalType.createDecimalType((int)9, (int)4), SqlDecimal.of((String)"-1200.0000"));
        this.assertFunction("round(DECIMAL '1254.5678', -2)", (Type)DecimalType.createDecimalType((int)9, (int)4), SqlDecimal.of((String)"1300.0000"));
        this.assertFunction("round(DECIMAL '-1254.5678', -2)", (Type)DecimalType.createDecimalType((int)9, (int)4), SqlDecimal.of((String)"-1300.0000"));
        this.assertFunction("round(DECIMAL '1234.5678', -7)", (Type)DecimalType.createDecimalType((int)9, (int)4), SqlDecimal.of((String)"0.0000"));
        this.assertFunction("round(DECIMAL '-1234.5678', -7)", (Type)DecimalType.createDecimalType((int)9, (int)4), SqlDecimal.of((String)"0.0000"));
        this.assertFunction("round(DECIMAL '99', -1)", (Type)DecimalType.createDecimalType((int)3, (int)0), SqlDecimal.of((String)"100"));
        this.assertFunction("round(DECIMAL '1234567890123456789', 1)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"1234567890123456789"));
        this.assertFunction("round(DECIMAL '-1234567890123456789', 1)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"-1234567890123456789"));
        this.assertFunction("round(DECIMAL '123456789012345678.0', 1)", (Type)DecimalType.createDecimalType((int)20, (int)1), SqlDecimal.of((String)"123456789012345678.0"));
        this.assertFunction("round(DECIMAL '-123456789012345678.0', 1)", (Type)DecimalType.createDecimalType((int)20, (int)1), SqlDecimal.of((String)"-123456789012345678.0"));
        this.assertFunction("round(DECIMAL '123456789012345678.449', 1)", (Type)DecimalType.createDecimalType((int)22, (int)3), SqlDecimal.of((String)"123456789012345678.400"));
        this.assertFunction("round(DECIMAL '-123456789012345678.449', 1)", (Type)DecimalType.createDecimalType((int)22, (int)3), SqlDecimal.of((String)"-123456789012345678.400"));
        this.assertFunction("round(DECIMAL '123456789012345678.45', 1)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"123456789012345678.50"));
        this.assertFunction("round(DECIMAL '-123456789012345678.45', 1)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"-123456789012345678.50"));
        this.assertFunction("round(DECIMAL '123456789012345678.501', 1)", (Type)DecimalType.createDecimalType((int)22, (int)3), SqlDecimal.of((String)"123456789012345678.500"));
        this.assertFunction("round(DECIMAL '-123456789012345678.501', 1)", (Type)DecimalType.createDecimalType((int)22, (int)3), SqlDecimal.of((String)"-123456789012345678.500"));
        this.assertFunction("round(DECIMAL '999999999999999999.99', 1)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"1000000000000000000.00"));
        this.assertFunction("round(DECIMAL '-999999999999999999.99', 1)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"-1000000000000000000.00"));
        this.assertFunction("round(DECIMAL '1234567890123456789', 7)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"1234567890123456789"));
        this.assertFunction("round(DECIMAL '-1234567890123456789', 7)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"-1234567890123456789"));
        this.assertFunction("round(DECIMAL '123456789012345678.99', 7)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"123456789012345678.99"));
        this.assertFunction("round(DECIMAL '-123456789012345678.99', 7)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"-123456789012345678.99"));
        this.assertFunction("round(DECIMAL '123456789012345611.99', -2)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"123456789012345600.00"));
        this.assertFunction("round(DECIMAL '-123456789012345611.99', -2)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"-123456789012345600.00"));
        this.assertFunction("round(DECIMAL '123456789012345678.99', -2)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"123456789012345700.00"));
        this.assertFunction("round(DECIMAL '-123456789012345678.99', -2)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"-123456789012345700.00"));
        this.assertFunction("round(DECIMAL '123456789012345678.99', -30)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"0.00"));
        this.assertFunction("round(DECIMAL '-123456789012345678.99', -30)", (Type)DecimalType.createDecimalType((int)21, (int)2), SqlDecimal.of((String)"0.00"));
        this.assertFunction("round(DECIMAL '9999999999999999999999999999999999999.9', 1)", (Type)DecimalType.createDecimalType((int)38, (int)1), SqlDecimal.of((String)"9999999999999999999999999999999999999.9"));
        this.assertInvalidFunction("round(DECIMAL '9999999999999999999999999999999999999.9', 0)", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertInvalidFunction("round(DECIMAL '9999999999999999999999999999999999999.9', -1)", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        this.assertFunction("round(DECIMAL  '1329123201320737513', -3)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"1329123201320738000"));
        this.assertFunction("round(DECIMAL '-1329123201320737513', -3)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"-1329123201320738000"));
        this.assertFunction("round(DECIMAL  '1329123201320739513', -3)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"1329123201320740000"));
        this.assertFunction("round(DECIMAL '-1329123201320739513', -3)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"-1329123201320740000"));
        this.assertFunction("round(DECIMAL  '9999999999999999999', -3)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"10000000000000000000"));
        this.assertFunction("round(DECIMAL '-9999999999999999999', -3)", (Type)DecimalType.createDecimalType((int)20, (int)0), SqlDecimal.of((String)"-10000000000000000000"));
        this.assertFunction("round(DECIMAL '9999999999999999.99', 1)", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"10000000000000000.00"));
        this.assertFunction("round(DECIMAL '-9999999999999999.99', 1)", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"-10000000000000000.00"));
        this.assertFunction("round(DECIMAL '9999999999999999.99', -1)", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"10000000000000000.00"));
        this.assertFunction("round(DECIMAL '-9999999999999999.99', -1)", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"-10000000000000000.00"));
        this.assertFunction("round(DECIMAL '9999999999999999.99', 2)", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"9999999999999999.99"));
        this.assertFunction("round(DECIMAL '-9999999999999999.99', 2)", (Type)DecimalType.createDecimalType((int)19, (int)2), SqlDecimal.of((String)"-9999999999999999.99"));
        this.assertFunction("round(DECIMAL '329123201320737513', -3)", (Type)DecimalType.createDecimalType((int)19, (int)0), SqlDecimal.of((String)"329123201320738000"));
        this.assertFunction("round(DECIMAL '-329123201320737513', -3)", (Type)DecimalType.createDecimalType((int)19, (int)0), SqlDecimal.of((String)"-329123201320738000"));
        this.assertFunction("round(DECIMAL '329123201320739513', -3)", (Type)DecimalType.createDecimalType((int)19, (int)0), SqlDecimal.of((String)"329123201320740000"));
        this.assertFunction("round(DECIMAL '-329123201320739513', -3)", (Type)DecimalType.createDecimalType((int)19, (int)0), SqlDecimal.of((String)"-329123201320740000"));
        this.assertFunction("round(DECIMAL '999999999999999999', -3)", (Type)DecimalType.createDecimalType((int)19, (int)0), SqlDecimal.of((String)"1000000000000000000"));
        this.assertFunction("round(DECIMAL '-999999999999999999', -3)", (Type)DecimalType.createDecimalType((int)19, (int)0), SqlDecimal.of((String)"-1000000000000000000"));
        this.assertFunction("round(CAST(NULL as DOUBLE), CAST(NULL as INTEGER))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("round(-3.0E0, CAST(NULL as INTEGER))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("round(CAST(NULL as DOUBLE), 1)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("round(CAST(NULL as DECIMAL(1,0)), CAST(NULL as INTEGER))", (Type)DecimalType.createDecimalType((int)2, (int)0), null);
        this.assertFunction("round(DECIMAL '-3.0', CAST(NULL as INTEGER))", (Type)DecimalType.createDecimalType((int)3, (int)1), null);
        this.assertFunction("round(CAST(NULL as DECIMAL(1,0)), 1)", (Type)DecimalType.createDecimalType((int)2, (int)0), null);
        this.assertFunction("round(CAST(NULL as DECIMAL(17,2)), 1)", (Type)DecimalType.createDecimalType((int)18, (int)2), null);
        this.assertFunction("round(CAST(NULL as DECIMAL(20,2)), 1)", (Type)DecimalType.createDecimalType((int)21, (int)2), null);
        this.assertFunction("round(nan(), 2)", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("round(1.0E0 / 0, 2)", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("round(-1.0E0 / 0, 2)", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testSign() {
        Float signum;
        DecimalType expectedDecimalReturnType = DecimalType.createDecimalType((int)1, (int)0);
        this.assertFunction("sign(CAST(NULL as TINYINT))", (Type)TinyintType.TINYINT, null);
        this.assertFunction("sign(CAST(NULL as SMALLINT))", (Type)SmallintType.SMALLINT, null);
        this.assertFunction("sign(CAST(NULL as INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("sign(CAST(NULL as BIGINT))", (Type)BigintType.BIGINT, null);
        this.assertFunction("sign(CAST(NULL as DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("sign(CAST(NULL as DECIMAL(2,1)))", (Type)expectedDecimalReturnType, null);
        this.assertFunction("sign(CAST(NULL as DECIMAL(38,0)))", (Type)expectedDecimalReturnType, null);
        for (int intValue : intLefts) {
            signum = Float.valueOf(Math.signum(intValue));
            this.assertFunction("sign(TINYINT '" + intValue + "')", (Type)TinyintType.TINYINT, signum.byteValue());
        }
        for (int intValue : intLefts) {
            signum = Float.valueOf(Math.signum(intValue));
            this.assertFunction("sign(SMALLINT '" + intValue + "')", (Type)SmallintType.SMALLINT, signum.shortValue());
        }
        for (int intValue : intLefts) {
            signum = Float.valueOf(Math.signum(intValue));
            this.assertFunction("sign(INTEGER '" + intValue + "')", (Type)IntegerType.INTEGER, signum.intValue());
        }
        for (int intValue : intLefts) {
            signum = Float.valueOf(Math.signum(intValue));
            this.assertFunction("sign(BIGINT '" + intValue + "')", (Type)BigintType.BIGINT, signum.longValue());
        }
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("sign(DOUBLE '" + doubleValue + "')", (Type)DoubleType.DOUBLE, Math.signum(doubleValue));
            this.assertFunction("sign(REAL '" + (float)doubleValue + "')", (Type)RealType.REAL, Float.valueOf(Math.signum((float)doubleValue)));
        }
        this.assertFunction("sign(DOUBLE 'NaN')", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("sign(DOUBLE '+Infinity')", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("sign(DOUBLE '-Infinity')", (Type)DoubleType.DOUBLE, -1.0);
        this.assertFunction("sign(DECIMAL '0')", (Type)expectedDecimalReturnType, SqlDecimal.of((String)"0"));
        this.assertFunction("sign(DECIMAL '123')", (Type)expectedDecimalReturnType, SqlDecimal.of((String)"1"));
        this.assertFunction("sign(DECIMAL '-123')", (Type)expectedDecimalReturnType, SqlDecimal.of((String)"-1"));
        this.assertFunction("sign(DECIMAL '123.000000000000000')", (Type)expectedDecimalReturnType, SqlDecimal.of((String)"1"));
        this.assertFunction("sign(DECIMAL '-123.000000000000000')", (Type)expectedDecimalReturnType, SqlDecimal.of((String)"-1"));
        this.assertFunction("sign(DECIMAL '0.000000000000000000')", (Type)expectedDecimalReturnType, SqlDecimal.of((String)"0"));
        this.assertFunction("sign(DECIMAL '1230.000000000000000')", (Type)expectedDecimalReturnType, SqlDecimal.of((String)"1"));
        this.assertFunction("sign(DECIMAL '-1230.000000000000000')", (Type)expectedDecimalReturnType, SqlDecimal.of((String)"-1"));
    }

    @Test
    public void testSin() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("sin(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.sin(doubleValue));
            this.assertFunction("sin(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.sin((float)doubleValue));
        }
        this.assertFunction("sin(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testSqrt() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("sqrt(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.sqrt(doubleValue));
            this.assertFunction("sqrt(REAL '" + doubleValue + "')", (Type)DoubleType.DOUBLE, Math.sqrt((float)doubleValue));
        }
        this.assertFunction("sqrt(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testTan() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("tan(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.tan(doubleValue));
            this.assertFunction("tan(REAL '" + (float)doubleValue + "')", (Type)DoubleType.DOUBLE, Math.tan((float)doubleValue));
        }
        this.assertFunction("tan(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testTanh() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("tanh(" + doubleValue + ")", (Type)DoubleType.DOUBLE, Math.tanh(doubleValue));
            this.assertFunction("tanh(REAL '" + doubleValue + "')", (Type)DoubleType.DOUBLE, Math.tanh((float)doubleValue));
        }
        this.assertFunction("tanh(NULL)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testGreatest() {
        this.assertFunction("greatest(TINYINT'1', TINYINT'2')", (Type)TinyintType.TINYINT, (byte)2);
        this.assertFunction("greatest(TINYINT'-1', TINYINT'-2')", (Type)TinyintType.TINYINT, (byte)-1);
        this.assertFunction("greatest(TINYINT'5', TINYINT'4', TINYINT'3', TINYINT'2', TINYINT'1', TINYINT'2', TINYINT'3', TINYINT'4', TINYINT'1', TINYINT'5')", (Type)TinyintType.TINYINT, (byte)5);
        this.assertFunction("greatest(TINYINT'-1')", (Type)TinyintType.TINYINT, (byte)-1);
        this.assertFunction("greatest(TINYINT'5', TINYINT'4', CAST(NULL AS TINYINT), TINYINT'3')", (Type)TinyintType.TINYINT, null);
        this.assertFunction("greatest(SMALLINT'1', SMALLINT'2')", (Type)SmallintType.SMALLINT, (short)2);
        this.assertFunction("greatest(SMALLINT'-1', SMALLINT'-2')", (Type)SmallintType.SMALLINT, (short)-1);
        this.assertFunction("greatest(SMALLINT'5', SMALLINT'4', SMALLINT'3', SMALLINT'2', SMALLINT'1', SMALLINT'2', SMALLINT'3', SMALLINT'4', SMALLINT'1', SMALLINT'5')", (Type)SmallintType.SMALLINT, (short)5);
        this.assertFunction("greatest(SMALLINT'-1')", (Type)SmallintType.SMALLINT, (short)-1);
        this.assertFunction("greatest(SMALLINT'5', SMALLINT'4', CAST(NULL AS SMALLINT), SMALLINT'3')", (Type)SmallintType.SMALLINT, null);
        this.assertFunction("greatest(1, 2)", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("greatest(-1, -2)", (Type)IntegerType.INTEGER, -1);
        this.assertFunction("greatest(5, 4, 3, 2, 1, 2, 3, 4, 1, 5)", (Type)IntegerType.INTEGER, 5);
        this.assertFunction("greatest(-1)", (Type)IntegerType.INTEGER, -1);
        this.assertFunction("greatest(5, 4, CAST(NULL AS INTEGER), 3)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("greatest(10000000000, 20000000000)", (Type)BigintType.BIGINT, 20000000000L);
        this.assertFunction("greatest(-10000000000, -20000000000)", (Type)BigintType.BIGINT, -10000000000L);
        this.assertFunction("greatest(5000000000, 4, 3, 2, 1000000000, 2, 3, 4, 1, 5000000000)", (Type)BigintType.BIGINT, 5000000000L);
        this.assertFunction("greatest(-10000000000)", (Type)BigintType.BIGINT, -10000000000L);
        this.assertFunction("greatest(5000000000, 4000000000, CAST(NULL as BIGINT), 3000000000)", (Type)BigintType.BIGINT, null);
        this.assertFunction("greatest(1.5E0, 2.3E0)", (Type)DoubleType.DOUBLE, 2.3);
        this.assertFunction("greatest(-1.5E0, -2.3E0)", (Type)DoubleType.DOUBLE, -1.5);
        this.assertFunction("greatest(-1.5E0, -2.3E0, -5/3)", (Type)DoubleType.DOUBLE, -1.0);
        this.assertFunction("greatest(1.5E0, -1.0E0 / 0.0E0, 1.0E0 / 0.0E0)", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("greatest(5, 4, CAST(NULL as DOUBLE), 3)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("greatest(REAL '1.5', 2.3E0)", (Type)DoubleType.DOUBLE, 2.3);
        this.assertFunction("greatest(REAL '-1.5', -2.3E0)", (Type)DoubleType.DOUBLE, -1.5);
        this.assertFunction("greatest(-1.5E0, REAL '-2.3', -5/3)", (Type)DoubleType.DOUBLE, -1.0);
        this.assertFunction("greatest(REAL '1.5', REAL '-1.0' / 0.0E0, 1.0E0 / REAL '0.0')", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("greatest(5, REAL '4', CAST(NULL as DOUBLE), 3)", (Type)DoubleType.DOUBLE, null);
        this.assertDecimalFunction("greatest(1.0, 2.0)", TestMathFunctions.decimal("2.0"));
        this.assertDecimalFunction("greatest(1.0, -2.0)", TestMathFunctions.decimal("1.0"));
        this.assertDecimalFunction("greatest(1.0, 1.1, 1.2, 1.3)", TestMathFunctions.decimal("1.3"));
        this.assertFunction("greatest(1, 20000000000)", (Type)BigintType.BIGINT, 20000000000L);
        this.assertFunction("greatest(1, BIGINT '2')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("greatest(1.0E0, 2)", (Type)DoubleType.DOUBLE, 2.0);
        this.assertFunction("greatest(1, 2.0E0)", (Type)DoubleType.DOUBLE, 2.0);
        this.assertFunction("greatest(1.0E0, 2)", (Type)DoubleType.DOUBLE, 2.0);
        this.assertFunction("greatest(5.0E0, 4, CAST(NULL as DOUBLE), 3)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("greatest(5.0E0, 4, CAST(NULL as BIGINT), 3)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("greatest(1.0, 2.0E0)", (Type)DoubleType.DOUBLE, 2.0);
        this.assertDecimalFunction("greatest(5, 4, 3.0, 2)", TestMathFunctions.decimal("0000000005.0"));
        this.assertInvalidFunction("greatest(1.5E0, 0.0E0 / 0.0E0)", "Invalid argument to greatest(): NaN");
        this.tryEvaluateWithAll("greatest(" + Joiner.on((String)", ").join(Collections.nCopies(127, "rand()")) + ")", (Type)DoubleType.DOUBLE);
        this.assertNotSupported("greatest(" + Joiner.on((String)", ").join(Collections.nCopies(128, "rand()")) + ")", "Too many arguments for function call greatest()");
    }

    @Test
    public void testLeast() {
        this.assertFunction("least(TINYINT'1', TINYINT'2')", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("least(TINYINT'-1', TINYINT'-2')", (Type)TinyintType.TINYINT, (byte)-2);
        this.assertFunction("least(TINYINT'5', TINYINT'4', TINYINT'3', TINYINT'2', TINYINT'1', TINYINT'2', TINYINT'3', TINYINT'4', TINYINT'1', TINYINT'5')", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("least(TINYINT'-1')", (Type)TinyintType.TINYINT, (byte)-1);
        this.assertFunction("least(TINYINT'5', TINYINT'4', CAST(NULL AS TINYINT), TINYINT'3')", (Type)TinyintType.TINYINT, null);
        this.assertFunction("least(SMALLINT'1', SMALLINT'2')", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("least(SMALLINT'-1', SMALLINT'-2')", (Type)SmallintType.SMALLINT, (short)-2);
        this.assertFunction("least(SMALLINT'5', SMALLINT'4', SMALLINT'3', SMALLINT'2', SMALLINT'1', SMALLINT'2', SMALLINT'3', SMALLINT'4', SMALLINT'1', SMALLINT'5')", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("least(SMALLINT'-1')", (Type)SmallintType.SMALLINT, (short)-1);
        this.assertFunction("least(SMALLINT'5', SMALLINT'4', CAST(NULL AS SMALLINT), SMALLINT'3')", (Type)SmallintType.SMALLINT, null);
        this.assertFunction("least(1, 2)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("least(-1, -2)", (Type)IntegerType.INTEGER, -2);
        this.assertFunction("least(5, 4, 3, 2, 1, 2, 3, 4, 1, 5)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("least(-1)", (Type)IntegerType.INTEGER, -1);
        this.assertFunction("least(5, 4, CAST(NULL AS INTEGER), 3)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("least(10000000000, 20000000000)", (Type)BigintType.BIGINT, 10000000000L);
        this.assertFunction("least(-10000000000, -20000000000)", (Type)BigintType.BIGINT, -20000000000L);
        this.assertFunction("least(50000000000, 40000000000, 30000000000, 20000000000, 50000000000)", (Type)BigintType.BIGINT, 20000000000L);
        this.assertFunction("least(-10000000000)", (Type)BigintType.BIGINT, -10000000000L);
        this.assertFunction("least(500000000, 400000000, CAST(NULL as BIGINT), 300000000)", (Type)BigintType.BIGINT, null);
        this.assertFunction("least(1.5E0, 2.3E0)", (Type)DoubleType.DOUBLE, 1.5);
        this.assertFunction("least(-1.5E0, -2.3E0)", (Type)DoubleType.DOUBLE, -2.3);
        this.assertFunction("least(-1.5E0, -2.3E0, -5/3)", (Type)DoubleType.DOUBLE, -2.3);
        this.assertFunction("least(1.5E0, -1.0E0 / 0.0E0, 1.0E0 / 0.0E0)", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertFunction("least(5, 4, CAST(NULL as DOUBLE), 3)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("least(REAL '1.5', 2.3E0)", (Type)DoubleType.DOUBLE, 1.5);
        this.assertFunction("least(REAL '-1.5', -2.3E0)", (Type)DoubleType.DOUBLE, -2.3);
        this.assertFunction("least(-2.3E0, REAL '-0.4', -5/3)", (Type)DoubleType.DOUBLE, -2.3);
        this.assertFunction("least(1.5E0, REAL '-1.0' / 0.0E0, 1.0E0 / 0.0E0)", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertFunction("least(REAL '5', 4, CAST(NULL as DOUBLE), 3)", (Type)DoubleType.DOUBLE, null);
        this.assertDecimalFunction("least(1.0, 2.0)", TestMathFunctions.decimal("1.0"));
        this.assertDecimalFunction("least(1.0, -2.0)", TestMathFunctions.decimal("-2.0"));
        this.assertDecimalFunction("least(1.0, 1.1, 1.2, 1.3)", TestMathFunctions.decimal("1.0"));
        this.assertFunction("least(1, 20000000000)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("least(1, BIGINT '2')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("least(1.0E0, 2)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("least(1, 2.0E0)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("least(1.0E0, 2)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("least(5.0E0, 4, CAST(NULL as DOUBLE), 3)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("least(5.0E0, 4, CAST(NULL as BIGINT), 3)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("least(1.0, 2.0E0)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertDecimalFunction("least(5, 4, 3.0, 2)", TestMathFunctions.decimal("0000000002.0"));
        this.assertInvalidFunction("least(1.5E0, 0.0E0 / 0.0E0)", "Invalid argument to least(): NaN");
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="\\QInvalid argument to greatest(): NaN\\E")
    public void testGreatestWithNaN() {
        this.functionAssertions.tryEvaluate("greatest(1.5E0, 0.0E0 / 0.0E0)", (Type)DoubleType.DOUBLE);
        this.functionAssertions.tryEvaluate("greatest(1.5E0, REAL '0.0' / REAL '0.0')", (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testToBase() {
        VarcharType toBaseReturnType = VarcharType.createVarcharType((int)64);
        this.assertFunction("to_base(2147483648, 16)", (Type)toBaseReturnType, "80000000");
        this.assertFunction("to_base(255, 2)", (Type)toBaseReturnType, "11111111");
        this.assertFunction("to_base(-2147483647, 16)", (Type)toBaseReturnType, "-7fffffff");
        this.assertFunction("to_base(NULL, 16)", (Type)toBaseReturnType, null);
        this.assertFunction("to_base(-2147483647, NULL)", (Type)toBaseReturnType, null);
        this.assertFunction("to_base(NULL, NULL)", (Type)toBaseReturnType, null);
        this.assertInvalidFunction("to_base(255, 1)", "Radix must be between 2 and 36");
    }

    @Test
    public void testFromBase() {
        this.assertFunction("from_base('80000000', 16)", (Type)BigintType.BIGINT, 0x80000000L);
        this.assertFunction("from_base('11111111', 2)", (Type)BigintType.BIGINT, 255L);
        this.assertFunction("from_base('-7fffffff', 16)", (Type)BigintType.BIGINT, -2147483647L);
        this.assertFunction("from_base('9223372036854775807', 10)", (Type)BigintType.BIGINT, Long.MAX_VALUE);
        this.assertFunction("from_base('-9223372036854775808', 10)", (Type)BigintType.BIGINT, Long.MIN_VALUE);
        this.assertFunction("from_base(NULL, 10)", (Type)BigintType.BIGINT, null);
        this.assertFunction("from_base('-9223372036854775808', NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("from_base(NULL, NULL)", (Type)BigintType.BIGINT, null);
        this.assertInvalidFunction("from_base('Z', 37)", "Radix must be between 2 and 36");
        this.assertInvalidFunction("from_base('Z', 35)", "Not a valid base-35 number: Z");
        this.assertInvalidFunction("from_base('9223372036854775808', 10)", "Not a valid base-10 number: 9223372036854775808");
        this.assertInvalidFunction("from_base('Z', 37)", "Radix must be between 2 and 36");
        this.assertInvalidFunction("from_base('Z', 35)", "Not a valid base-35 number: Z");
        this.assertInvalidFunction("from_base('9223372036854775808', 10)", "Not a valid base-10 number: 9223372036854775808");
    }

    @Test
    public void testWidthBucket() {
        this.assertFunction("width_bucket(3.14E0, 0, 4, 3)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("width_bucket(2, 0, 4, 3)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("width_bucket(infinity(), 0, 4, 3)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("width_bucket(-1, 0, 3.2E0, 4)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("width_bucket(3.14E0, 4, 0, 3)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("width_bucket(2, 4, 0, 3)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("width_bucket(infinity(), 4, 0, 3)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("width_bucket(-1, 3.2E0, 0, 4)", (Type)BigintType.BIGINT, 5L);
        this.assertInvalidFunction("width_bucket(3.14E0, 0, 4, 0)", "bucketCount must be greater than 0");
        this.assertInvalidFunction("width_bucket(3.14E0, 0, 4, -1)", "bucketCount must be greater than 0");
        this.assertInvalidFunction("width_bucket(nan(), 0, 4, 3)", "operand must not be NaN");
        this.assertInvalidFunction("width_bucket(3.14E0, -1, -1, 3)", "bounds cannot equal each other");
        this.assertInvalidFunction("width_bucket(3.14E0, nan(), -1, 3)", "first bound must be finite");
        this.assertInvalidFunction("width_bucket(3.14E0, -1, nan(), 3)", "second bound must be finite");
        this.assertInvalidFunction("width_bucket(3.14E0, infinity(), -1, 3)", "first bound must be finite");
        this.assertInvalidFunction("width_bucket(3.14E0, -1, infinity(), 3)", "second bound must be finite");
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Bucket for value Infinity is out of range")
    public void testWidthBucketOverflowAscending() {
        this.functionAssertions.tryEvaluate("width_bucket(infinity(), 0, 4, 9223372036854775807)", (Type)DoubleType.DOUBLE);
        this.functionAssertions.tryEvaluate("width_bucket(CAST(infinity() as REAL), 0, 4, 9223372036854775807)", (Type)DoubleType.DOUBLE);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Bucket for value Infinity is out of range")
    public void testWidthBucketOverflowDescending() {
        this.functionAssertions.tryEvaluate("width_bucket(infinity(), 4, 0, 9223372036854775807)", (Type)DoubleType.DOUBLE);
        this.functionAssertions.tryEvaluate("width_bucket(CAST(infinity() as REAL), 4, 0, 9223372036854775807)", (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testWidthBucketArray() {
        this.assertFunction("width_bucket(3.14E0, array[0.0E0, 2.0E0, 4.0E0])", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("width_bucket(infinity(), array[0.0E0, 2.0E0, 4.0E0])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("width_bucket(-1, array[0.0E0, 1.2E0, 3.3E0, 4.5E0])", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("width_bucket(3.145E0, array[0.0E0])", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("width_bucket(-3.145E0, array[0.0E0])", (Type)BigintType.BIGINT, 0L);
        this.assertInvalidFunction("width_bucket(3.14E0, array[])", "Bins cannot be an empty array");
        this.assertInvalidFunction("width_bucket(nan(), array[1.0E0, 2.0E0, 3.0E0])", "Operand cannot be NaN");
        this.assertInvalidFunction("width_bucket(3.14E0, array[0.0E0, infinity()])", "Bin value must be finite, got Infinity");
        this.assertInvalidFunction("width_bucket(3.145E0, array[1.0E0, 0.0E0])", "Bin values are not sorted in ascending order");
        this.assertInvalidFunction("width_bucket(3.145E0, array[1.0E0, 0.0E0, -1.0E0])", "Bin values are not sorted in ascending order");
        this.assertInvalidFunction("width_bucket(3.145E0, array[1.0E0, 0.3E0, 0.0E0, -1.0E0])", "Bin values are not sorted in ascending order");
        this.assertFunction("width_bucket(1.5E0, array[1.0E0, 2.3E0, 2.0E0])", (Type)BigintType.BIGINT, 1L);
    }

    @Test
    public void testCosineSimilarity() {
        this.assertFunction("cosine_similarity(map(array ['a', 'b'], array [1.0E0, 2.0E0]), map(array ['c', 'b'], array [1.0E0, 3.0E0]))", (Type)DoubleType.DOUBLE, 6.0 / (Math.sqrt(5.0) * Math.sqrt(10.0)));
        this.assertFunction("cosine_similarity(map(array ['a', 'b', 'c'], array [1.0E0, 2.0E0, -1.0E0]), map(array ['c', 'b'], array [1.0E0, 3.0E0]))", (Type)DoubleType.DOUBLE, 5.0 / (Math.sqrt(6.0) * Math.sqrt(10.0)));
        this.assertFunction("cosine_similarity(map(array ['a', 'b', 'c'], array [1.0E0, 2.0E0, -1.0E0]), map(array ['d', 'e'], array [1.0E0, 3.0E0]))", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("cosine_similarity(null, map(array ['c', 'b'], array [1.0E0, 3.0E0]))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("cosine_similarity(map(array ['a', 'b'], array [1.0E0, null]), map(array ['c', 'b'], array [1.0E0, 3.0E0]))", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testInverseNormalCdf() {
        this.assertFunction("inverse_normal_cdf(0, 1, 0.3)", (Type)DoubleType.DOUBLE, -0.5244005127080409);
        this.assertFunction("inverse_normal_cdf(10, 9, 0.9)", (Type)DoubleType.DOUBLE, 21.533964089901406);
        this.assertFunction("inverse_normal_cdf(0.5, 0.25, 0.65)", (Type)DoubleType.DOUBLE, 0.596330116601892);
        this.assertInvalidFunction("inverse_normal_cdf(4, 48, 0)", "p must be 0 > p > 1");
        this.assertInvalidFunction("inverse_normal_cdf(4, 48, 1)", "p must be 0 > p > 1");
        this.assertInvalidFunction("inverse_normal_cdf(4, 0, 0.4)", "sd must be > 0");
    }

    @Test
    public void testNormalCdf() throws Exception {
        this.assertFunction("normal_cdf(0, 1, 1.96)", (Type)DoubleType.DOUBLE, 0.9750021048517796);
        this.assertFunction("normal_cdf(10, 9, 10)", (Type)DoubleType.DOUBLE, 0.5);
        this.assertFunction("normal_cdf(-1.5, 2.1, -7.8)", (Type)DoubleType.DOUBLE, 0.0013498980316301035);
        this.assertFunction("normal_cdf(0, 1, infinity())", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("normal_cdf(0, 1, -infinity())", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("normal_cdf(infinity(), 1, 0)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("normal_cdf(-infinity(), 1, 0)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("normal_cdf(0, infinity(), 0)", (Type)DoubleType.DOUBLE, 0.5);
        this.assertFunction("normal_cdf(nan(), 1, 0)", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("normal_cdf(0, 1, nan())", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertInvalidFunction("normal_cdf(0, 0, 0.1985)", "standardDeviation must be > 0");
        this.assertInvalidFunction("normal_cdf(0, nan(), 0.1985)", "standardDeviation must be > 0");
    }

    @Test
    public void testBinomialCdf() throws Exception {
        this.assertFunction("binomial_cdf(5, 0.5, 5)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("binomial_cdf(5, 0.5, 0)", (Type)DoubleType.DOUBLE, 0.03125);
        this.assertFunction("binomial_cdf(5, 0.5, 3)", (Type)DoubleType.DOUBLE, 0.8125);
        this.assertFunction("binomial_cdf(20, 1.0, 0)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertInvalidFunction("binomial_cdf(5, -0.5, 3)", "successProbability must be in the interval [0, 1]");
        this.assertInvalidFunction("binomial_cdf(5, 1.5, 3)", "successProbability must be in the interval [0, 1]");
        this.assertInvalidFunction("binomial_cdf(-5, 0.5, 3)", "numberOfTrials must be greater than 0");
    }

    @Test
    public void testInverseBinomialCdf() throws Exception {
        this.assertFunction("inverse_binomial_cdf(20, 0.5, 0.5)", (Type)IntegerType.INTEGER, 10);
        this.assertFunction("inverse_binomial_cdf(20, 0.5, 0.0)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("inverse_binomial_cdf(20, 0.5, 1.0)", (Type)IntegerType.INTEGER, 20);
        this.assertInvalidFunction("inverse_binomial_cdf(5, -0.5, 0.3)", "successProbability must be in the interval [0, 1]");
        this.assertInvalidFunction("inverse_binomial_cdf(5, 1.5, 0.3)", "successProbability must be in the interval [0, 1]");
        this.assertInvalidFunction("inverse_binomial_cdf(5, 0.5, -3.0)", "p must be in the interval [0, 1]");
        this.assertInvalidFunction("inverse_binomial_cdf(5, 0.5, 3.0)", "p must be in the interval [0, 1]");
        this.assertInvalidFunction("inverse_binomial_cdf(-5, 0.5, 0.3)", "numberOfTrials must be greater than 0");
    }

    @Test
    public void testInverseBetaCdf() {
        this.assertFunction("inverse_beta_cdf(3, 3.6, 0.0)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("inverse_beta_cdf(3, 3.6, 1.0)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("inverse_beta_cdf(3, 3.6, 0.3)", (Type)DoubleType.DOUBLE, 0.3469675485440618);
        this.assertFunction("inverse_beta_cdf(3, 3.6, 0.95)", (Type)DoubleType.DOUBLE, 0.7600272463100223);
        this.assertInvalidFunction("inverse_beta_cdf(0, 3, 0.5)", "a must be > 0");
        this.assertInvalidFunction("inverse_beta_cdf(3, 0, 0.5)", "b must be > 0");
        this.assertInvalidFunction("inverse_beta_cdf(3, 5, -0.1)", "p must be in the interval [0, 1]");
        this.assertInvalidFunction("inverse_beta_cdf(3, 5, 1.1)", "p must be in the interval [0, 1]");
    }

    @Test
    public void testBetaCdf() throws Exception {
        this.assertFunction("beta_cdf(3, 3.6, 0.0)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("beta_cdf(3, 3.6, 1.0)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("beta_cdf(3, 3.6, 0.3)", (Type)DoubleType.DOUBLE, 0.21764809997679938);
        this.assertFunction("beta_cdf(3, 3.6, 0.9)", (Type)DoubleType.DOUBLE, 0.9972502881611551);
        this.assertInvalidFunction("beta_cdf(0, 3, 0.5)", "a must be > 0");
        this.assertInvalidFunction("beta_cdf(3, 0, 0.5)", "b must be > 0");
        this.assertInvalidFunction("beta_cdf(3, 5, -0.1)", "value must be in the interval [0, 1]");
        this.assertInvalidFunction("beta_cdf(3, 5, 1.1)", "value must be in the interval [0, 1]");
    }

    @Test
    public void testInverseChiSquaredCdf() {
        this.assertFunction("inverse_chi_squared_cdf(3, 0.0)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("round(inverse_chi_squared_cdf(3, 0.99), 4)", (Type)DoubleType.DOUBLE, 11.3449);
        this.assertFunction("round(inverse_chi_squared_cdf(3, 0.3),2)", (Type)DoubleType.DOUBLE, 1.42);
        this.assertFunction("round(inverse_chi_squared_cdf(3, 0.95),2)", (Type)DoubleType.DOUBLE, 7.81);
        this.assertInvalidFunction("inverse_chi_squared_cdf(-3, 0.3)", "df must be greater than 0");
        this.assertInvalidFunction("inverse_chi_squared_cdf(3, -0.1)", "p must be in the interval [0, 1]");
        this.assertInvalidFunction("inverse_chi_squared_cdf(3, 1.1)", "p must be in the interval [0, 1]");
    }

    @Test
    public void testChiSquaredCdf() throws Exception {
        this.assertFunction("chi_squared_cdf(3, 0.0)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("round(chi_squared_cdf(3, 1.0), 4)", (Type)DoubleType.DOUBLE, 0.1987);
        this.assertFunction("round(chi_squared_cdf(3, 2.5), 2)", (Type)DoubleType.DOUBLE, 0.52);
        this.assertFunction("round(chi_squared_cdf(3, 4), 2)", (Type)DoubleType.DOUBLE, 0.74);
        this.assertInvalidFunction("chi_squared_cdf(-3, 0.3)", "df must be greater than 0");
        this.assertInvalidFunction("chi_squared_cdf(3, -10)", "value must non-negative");
    }

    @Test
    public void testInversePoissonCdf() {
        this.assertFunction("inverse_poisson_cdf(3, 0.0)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("inverse_poisson_cdf(3, 0.3)", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("inverse_poisson_cdf(3, 0.95)", (Type)IntegerType.INTEGER, 6);
        this.assertFunction("inverse_poisson_cdf(3, 0.99999999)", (Type)IntegerType.INTEGER, 17);
        this.assertInvalidFunction("inverse_poisson_cdf(-3, 0.3)", "lambda must be greater than 0");
        this.assertInvalidFunction("inverse_poisson_cdf(3, -0.1)", "p must be in the interval [0, 1)");
        this.assertInvalidFunction("inverse_poisson_cdf(3, 1.1)", "p must be in the interval [0, 1)");
        this.assertInvalidFunction("inverse_poisson_cdf(3, 1)", "p must be in the interval [0, 1)");
    }

    @Test
    public void testPoissonCdf() {
        this.assertFunction("round(poisson_cdf(10, 0), 2)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("round(poisson_cdf(3, 5), 2)", (Type)DoubleType.DOUBLE, 0.92);
        this.assertInvalidFunction("poisson_cdf(-3, 5)", "lambda must be greater than 0");
        this.assertInvalidFunction("poisson_cdf(3, -10)", "value must be a non-negative integer");
    }

    @Test
    public void testWilsonInterval() {
        this.assertInvalidFunction("wilson_interval_lower(-1, 100, 2.575)", "number of successes must not be negative");
        this.assertInvalidFunction("wilson_interval_lower(0, 0, 2.575)", "number of trials must be positive");
        this.assertInvalidFunction("wilson_interval_lower(10, 5, 2.575)", "number of successes must not be larger than number of trials");
        this.assertInvalidFunction("wilson_interval_lower(0, 100, -1)", "z-score must not be negative");
        this.assertFunction("wilson_interval_lower(1250, 1310, 1.96e0)", (Type)DoubleType.DOUBLE, 0.9414883725395894);
        this.assertInvalidFunction("wilson_interval_upper(-1, 100, 2.575)", "number of successes must not be negative");
        this.assertInvalidFunction("wilson_interval_upper(0, 0, 2.575)", "number of trials must be positive");
        this.assertInvalidFunction("wilson_interval_upper(10, 5, 2.575)", "number of successes must not be larger than number of trials");
        this.assertInvalidFunction("wilson_interval_upper(0, 100, -1)", "z-score must not be negative");
        this.assertFunction("wilson_interval_upper(1250, 1310, 1.96e0)", (Type)DoubleType.DOUBLE, 0.9642524717143908);
    }
}

