/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestProvidedBlockBuilderReturnPlaceConvention
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalarFunction(FunctionWithProvidedBlockReturnPlaceConvention1.PROVIDED_BLOCKBUILDER_CONVENTION1);
        this.registerScalarFunction(FunctionWithProvidedBlockReturnPlaceConvention2.PROVIDED_BLOCKBUILDER_CONVENTION2);
    }

    @Test
    public void testProvidedBlockBuilderReturnNullOnNull() {
        this.assertFunction("identity1(123)", (Type)IntegerType.INTEGER, 123);
        this.assertFunction("identity1(identity1(123))", (Type)IntegerType.INTEGER, 123);
        this.assertFunction("identity1(CAST(null AS INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("identity1(identity1(CAST(null AS INTEGER)))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("identity1(123.4E0)", (Type)DoubleType.DOUBLE, 123.4);
        this.assertFunction("identity1(identity1(123.4E0))", (Type)DoubleType.DOUBLE, 123.4);
        this.assertFunction("identity1(CAST(null AS DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("identity1(identity1(CAST(null AS DOUBLE)))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("identity1(true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("identity1(identity1(true))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("identity1(CAST(null AS BOOLEAN))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("identity1(identity1(CAST(null AS BOOLEAN)))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("identity1('abc')", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("identity1(identity1('abc'))", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("identity1(CAST(null AS VARCHAR))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("identity1(identity1(CAST(null AS VARCHAR)))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("identity1(ARRAY[1,2,3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("identity1(identity1(ARRAY[1,2,3]))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("identity1(CAST(null AS ARRAY<INTEGER>))", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("identity1(identity1(CAST(null AS ARRAY<INTEGER>)))", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention1.hitProvidedBlockBuilderLong.get() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention1.hitProvidedBlockBuilderDouble.get() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention1.hitProvidedBlockBuilderBoolean.get() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention1.hitProvidedBlockBuilderSlice.get() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention1.hitProvidedBlockBuilderBlock.get() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testProvidedBlockBuilderUseBoxedType() {
        this.assertFunction("identity2(123)", (Type)IntegerType.INTEGER, 123);
        this.assertFunction("identity2(identity2(123))", (Type)IntegerType.INTEGER, 123);
        this.assertFunction("identity2(CAST(null AS INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("identity2(identity2(CAST(null AS INTEGER)))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("identity2(123.4E0)", (Type)DoubleType.DOUBLE, 123.4);
        this.assertFunction("identity2(identity2(123.4E0))", (Type)DoubleType.DOUBLE, 123.4);
        this.assertFunction("identity2(CAST(null AS DOUBLE))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("identity2(identity2(CAST(null AS DOUBLE)))", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("identity2(true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("identity2(identity2(true))", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("identity2(CAST(null AS BOOLEAN))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("identity2(identity2(CAST(null AS BOOLEAN)))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("identity2('abc')", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("identity2(identity2('abc'))", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("identity2(CAST(null AS VARCHAR))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("identity2(identity2(CAST(null AS VARCHAR)))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("identity2(ARRAY[1,2,3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("identity2(identity2(ARRAY[1,2,3]))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("identity2(CAST(null AS ARRAY<INTEGER>))", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("identity2(identity2(CAST(null AS ARRAY<INTEGER>)))", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention2.hitProvidedBlockBuilderLong.get() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention2.hitProvidedBlockBuilderDouble.get() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention2.hitProvidedBlockBuilderBoolean.get() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention2.hitProvidedBlockBuilderSlice.get() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((FunctionWithProvidedBlockReturnPlaceConvention2.hitProvidedBlockBuilderBlock.get() > 0L ? 1 : 0) != 0);
    }

    public static class FunctionWithProvidedBlockReturnPlaceConvention2
    extends SqlScalarFunction {
        private static final AtomicLong hitProvidedBlockBuilderLong = new AtomicLong();
        private static final AtomicLong hitProvidedBlockBuilderDouble = new AtomicLong();
        private static final AtomicLong hitProvidedBlockBuilderBoolean = new AtomicLong();
        private static final AtomicLong hitProvidedBlockBuilderSlice = new AtomicLong();
        private static final AtomicLong hitProvidedBlockBuilderBlock = new AtomicLong();
        public static final FunctionWithProvidedBlockReturnPlaceConvention2 PROVIDED_BLOCKBUILDER_CONVENTION2 = new FunctionWithProvidedBlockReturnPlaceConvention2();
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_LONG = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention2.class, (String)"providedBlockLong", (Class[])new Class[]{Type.class, BlockBuilder.class, Long.class});
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_DOUBLE = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention2.class, (String)"providedBlockDouble", (Class[])new Class[]{Type.class, BlockBuilder.class, Double.class});
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_BOOLEAN = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention2.class, (String)"providedBlockBoolean", (Class[])new Class[]{Type.class, BlockBuilder.class, Boolean.class});
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_SLICE = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention2.class, (String)"providedBlockSlice", (Class[])new Class[]{Type.class, BlockBuilder.class, Slice.class});
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_BLOCK = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention2.class, (String)"providedBlockBlock", (Class[])new Class[]{Type.class, BlockBuilder.class, Block.class});

        protected FunctionWithProvidedBlockReturnPlaceConvention2() {
            super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"identity2"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")), false));
        }

        public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
            MethodHandle methodHandleProvidedBlock;
            Type type = boundVariables.getTypeVariable("T");
            MethodHandle methodHandleStack = MethodHandles.identity(Primitives.wrap((Class)type.getJavaType()));
            if (type.getJavaType() == Long.TYPE) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_LONG.bindTo(type);
            } else if (type.getJavaType() == Double.TYPE) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_DOUBLE.bindTo(type);
            } else if (type.getJavaType() == Boolean.TYPE) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_BOOLEAN.bindTo(type);
            } else if (type.getJavaType() == Slice.class) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_SLICE.bindTo(type);
            } else if (type.getJavaType() == Block.class) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_BLOCK.bindTo(type);
            } else {
                throw new UnsupportedOperationException();
            }
            return new BuiltInScalarFunctionImplementation((List)ImmutableList.of((Object)new BuiltInScalarFunctionImplementation.ScalarImplementationChoice(true, (List)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE)), BuiltInScalarFunctionImplementation.ReturnPlaceConvention.STACK, methodHandleStack, Optional.empty()), (Object)new BuiltInScalarFunctionImplementation.ScalarImplementationChoice(true, (List)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE)), BuiltInScalarFunctionImplementation.ReturnPlaceConvention.PROVIDED_BLOCKBUILDER, methodHandleProvidedBlock, Optional.empty())));
        }

        public static void providedBlockLong(Type type, BlockBuilder output, Long value) {
            hitProvidedBlockBuilderLong.incrementAndGet();
            if (value == null) {
                output.appendNull();
            } else {
                type.writeLong(output, value.longValue());
            }
        }

        public static void providedBlockDouble(Type type, BlockBuilder output, Double value) {
            hitProvidedBlockBuilderDouble.incrementAndGet();
            if (value == null) {
                output.appendNull();
            } else {
                type.writeDouble(output, value.doubleValue());
            }
        }

        public static void providedBlockBoolean(Type type, BlockBuilder output, Boolean value) {
            hitProvidedBlockBuilderBoolean.incrementAndGet();
            if (value == null) {
                output.appendNull();
            } else {
                type.writeBoolean(output, value.booleanValue());
            }
        }

        public static void providedBlockSlice(Type type, BlockBuilder output, Slice value) {
            hitProvidedBlockBuilderSlice.incrementAndGet();
            if (value == null) {
                output.appendNull();
            } else {
                type.writeSlice(output, value);
            }
        }

        public static void providedBlockBlock(Type type, BlockBuilder output, Block value) {
            hitProvidedBlockBuilderBlock.incrementAndGet();
            if (value == null) {
                output.appendNull();
            } else {
                type.writeObject(output, (Object)value);
            }
        }

        public boolean isDeterministic() {
            return true;
        }

        public SqlFunctionVisibility getVisibility() {
            return SqlFunctionVisibility.PUBLIC;
        }

        public String getDescription() {
            return "";
        }
    }

    public static class FunctionWithProvidedBlockReturnPlaceConvention1
    extends SqlScalarFunction {
        private static final AtomicLong hitProvidedBlockBuilderLong = new AtomicLong();
        private static final AtomicLong hitProvidedBlockBuilderDouble = new AtomicLong();
        private static final AtomicLong hitProvidedBlockBuilderBoolean = new AtomicLong();
        private static final AtomicLong hitProvidedBlockBuilderSlice = new AtomicLong();
        private static final AtomicLong hitProvidedBlockBuilderBlock = new AtomicLong();
        public static final FunctionWithProvidedBlockReturnPlaceConvention1 PROVIDED_BLOCKBUILDER_CONVENTION1 = new FunctionWithProvidedBlockReturnPlaceConvention1();
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_LONG = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention1.class, (String)"providedBlockLong", (Class[])new Class[]{Type.class, BlockBuilder.class, Long.TYPE});
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_DOUBLE = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention1.class, (String)"providedBlockDouble", (Class[])new Class[]{Type.class, BlockBuilder.class, Double.TYPE});
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_BOOLEAN = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention1.class, (String)"providedBlockBoolean", (Class[])new Class[]{Type.class, BlockBuilder.class, Boolean.TYPE});
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_SLICE = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention1.class, (String)"providedBlockSlice", (Class[])new Class[]{Type.class, BlockBuilder.class, Slice.class});
        private static final MethodHandle METHOD_HANDLE_PROVIDED_BLOCK_BLOCK = Reflection.methodHandle(FunctionWithProvidedBlockReturnPlaceConvention1.class, (String)"providedBlockBlock", (Class[])new Class[]{Type.class, BlockBuilder.class, Block.class});

        protected FunctionWithProvidedBlockReturnPlaceConvention1() {
            super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"identity1"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")), false));
        }

        public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
            MethodHandle methodHandleProvidedBlock;
            Type type = boundVariables.getTypeVariable("T");
            MethodHandle methodHandleStack = MethodHandles.identity(type.getJavaType());
            if (type.getJavaType() == Long.TYPE) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_LONG.bindTo(type);
            } else if (type.getJavaType() == Double.TYPE) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_DOUBLE.bindTo(type);
            } else if (type.getJavaType() == Boolean.TYPE) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_BOOLEAN.bindTo(type);
            } else if (type.getJavaType() == Slice.class) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_SLICE.bindTo(type);
            } else if (type.getJavaType() == Block.class) {
                methodHandleProvidedBlock = METHOD_HANDLE_PROVIDED_BLOCK_BLOCK.bindTo(type);
            } else {
                throw new UnsupportedOperationException();
            }
            return new BuiltInScalarFunctionImplementation((List)ImmutableList.of((Object)new BuiltInScalarFunctionImplementation.ScalarImplementationChoice(false, (List)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), BuiltInScalarFunctionImplementation.ReturnPlaceConvention.STACK, methodHandleStack, Optional.empty()), (Object)new BuiltInScalarFunctionImplementation.ScalarImplementationChoice(false, (List)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), BuiltInScalarFunctionImplementation.ReturnPlaceConvention.PROVIDED_BLOCKBUILDER, methodHandleProvidedBlock, Optional.empty())));
        }

        public static void providedBlockLong(Type type, BlockBuilder output, long value) {
            hitProvidedBlockBuilderLong.incrementAndGet();
            type.writeLong(output, value);
        }

        public static void providedBlockDouble(Type type, BlockBuilder output, double value) {
            hitProvidedBlockBuilderDouble.incrementAndGet();
            type.writeDouble(output, value);
        }

        public static void providedBlockBoolean(Type type, BlockBuilder output, boolean value) {
            hitProvidedBlockBuilderBoolean.incrementAndGet();
            type.writeBoolean(output, value);
        }

        public static void providedBlockSlice(Type type, BlockBuilder output, Slice value) {
            hitProvidedBlockBuilderSlice.incrementAndGet();
            type.writeSlice(output, value);
        }

        public static void providedBlockBlock(Type type, BlockBuilder output, Block value) {
            hitProvidedBlockBuilderBlock.incrementAndGet();
            type.writeObject(output, (Object)value);
        }

        public boolean isDeterministic() {
            return true;
        }

        public SqlFunctionVisibility getVisibility() {
            return SqlFunctionVisibility.PUBLIC;
        }

        public String getDescription() {
            return "";
        }
    }
}

