/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.operator.scalar.ConstructorWithInvalidTypeParameters;
import com.facebook.presto.operator.scalar.ConstructorWithValidTypeParameters;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import javax.annotation.Nullable;
import org.testng.annotations.Test;

public class TestScalarValidation {
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Parametric class method .* is annotated with @ScalarFunction")
    public void testBogusParametricMethodAnnotation() {
        TestScalarValidation.extractParametricScalar(BogusParametricMethodAnnotation.class);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Parametric class .* does not have any annotated methods")
    public void testNoParametricMethods() {
        TestScalarValidation.extractParametricScalar(NoParametricMethods.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* is missing @SqlType annotation")
    public void testMethodMissingReturnAnnotation() {
        TestScalarValidation.extractScalars(MethodMissingReturnAnnotation.class);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Method .* annotated with @SqlType is missing @ScalarFunction or @ScalarOperator")
    public void testMethodMissingScalarAnnotation() {
        TestScalarValidation.extractScalars(MethodMissingScalarAnnotation.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* has wrapper return type Long but is missing @SqlNullable")
    public void testPrimitiveWrapperReturnWithoutNullable() {
        TestScalarValidation.extractScalars(PrimitiveWrapperReturnWithoutNullable.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* annotated with @SqlNullable has primitive return type long")
    public void testPrimitiveReturnWithNullable() {
        TestScalarValidation.extractScalars(PrimitiveReturnWithNullable.class);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="A parameter with USE_NULL_FLAG or RETURN_NULL_ON_NULL convention must not use wrapper type. Found in method .*")
    public void testPrimitiveWrapperParameterWithoutNullable() {
        TestScalarValidation.extractScalars(PrimitiveWrapperParameterWithoutNullable.class);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Method .* has parameter with primitive type double annotated with @SqlNullable")
    public void testPrimitiveParameterWithNullable() {
        TestScalarValidation.extractScalars(PrimitiveParameterWithNullable.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* is missing @SqlType annotation for parameter")
    public void testParameterWithoutType() {
        TestScalarValidation.extractScalars(ParameterWithoutType.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Annotated method \\[.*\\] must be public")
    public void testNonPublicAnnnotatedMethod() {
        TestScalarValidation.extractScalars(NonPublicAnnnotatedMethod.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* is annotated with @Nullable but not @SqlNullable")
    public void testMethodWithLegacyNullable() {
        TestScalarValidation.extractScalars(MethodWithLegacyNullable.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* has @IsNull parameter that does not follow a @SqlType parameter")
    public void testParameterWithConnectorAndIsNull() {
        TestScalarValidation.extractScalars(ParameterWithConnectorAndIsNull.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* has @IsNull parameter that does not follow a @SqlType parameter")
    public void testParameterWithOnlyIsNull() {
        TestScalarValidation.extractScalars(ParameterWithOnlyIsNull.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* has non-boolean parameter with @IsNull")
    public void testParameterWithNonBooleanIsNull() {
        TestScalarValidation.extractScalars(ParameterWithNonBooleanIsNull.class);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="A parameter with USE_NULL_FLAG or RETURN_NULL_ON_NULL convention must not use wrapper type. Found in method .*")
    public void testParameterWithBoxedPrimitiveIsNull() {
        TestScalarValidation.extractScalars(ParameterWithBoxedPrimitiveIsNull.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Method .* has @IsNull parameter that has other annotations")
    public void testParameterWithOtherAnnotationsWithIsNull() {
        TestScalarValidation.extractScalars(ParameterWithOtherAnnotationsWithIsNull.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Expected type parameter to only contain A-Z and 0-9 \\(starting with A-Z\\), but got bad on method .*")
    public void testNonUpperCaseTypeParameters() {
        TestScalarValidation.extractScalars(TypeParameterWithNonUpperCaseAnnotation.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Expected type parameter to only contain A-Z and 0-9 \\(starting with A-Z\\), but got 1E on method .*")
    public void testLeadingNumericTypeParameters() {
        TestScalarValidation.extractScalars(TypeParameterWithLeadingNumbers.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Expected type parameter not to take parameters, but got E on method .*")
    public void testNonPrimitiveTypeParameters() {
        TestScalarValidation.extractScalars(TypeParameterWithNonPrimitiveAnnotation.class);
    }

    @Test
    public void testValidTypeParameters() {
        TestScalarValidation.extractScalars(ValidTypeParameter.class);
    }

    @Test
    public void testValidTypeParametersForConstructors() {
        TestScalarValidation.extractParametricScalar(ConstructorWithValidTypeParameters.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Expected type parameter not to take parameters, but got K on method .*")
    public void testInvalidTypeParametersForConstructors() {
        TestScalarValidation.extractParametricScalar(ConstructorWithInvalidTypeParameters.class);
    }

    private static void extractParametricScalar(Class<?> clazz) {
        new FunctionListBuilder().scalar(clazz);
    }

    private static void extractScalars(Class<?> clazz) {
        new FunctionListBuilder().scalars(clazz);
    }

    public static final class ValidTypeParameter {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long good1(@TypeParameter(value="ROW(ARRAY(BIGINT),MAP(INTEGER,DECIMAL),SMALLINT,CHAR,BOOLEAN,DATE,TIMESTAMP,VARCHAR)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }

        @ScalarFunction
        @SqlType(value="bigint")
        @TypeParameters(value={@TypeParameter(value="E12"), @TypeParameter(value="F34")})
        public static long good2(@TypeParameter(value="ROW(ARRAY(E12),JSON,TIME,VARBINARY,ROW(ROW(F34)))") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    public static final class TypeParameterWithNonPrimitiveAnnotation {
        @ScalarFunction
        @SqlType(value="bigint")
        @TypeParameter(value="E")
        public static long bad(@TypeParameter(value="E(VARCHAR)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    public static final class TypeParameterWithLeadingNumbers {
        @ScalarFunction
        @SqlType(value="bigint")
        @TypeParameter(value="1E")
        public static long bad(@TypeParameter(value="array(1E)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    public static final class TypeParameterWithNonUpperCaseAnnotation {
        @ScalarFunction
        @SqlType(value="bigint")
        @TypeParameter(value="bad")
        public static long bad(@TypeParameter(value="array(bad)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    public static final class ParameterWithOtherAnnotationsWithIsNull {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlType(value="bigint") long value, @IsNull @SqlNullable boolean isNull) {
            return 0L;
        }
    }

    public static final class ParameterWithBoxedPrimitiveIsNull {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlType(value="bigint") Long value, @IsNull boolean isNull) {
            return 0L;
        }
    }

    public static final class ParameterWithNonBooleanIsNull {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlType(value="bigint") long value, @IsNull int isNull) {
            return 0L;
        }
    }

    public static final class ParameterWithOnlyIsNull {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@IsNull boolean isNull) {
            return 0L;
        }
    }

    public static final class ParameterWithConnectorAndIsNull {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(SqlFunctionProperties properties, @IsNull boolean isNull) {
            return 0L;
        }
    }

    public static final class MethodWithLegacyNullable {
        @ScalarFunction
        @Nullable
        @SqlType(value="bigint")
        public static Long bad() {
            return 0L;
        }
    }

    public static final class NonPublicAnnnotatedMethod {
        @ScalarFunction
        @SqlType(value="bigint")
        private static long bad() {
            return 0L;
        }
    }

    public static final class ParameterWithoutType {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(long missing) {
            return 0L;
        }
    }

    public static final class PrimitiveParameterWithNullable {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlNullable @SqlType(value="double") double primitive) {
            return 0L;
        }
    }

    public static final class PrimitiveWrapperParameterWithoutNullable {
        @ScalarFunction
        @SqlType(value="bigint")
        public static long bad(@SqlType(value="boolean") Boolean boxed) {
            return 0L;
        }
    }

    public static final class PrimitiveReturnWithNullable {
        @ScalarFunction
        @SqlNullable
        @SqlType(value="bigint")
        public static long bad() {
            return 0L;
        }
    }

    public static final class PrimitiveWrapperReturnWithoutNullable {
        @ScalarFunction
        @SqlType(value="bigint")
        public static Long bad() {
            return 0L;
        }
    }

    public static final class MethodMissingScalarAnnotation {
        @SqlType
        public static void bad() {
        }
    }

    public static final class MethodMissingReturnAnnotation {
        @ScalarFunction
        public static void bad() {
        }
    }

    @ScalarFunction
    public static final class NoParametricMethods {
    }

    @ScalarFunction
    public static final class BogusParametricMethodAnnotation {
        @ScalarFunction
        public static void bad() {
        }
    }
}

