/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TDigestParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.TDigestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.tdigest.TDigest;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.GeometricDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTDigestFunctions
extends AbstractTestFunctions {
    private static final int NUMBER_OF_ENTRIES = 1000000;
    private static final int STANDARD_COMPRESSION_FACTOR = 100;
    private static final double STANDARD_ERROR = 0.01;
    private static final double[] quantiles = new double[]{1.0E-4, 0.02, 0.03, 0.04, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.95, 0.96, 0.97, 0.98, 0.9999};
    private static final Type TDIGEST_DOUBLE = TDigestParametricType.TDIGEST.createType((List)ImmutableList.of((Object)TypeParameter.of((Type)DoubleType.DOUBLE)));
    private static final Joiner ARRAY_JOINER = Joiner.on((String)",");
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void testNullTDigestGetValueAtQuantile() {
        this.functionAssertions.assertFunction("value_at_quantile(CAST(NULL AS tdigest(double)), 0.3)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testNullTDigestGetQuantileAtValue() {
        this.functionAssertions.assertFunction("quantile_at_value(CAST(NULL AS tdigest(double)), 0.3)", (Type)DoubleType.DOUBLE, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetValueAtQuantileOverOne() {
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS tdigest(double)), 1.5)", new SqlVarbinary(TDigest.createTDigest((double)100.0).serialize().getBytes()).toString().replaceAll("\\s+", " ")), (Type)DoubleType.DOUBLE, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetValueAtQuantileBelowZero() {
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS tdigest(double)), -0.2)", new SqlVarbinary(TDigest.createTDigest((double)100.0).serialize().getBytes()).toString().replaceAll("\\s+", " ")), (Type)DoubleType.DOUBLE, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidSerializationFormat() {
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS tdigest(double)), 0.5)", new SqlVarbinary(TDigest.createTDigest((double)100.0).serialize().getBytes()).toString().substring(0, 80).replaceAll("\\s+", " ")), (Type)DoubleType.DOUBLE, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptySerialization() {
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS tdigest(double)), 0.5)", new SqlVarbinary(new byte[0])), (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testMergeTwoNormalDistributionsGetQuantile() {
        int i;
        TDigest tDigest1 = TDigest.createTDigest((double)100.0);
        TDigest tDigest2 = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(0.0, 50.0);
        for (i = 0; i < 500000; ++i) {
            double value1 = normal.sample();
            double value2 = normal.sample();
            tDigest1.add(value1);
            tDigest2.add(value2);
            list.add(value1);
            list.add(value2);
        }
        tDigest1.merge(tDigest2);
        Collections.sort(list);
        for (i = 0; i < quantiles.length; ++i) {
            this.assertValueWithinBound(quantiles[i], 0.01, list, tDigest1);
        }
    }

    @Test
    public void testGetQuantileAtValueOutsideRange() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        for (int i = 0; i < 1000000; ++i) {
            double value = Math.random() * 1000000.0;
            tDigest.add(value);
        }
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS tdigest(%s)), %s) = 1", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE, 1.0E9), (Type)BooleanType.BOOLEAN, true);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS tdigest(%s)), %s) = 0", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE, -500.0), (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNormalDistributionHighVarianceValuesArray() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        NormalDistribution normal = new NormalDistribution(0.0, 1.0);
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < 1000000; ++i) {
            double value = normal.sample();
            tDigest.add(value);
            list.add(value);
        }
        Collections.sort(list);
        double[] values = new double[quantiles.length];
        for (int i = 0; i < quantiles.length; ++i) {
            values[i] = (Double)list.get((int)(quantiles[i] * 1000000.0));
        }
        this.assertBlockValues(values, 0.01, tDigest);
    }

    @Test
    public void testAddElementsInOrderQuantileArray() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < 1000000; ++i) {
            tDigest.add((double)i);
            list.add(Double.valueOf(i));
        }
        Collections.sort(list);
        this.assertBlockQuantiles(quantiles, 0.01, list, tDigest);
    }

    @Test
    public void testNormalDistributionHighVarianceQuantileArray() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(0.0, 1.0);
        for (int i = 0; i < 1000000; ++i) {
            double value = normal.sample();
            tDigest.add(value);
            list.add(value);
        }
        Collections.sort(list);
        this.assertBlockQuantiles(quantiles, 0.01, list, tDigest);
    }

    @Test
    public void testAddElementsInOrder() {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < 1000000; ++i) {
            tDigest.add((double)i);
            list.add(i);
        }
        for (i = 0; i < quantiles.length; ++i) {
            this.assertDiscreteQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testMergeTwoDistributionsWithoutOverlap() {
        int i;
        TDigest tDigest1 = TDigest.createTDigest((double)100.0);
        TDigest tDigest2 = TDigest.createTDigest((double)100.0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < 500000; ++i) {
            tDigest1.add((double)i);
            tDigest2.add((double)(i + 500000));
            list.add(i);
            list.add(i + 500000);
        }
        tDigest1.merge(tDigest2);
        Collections.sort(list);
        for (i = 0; i < quantiles.length; ++i) {
            this.assertDiscreteQuantileWithinBound(quantiles[i], 0.01, list, tDigest1);
        }
    }

    @Test
    public void testMergeTwoDistributionsWithOverlap() {
        int i;
        TDigest tDigest1 = TDigest.createTDigest((double)100.0);
        TDigest tDigest2 = TDigest.createTDigest((double)100.0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < 500000; ++i) {
            tDigest1.add((double)i);
            tDigest2.add((double)i);
            list.add(i);
            list.add(i);
        }
        tDigest2.merge(tDigest1);
        Collections.sort(list);
        for (i = 0; i < quantiles.length; ++i) {
            this.assertDiscreteQuantileWithinBound(quantiles[i], 0.01, list, tDigest2);
        }
    }

    @Test
    public void testAddElementsRandomized() {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        for (i = 0; i < 1000000; ++i) {
            double value = Math.random() * 1000000.0;
            tDigest.add(value);
            list.add(value);
        }
        Collections.sort(list);
        for (i = 0; i < quantiles.length; ++i) {
            this.assertContinuousQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testNormalDistributionLowVariance() {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(1000.0, 1.0);
        for (i = 0; i < 1000000; ++i) {
            double value = normal.sample();
            tDigest.add(value);
            list.add(value);
        }
        Collections.sort(list);
        for (i = 0; i < quantiles.length; ++i) {
            this.assertContinuousQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testNormalDistributionHighVariance() {
        int i;
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(0.0, 1.0);
        for (i = 0; i < 1000000; ++i) {
            double value = normal.sample();
            tDigest.add(value);
            list.add(value);
        }
        Collections.sort(list);
        for (i = 0; i < quantiles.length; ++i) {
            this.assertContinuousQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testMergeTwoNormalDistributions() {
        int i;
        TDigest tDigest1 = TDigest.createTDigest((double)100.0);
        TDigest tDigest2 = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(0.0, 50.0);
        for (i = 0; i < 500000; ++i) {
            double value1 = normal.sample();
            double value2 = normal.sample();
            tDigest1.add(value1);
            tDigest2.add(value2);
            list.add(value1);
            list.add(value2);
        }
        tDigest1.merge(tDigest2);
        Collections.sort(list);
        for (i = 0; i < quantiles.length; ++i) {
            this.assertContinuousQuantileWithinBound(quantiles[i], 0.01, list, tDigest1);
        }
    }

    @Test
    public void testMergeManySmallNormalDistributions() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(500.0, 20.0);
        int digests = 100000;
        for (int k = 0; k < digests; ++k) {
            TDigest current = TDigest.createTDigest((double)100.0);
            for (int i = 0; i < 10; ++i) {
                double value = normal.sample();
                current.add(value);
                list.add(value);
            }
            tDigest.merge(current);
        }
        Collections.sort(list);
        for (int i = 0; i < quantiles.length; ++i) {
            this.assertContinuousQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testMergeManyLargeNormalDistributions() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> list = new ArrayList<Double>();
        NormalDistribution normal = new NormalDistribution(500.0, 20.0);
        int digests = 1000;
        for (int k = 0; k < digests; ++k) {
            TDigest current = TDigest.createTDigest((double)100.0);
            for (int i = 0; i < 1000000 / digests; ++i) {
                double value = normal.sample();
                current.add(value);
                list.add(value);
            }
            tDigest.merge(current);
        }
        Collections.sort(list);
        for (int i = 0; i < quantiles.length; ++i) {
            this.assertContinuousQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
        }
    }

    @Test
    public void testDestructureTDigest() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ImmutableList values = ImmutableList.of((Object)0.0, (Object)1.0, (Object)2.0, (Object)3.0, (Object)4.0, (Object)5.0, (Object)6.0, (Object)7.0, (Object)8.0, (Object)9.0);
        values.stream().forEach(arg_0 -> ((TDigest)tDigest).add(arg_0));
        List<Integer> weights = Collections.nCopies(values.size(), 1);
        double compression = 100.0;
        double min = values.stream().reduce(Double.POSITIVE_INFINITY, Double::min);
        double max = values.stream().reduce(Double.NEGATIVE_INFINITY, Double::max);
        double sum = values.stream().reduce(0.0, Double::sum);
        long count = values.size();
        String sql = String.format("destructure_tdigest(CAST(X'%s' AS tdigest(%s)))", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE);
        this.functionAssertions.assertFunction(sql, (Type)TDigestFunctions.TDIGEST_CENTROIDS_ROW_TYPE, ImmutableList.of((Object)values, weights, (Object)compression, (Object)min, (Object)max, (Object)sum, (Object)count));
        this.functionAssertions.assertFunction(String.format("%s.compression", sql), (Type)DoubleType.DOUBLE, compression);
        this.functionAssertions.assertFunction(String.format("%s.min", sql), (Type)DoubleType.DOUBLE, min);
        this.functionAssertions.assertFunction(String.format("%s.max", sql), (Type)DoubleType.DOUBLE, max);
        this.functionAssertions.assertFunction(String.format("%s.sum", sql), (Type)DoubleType.DOUBLE, sum);
        this.functionAssertions.assertFunction(String.format("%s.count", sql), (Type)BigintType.BIGINT, count);
        this.functionAssertions.assertFunction(String.format("%s.centroid_means", sql), (Type)new ArrayType((Type)DoubleType.DOUBLE), values);
        this.functionAssertions.assertFunction(String.format("%s.centroid_weights", sql), (Type)new ArrayType((Type)IntegerType.INTEGER), weights);
    }

    @Test
    public void testDestructureTDigestLarge() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < 1000000; ++i) {
            values.add(Double.valueOf(i));
        }
        values.stream().forEach(arg_0 -> ((TDigest)tDigest).add(arg_0));
        double compression = 100.0;
        double min = values.stream().reduce(Double.POSITIVE_INFINITY, Double::min);
        double max = values.stream().reduce(Double.NEGATIVE_INFINITY, Double::max);
        double sum = values.stream().reduce(0.0, Double::sum);
        long count = values.size();
        String sql = String.format("destructure_tdigest(CAST(X'%s' AS tdigest(%s)))", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE);
        this.functionAssertions.assertFunction(String.format("%s.compression", sql), (Type)DoubleType.DOUBLE, compression);
        this.functionAssertions.assertFunction(String.format("%s.min", sql), (Type)DoubleType.DOUBLE, min);
        this.functionAssertions.assertFunction(String.format("%s.max", sql), (Type)DoubleType.DOUBLE, max);
        this.functionAssertions.assertFunction(String.format("%s.sum", sql), (Type)DoubleType.DOUBLE, sum);
        this.functionAssertions.assertFunction(String.format("%s.count", sql), (Type)BigintType.BIGINT, count);
    }

    @Test(enabled=false)
    public void testBinomialDistribution() {
        int trials = 10;
        for (int k = 1; k < trials; ++k) {
            int i;
            TDigest tDigest = TDigest.createTDigest((double)100.0);
            BinomialDistribution binomial = new BinomialDistribution(trials, (double)k * 0.1);
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < 1000000; ++i) {
                int sample = binomial.sample();
                tDigest.add((double)sample);
                list.add(sample);
            }
            Collections.sort(list);
            for (i = 0; i < quantiles.length; ++i) {
                this.assertDiscreteQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
            }
        }
    }

    @Test(enabled=false)
    public void testGeometricDistribution() {
        int trials = 10;
        for (int k = 1; k < trials; ++k) {
            int i;
            TDigest tDigest = TDigest.createTDigest((double)100.0);
            GeometricDistribution geometric = new GeometricDistribution((double)k * 0.1);
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < 1000000; ++i) {
                int sample = geometric.sample();
                tDigest.add((double)sample);
                list.add(sample);
            }
            Collections.sort(list);
            for (i = 0; i < quantiles.length; ++i) {
                this.assertDiscreteQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
            }
        }
    }

    @Test(enabled=false)
    public void testPoissonDistribution() {
        int trials = 10;
        for (int k = 1; k < trials; ++k) {
            int i;
            TDigest tDigest = TDigest.createTDigest((double)100.0);
            PoissonDistribution poisson = new PoissonDistribution((double)k * 0.1);
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < 1000000; ++i) {
                int sample = poisson.sample();
                tDigest.add((double)sample);
                list.add(sample);
            }
            Collections.sort(list);
            for (i = 0; i < quantiles.length; ++i) {
                this.assertDiscreteQuantileWithinBound(quantiles[i], 0.01, list, tDigest);
            }
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Scale factor should be positive\\.")
    public void testScaleNegative() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        TestTDigestFunctions.addAll(tDigest, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        this.functionAssertions.selectSingleValue(String.format("scale_tdigest(CAST(X'%s' AS tdigest(double)), -1)", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " ")), TDIGEST_DOUBLE, SqlVarbinary.class);
    }

    @Test
    public void testScale() {
        TDigest tDigest = TDigest.createTDigest((double)100.0);
        TestTDigestFunctions.addAll(tDigest, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        List<Double> unscaledFrequencies = this.getFrequencies(tDigest, Arrays.asList(2.0, 4.0, 6.0, 8.0));
        SqlVarbinary sqlVarbinary = this.functionAssertions.selectSingleValue(String.format("scale_tdigest(CAST(X'%s' AS tdigest(double)), 2)", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " ")), TDIGEST_DOUBLE, SqlVarbinary.class);
        TDigest scaledTdigest = TDigest.createTDigest((Slice)Slices.wrappedBuffer((byte[])sqlVarbinary.getBytes()));
        List<Double> scaledDigestFrequencies = this.getFrequencies(scaledTdigest, Arrays.asList(2.0, 4.0, 6.0, 8.0));
        ArrayList scaledUpFrequencies = new ArrayList();
        unscaledFrequencies.forEach(frequency -> scaledUpFrequencies.add(frequency * 2.0));
        Assert.assertEquals(scaledDigestFrequencies, scaledUpFrequencies);
        sqlVarbinary = this.functionAssertions.selectSingleValue(String.format("scale_tdigest(CAST(X'%s' AS tdigest(double)), 0.5)", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " ")), TDIGEST_DOUBLE, SqlVarbinary.class);
        scaledTdigest = TDigest.createTDigest((Slice)Slices.wrappedBuffer((byte[])sqlVarbinary.getBytes()));
        scaledDigestFrequencies = this.getFrequencies(scaledTdigest, Arrays.asList(2.0, 4.0, 6.0, 8.0));
        ArrayList scaledDownFrequencies = new ArrayList();
        unscaledFrequencies.forEach(frequency -> scaledDownFrequencies.add(frequency * 0.5));
        Assert.assertEquals(scaledDigestFrequencies, scaledDownFrequencies);
    }

    private static void addAll(TDigest digest, double ... values) {
        Objects.requireNonNull(values, "values is null");
        for (double value : values) {
            digest.add(value);
        }
    }

    private void assertValueWithinBound(double quantile, double error, List<Double> list, TDigest tDigest) {
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS tdigest(%s)), %s) <= %s", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE, list.get((int)(1000000.0 * quantile)), this.getUpperBoundQuantile(quantile, error)), (Type)BooleanType.BOOLEAN, true);
        this.functionAssertions.assertFunction(String.format("quantile_at_value(CAST(X'%s' AS tdigest(%s)), %s) >= %s", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE, list.get((int)(1000000.0 * quantile)), this.getLowerBoundQuantile(quantile, error)), (Type)BooleanType.BOOLEAN, true);
    }

    private void assertDiscreteQuantileWithinBound(double quantile, double error, List<Integer> list, TDigest tDigest) {
        this.functionAssertions.assertFunction(String.format("round(value_at_quantile(CAST(X'%s' AS tdigest(%s)), %s)) <= %s", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE, quantile, this.getUpperBoundValue(quantile, error, list)), (Type)BooleanType.BOOLEAN, true);
        this.functionAssertions.assertFunction(String.format("round(value_at_quantile(CAST(X'%s' AS tdigest(%s)), %s)) >= %s", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE, quantile, this.getLowerBoundValue(quantile, error, list)), (Type)BooleanType.BOOLEAN, true);
    }

    private void assertContinuousQuantileWithinBound(double quantile, double error, List<Double> list, TDigest tDigest) {
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS tdigest(%s)), %s) <= %s", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE, quantile, this.getUpperBoundValue(quantile, error, list)), (Type)BooleanType.BOOLEAN, true);
        this.functionAssertions.assertFunction(String.format("value_at_quantile(CAST(X'%s' AS tdigest(%s)), %s) >= %s", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), DoubleType.DOUBLE, quantile, this.getLowerBoundValue(quantile, error, list)), (Type)BooleanType.BOOLEAN, true);
    }

    private List<Double> getFrequencies(TDigest tdigest, List<Double> buckets) {
        ArrayList<Double> histogram = new ArrayList<Double>();
        for (Double bin : buckets) {
            histogram.add(tdigest.getCdf(bin.doubleValue()) * tdigest.getSize());
        }
        return histogram;
    }

    private double getLowerBoundValue(double quantile, double error, List<? extends Number> values) {
        return values.get((int)Math.max(1000000.0 * (quantile - error), 0.0)).doubleValue();
    }

    private double getUpperBoundValue(double quantile, double error, List<? extends Number> values) {
        return values.get((int)Math.min(1000000.0 * (quantile + error), (double)(values.size() - 1))).doubleValue();
    }

    private double getLowerBoundQuantile(double quantile, double error) {
        return Math.max(0.0, quantile - error);
    }

    private double getUpperBoundQuantile(double quantile, double error) {
        return Math.min(1.0, quantile + error);
    }

    private void assertBlockQuantiles(double[] percentiles, double error, List<? extends Number> rows, TDigest tDigest) {
        List boxedPercentiles = (List)Arrays.stream(percentiles).sorted().boxed().collect(ImmutableList.toImmutableList());
        List lowerBounds = (List)boxedPercentiles.stream().map(percentile -> this.getLowerBoundValue((double)percentile, error, rows)).collect(ImmutableList.toImmutableList());
        List upperBounds = (List)boxedPercentiles.stream().map(percentile -> this.getUpperBoundValue((double)percentile, error, rows)).collect(ImmutableList.toImmutableList());
        this.functionAssertions.assertFunction(String.format("zip_with(values_at_quantiles(CAST(X'%s' AS tdigest(%s)), ARRAY[%s]), ARRAY[%s], (value, lowerbound) -> value >= lowerbound)", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), "double", ARRAY_JOINER.join((Iterable)boxedPercentiles), ARRAY_JOINER.join((Iterable)lowerBounds)), METADATA.getType(TypeSignature.parseTypeSignature((String)"array(boolean)")), Collections.nCopies(percentiles.length, true));
        this.functionAssertions.assertFunction(String.format("zip_with(values_at_quantiles(CAST(X'%s' AS tdigest(%s)), ARRAY[%s]), ARRAY[%s], (value, upperbound) -> value <= upperbound)", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), "double", ARRAY_JOINER.join((Iterable)boxedPercentiles), ARRAY_JOINER.join((Iterable)upperBounds)), METADATA.getType(TypeSignature.parseTypeSignature((String)"array(boolean)")), Collections.nCopies(percentiles.length, true));
    }

    private void assertBlockValues(double[] values, double error, TDigest tDigest) {
        List boxedValues = (List)Arrays.stream(values).sorted().boxed().collect(ImmutableList.toImmutableList());
        List boxedPercentiles = (List)Arrays.stream(quantiles).sorted().boxed().collect(ImmutableList.toImmutableList());
        List lowerBounds = (List)boxedPercentiles.stream().map(percentile -> this.getLowerBoundQuantile((double)percentile, error)).collect(ImmutableList.toImmutableList());
        List upperBounds = (List)boxedPercentiles.stream().map(percentile -> this.getUpperBoundQuantile((double)percentile, error)).collect(ImmutableList.toImmutableList());
        this.functionAssertions.assertFunction(String.format("zip_with(quantiles_at_values(CAST(X'%s' AS tdigest(%s)), ARRAY[%s]), ARRAY[%s], (value, lowerbound) -> value >= lowerbound)", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), "double", ARRAY_JOINER.join((Iterable)boxedValues), ARRAY_JOINER.join((Iterable)lowerBounds)), METADATA.getType(TypeSignature.parseTypeSignature((String)"array(boolean)")), Collections.nCopies(values.length, true));
        this.functionAssertions.assertFunction(String.format("zip_with(quantiles_at_values(CAST(X'%s' AS tdigest(%s)), ARRAY[%s]), ARRAY[%s], (value, upperbound) -> value <= upperbound)", new SqlVarbinary(tDigest.serialize().getBytes()).toString().replaceAll("\\s+", " "), "double", ARRAY_JOINER.join((Iterable)boxedValues), ARRAY_JOINER.join((Iterable)upperBounds)), METADATA.getType(TypeSignature.parseTypeSignature((String)"array(boolean)")), Collections.nCopies(values.length, true));
    }
}

