/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import org.testng.annotations.Test;

public class TestTruncateWithPrecision
extends AbstractTestFunctions {
    @Test
    public void testTruncate() {
        this.assertFunction("truncate(nan(),-1)", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("truncate(infinity(),1)", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("truncate(-infinity(),1)", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertFunction("truncate(DOUBLE '17.1', -1)", (Type)DoubleType.DOUBLE, 10.0);
        this.assertFunction("truncate(DOUBLE '1234.56', 1)", (Type)DoubleType.DOUBLE, 1234.5);
        this.assertFunction("truncate(DOUBLE '1234.56', 0)", (Type)DoubleType.DOUBLE, 1234.0);
        this.assertFunction("truncate(DOUBLE '-1234.56', 0)", (Type)DoubleType.DOUBLE, -1234.0);
        this.assertFunction("truncate(DOUBLE '-1234.56', -500)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("truncate(DOUBLE '1234.567', 2)", (Type)DoubleType.DOUBLE, 1234.56);
        this.assertFunction("truncate(DOUBLE '1234.567', 2)", (Type)DoubleType.DOUBLE, 1234.56);
        this.assertFunction("truncate(DOUBLE '1.7976931348623157E308', -408)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("truncate(DOUBLE '-1.7976931348623158E307', 408)", (Type)DoubleType.DOUBLE, -1.7976931348623158E307);
        this.assertFunction("truncate(DOUBLE '9.223372036854776E18', -15)", (Type)DoubleType.DOUBLE, 9.223E18);
        this.assertFunction("truncate(REAL '12.333', 0)", (Type)RealType.REAL, Float.valueOf(12.0f));
        this.assertFunction("truncate(REAL '-12.333', 0)", (Type)RealType.REAL, Float.valueOf(-12.0f));
        this.assertFunction("truncate(REAL '12.123456789011234567892', 10)", (Type)RealType.REAL, Float.valueOf(12.123457f));
        this.assertFunction("truncate(REAL '12.333', -1)", (Type)RealType.REAL, Float.valueOf(10.0f));
        this.assertFunction("truncate(REAL '12.333', -500)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("truncate(REAL '3.40287e37', -35)", (Type)RealType.REAL, Float.valueOf(3.4E37f));
        this.assertFunction("truncate(REAL '3.40287e37', -488)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("truncate(REAL '9.223372E18', -15)", (Type)RealType.REAL, Float.valueOf(9.223E18f));
    }
}

