/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.testng.Assert;

public class TestUnnesterUtil {
    private TestUnnesterUtil() {
    }

    static int[] calculateMaxCardinalities(Page page, List<Type> replicatedTypes, List<Type> unnestTypes) {
        int positionCount = page.getPositionCount();
        int[] maxCardinalities = new int[positionCount];
        int replicatedChannelCount = replicatedTypes.size();
        int unnestChannelCount = unnestTypes.size();
        for (int i = 0; i < unnestChannelCount; ++i) {
            int j;
            Type type = unnestTypes.get(i);
            Block block = page.getBlock(replicatedChannelCount + i);
            Assert.assertTrue((type instanceof ArrayType || type instanceof MapType ? 1 : 0) != 0);
            if (type instanceof ArrayType) {
                ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
                for (j = 0; j < positionCount; ++j) {
                    maxCardinalities[j] = Integer.max(maxCardinalities[j], columnarArray.getLength(j));
                }
                continue;
            }
            if (type instanceof MapType) {
                ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
                for (j = 0; j < positionCount; ++j) {
                    maxCardinalities[j] = Integer.max(maxCardinalities[j], columnarMap.getEntryCount(j));
                }
                continue;
            }
            Assert.fail((String)("expected an ArrayType or MapType, but found " + type));
        }
        return maxCardinalities;
    }

    static Page buildExpectedPage(Page page, List<Type> replicatedTypes, List<Type> unnestTypes, List<Type> outputTypes, int[] maxCardinalities, boolean withOrdinality, boolean legacyUnnest) {
        int i;
        int totalEntries = IntStream.of(maxCardinalities).sum();
        int channelCount = page.getChannelCount();
        Assert.assertTrue((channelCount > 1 ? 1 : 0) != 0);
        Block[] outputBlocks = new Block[outputTypes.size()];
        int outputChannel = 0;
        for (i = 0; i < replicatedTypes.size(); ++i) {
            outputBlocks[outputChannel++] = TestUnnesterUtil.buildExpectedReplicatedBlock(page.getBlock(i), replicatedTypes.get(i), maxCardinalities, totalEntries);
        }
        for (i = 0; i < unnestTypes.size(); ++i) {
            Type type = unnestTypes.get(i);
            Block inputBlock = page.getBlock(replicatedTypes.size() + i);
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (elementType instanceof RowType && !legacyUnnest) {
                    Block[] blocks;
                    List rowTypes = ((RowType)elementType).getTypeParameters();
                    Block[] blockArray = blocks = TestUnnesterUtil.buildExpectedUnnestedArrayOfRowBlock(inputBlock, rowTypes, maxCardinalities, totalEntries);
                    int n = blockArray.length;
                    for (int j = 0; j < n; ++j) {
                        Block block = blockArray[j];
                        outputBlocks[outputChannel++] = block;
                    }
                    continue;
                }
                outputBlocks[outputChannel++] = TestUnnesterUtil.buildExpectedUnnestedArrayBlock(inputBlock, ((ArrayType)unnestTypes.get(i)).getElementType(), maxCardinalities, totalEntries);
                continue;
            }
            if (type instanceof MapType) {
                Block[] blocks;
                MapType mapType = (MapType)unnestTypes.get(i);
                for (Block block : blocks = TestUnnesterUtil.buildExpectedUnnestedMapBlocks(inputBlock, mapType.getKeyType(), mapType.getValueType(), maxCardinalities, totalEntries)) {
                    outputBlocks[outputChannel++] = block;
                }
                continue;
            }
            Assert.fail((String)("expected an ArrayType or MapType, but found " + type));
        }
        if (withOrdinality) {
            outputBlocks[outputChannel++] = TestUnnesterUtil.buildExpectedOrdinalityBlock(maxCardinalities, totalEntries);
        }
        return new Page(outputBlocks);
    }

    static List<Type> buildOutputTypes(List<Type> replicatedTypes, List<Type> unnestTypes, boolean withOrdinality, boolean legacyUnnest) {
        ArrayList<Type> outputTypes = new ArrayList<Type>();
        for (Type replicatedType : replicatedTypes) {
            outputTypes.add(replicatedType);
        }
        for (Type unnestType : unnestTypes) {
            if (unnestType instanceof ArrayType) {
                Type elementType = ((ArrayType)unnestType).getElementType();
                if (elementType instanceof RowType && !legacyUnnest) {
                    List rowTypes = ((RowType)elementType).getTypeParameters();
                    for (Type rowType : rowTypes) {
                        outputTypes.add(rowType);
                    }
                    continue;
                }
                outputTypes.add(elementType);
                continue;
            }
            if (!(unnestType instanceof MapType)) continue;
            outputTypes.add(((MapType)unnestType).getKeyType());
            outputTypes.add(((MapType)unnestType).getValueType());
        }
        if (withOrdinality) {
            outputTypes.add((Type)BigintType.BIGINT);
        }
        return outputTypes;
    }

    static Page mergePages(List<Type> types, List<Page> pages) {
        PageBuilder pageBuilder = new PageBuilder(types);
        int totalPositionCount = 0;
        for (Page page : pages) {
            Verify.verify((page.getChannelCount() == types.size() ? 1 : 0) != 0, (String)String.format("Number of channels in page %d is not equal to number of types %d", page.getChannelCount(), types.size()), (Object[])new Object[0]);
            for (int i = 0; i < types.size(); ++i) {
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                Block block = page.getBlock(i);
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    block.writePositionTo(position, blockBuilder);
                }
            }
            totalPositionCount += page.getPositionCount();
        }
        pageBuilder.declarePositions(totalPositionCount);
        return pageBuilder.build();
    }

    private static Block buildExpectedReplicatedBlock(Block block, Type type, int[] maxCardinalities, int totalEntries) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = maxCardinalities[i];
            for (int j = 0; j < cardinality; ++j) {
                type.appendTo(block, i, blockBuilder);
            }
        }
        return blockBuilder.build();
    }

    private static Block buildExpectedUnnestedArrayBlock(Block block, Type type, int[] maxCardinalities, int totalEntries) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
        Block elementBlock = columnarArray.getElementsBlock();
        BlockBuilder blockBuilder = type.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        int elementBlockPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = columnarArray.getLength(i);
            for (int j = 0; j < cardinality; ++j) {
                type.appendTo(elementBlock, elementBlockPosition++, blockBuilder);
            }
            int maxCardinality = maxCardinalities[i];
            for (int j = cardinality; j < maxCardinality; ++j) {
                blockBuilder.appendNull();
            }
        }
        return blockBuilder.build();
    }

    private static Block[] buildExpectedUnnestedMapBlocks(Block block, Type keyType, Type valueType, int[] maxCardinalities, int totalEntries) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Block keyBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        BlockBuilder keyBlockBuilder = keyType.createBlockBuilder(null, totalEntries);
        BlockBuilder valueBlockBuilder = valueType.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        int blockPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = columnarMap.getEntryCount(i);
            for (int j = 0; j < cardinality; ++j) {
                keyType.appendTo(keyBlock, blockPosition, keyBlockBuilder);
                valueType.appendTo(valuesBlock, blockPosition, valueBlockBuilder);
                ++blockPosition;
            }
            int maxCardinality = maxCardinalities[i];
            for (int j = cardinality; j < maxCardinality; ++j) {
                keyBlockBuilder.appendNull();
                valueBlockBuilder.appendNull();
            }
        }
        Block[] blocks = new Block[]{keyBlockBuilder.build(), valueBlockBuilder.build()};
        return blocks;
    }

    private static Block[] buildExpectedUnnestedArrayOfRowBlock(Block block, List<Type> rowTypes, int[] maxCardinalities, int totalEntries) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
        Block elementBlock = columnarArray.getElementsBlock();
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)elementBlock);
        int fieldCount = columnarRow.getFieldCount();
        Block[] blocks = new Block[fieldCount];
        int positionCount = block.getPositionCount();
        for (int i = 0; i < fieldCount; ++i) {
            BlockBuilder blockBuilder = rowTypes.get(i).createBlockBuilder(null, totalEntries);
            int nullRowsEncountered = 0;
            for (int j = 0; j < positionCount; ++j) {
                int rowBlockIndex = columnarArray.getOffset(j);
                int cardinality = columnarArray.getLength(j);
                for (int k = 0; k < cardinality; ++k) {
                    if (columnarRow.isNull(rowBlockIndex + k)) {
                        blockBuilder.appendNull();
                        ++nullRowsEncountered;
                        continue;
                    }
                    rowTypes.get(i).appendTo(columnarRow.getField(i), rowBlockIndex + k - nullRowsEncountered, blockBuilder);
                }
                int maxCardinality = maxCardinalities[j];
                for (int k = cardinality; k < maxCardinality; ++k) {
                    blockBuilder.appendNull();
                }
            }
            blocks[i] = blockBuilder.build();
        }
        return blocks;
    }

    private static Block buildExpectedOrdinalityBlock(int[] maxCardinalities, int totalEntries) {
        BlockBuilder ordinalityBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, totalEntries);
        for (int i = 0; i < maxCardinalities.length; ++i) {
            int maxCardinality = maxCardinalities[i];
            for (int ordinalityCount = 1; ordinalityCount <= maxCardinality; ++ordinalityCount) {
                BigintType.BIGINT.writeLong(ordinalityBlockBuilder, (long)ordinalityCount);
            }
        }
        return ordinalityBlockBuilder.build();
    }
}

