/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.window.AbstractTestWindowFunction;
import com.facebook.presto.testing.MaterializedResult;
import org.testng.annotations.Test;

public class TestNthValueFunction
extends AbstractTestWindowFunction {
    @Test
    public void testNthValueUnbounded() {
        this.assertUnboundedWindowQuery("nth_value(orderkey, 2) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", 5}).row(new Object[]{5, "F", 5}).row(new Object[]{6, "F", 5}).row(new Object[]{33, "F", 5}).row(new Object[]{1, "O", 2}).row(new Object[]{2, "O", 2}).row(new Object[]{4, "O", 2}).row(new Object[]{7, "O", 2}).row(new Object[]{32, "O", 2}).row(new Object[]{34, "O", 2}).build());
        this.assertUnboundedWindowQueryWithNulls("nth_value(orderkey, 2) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3L, "F", 5L}).row(new Object[]{5L, "F", 5L}).row(new Object[]{6L, "F", 5L}).row(new Object[]{null, "F", 5L}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, 7L}).row(new Object[]{7L, null, 7L}).row(new Object[]{null, null, 7L}).row(new Object[]{null, null, 7L}).build());
        this.assertUnboundedWindowQuery("nth_value(orderkey, orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", 6}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 2}).row(new Object[]{4, "O", 7}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
        this.assertUnboundedWindowQueryWithNulls("nth_value(orderkey, orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey DESC NULLS FIRST)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3L, "F", 5L}).row(new Object[]{5L, "F", null}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
        this.assertUnboundedWindowQuery("nth_value(orderkey, null) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
        this.assertUnboundedWindowQuery("nth_value(orderkey, BIGINT '8' * 1000 * 1000 * 1000) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{6, "F", null}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", null}).row(new Object[]{4, "O", null}).row(new Object[]{7, "O", null}).row(new Object[]{32, "O", null}).row(new Object[]{34, "O", null}).build());
    }

    @Test
    public void testNthValueUnboundedIgnoreNulls() {
        this.assertUnboundedWindowQueryWithNulls("nth_value(orderkey, 3) IGNORE NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3L, "F", 6L}).row(new Object[]{5L, "F", 6L}).row(new Object[]{6L, "F", 6L}).row(new Object[]{null, "F", 6L}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }

    @Test
    public void testNthValueUnboundedRespectNulls() {
        this.assertUnboundedWindowQueryWithNulls("nth_value(orderkey, 3) RESPECT NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3L, "F", 6L}).row(new Object[]{5L, "F", 6L}).row(new Object[]{6L, "F", 6L}).row(new Object[]{null, "F", 6L}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }

    @Test
    public void testNthValueBounded() {
        this.assertWindowQuery("nth_value(orderkey, 4) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", 33}).row(new Object[]{6, "F", 33}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", 7}).row(new Object[]{4, "O", 7}).row(new Object[]{7, "O", 32}).row(new Object[]{32, "O", 34}).row(new Object[]{34, "O", null}).build());
        this.assertWindowQueryWithNulls("nth_value(orderkey, 4) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", null}).row(new Object[]{5L, "F", null}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
        this.assertWindowQuery("date_format(nth_value(cast(orderdate as TIMESTAMP), 2) OVER (PARTITION BY orderstatus ORDER BY orderkey), '%Y-%m-%d')", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", "1994-07-30"}).row(new Object[]{6, "F", "1994-07-30"}).row(new Object[]{33, "F", "1994-07-30"}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", "1996-12-01"}).row(new Object[]{4, "O", "1996-12-01"}).row(new Object[]{7, "O", "1996-12-01"}).row(new Object[]{32, "O", "1996-12-01"}).row(new Object[]{34, "O", "1996-12-01"}).build());
    }

    @Test
    public void testNthValueBoundedIgnoreNulls() {
        this.assertWindowQueryWithNulls("nth_value(orderkey, 3) IGNORE NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 6L}).row(new Object[]{5L, "F", 6L}).row(new Object[]{6L, "F", 6L}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }

    @Test
    public void testNthValueBoundedRespectNulls() {
        this.assertWindowQueryWithNulls("nth_value(orderkey, 4) RESPECT NULLS OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", null}).row(new Object[]{5L, "F", null}).row(new Object[]{6L, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34L, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
    }
}

