/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.ManagedQueryExecution;
import com.facebook.presto.execution.MockManagedQueryExecution;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStatusSender;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.resourcemanager.TestingResourceManagerClient;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.spi.ConnectorId;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestResourceManagerClusterStatusSender {
    public static final ConnectorId CONNECTOR_ID = new ConnectorId("dummy");
    public static final NodeStatus NODE_STATUS = new NodeStatus("nodeId", new NodeVersion("1"), "environment", false, new Duration(1.0, TimeUnit.SECONDS), "externalAddress", "internalAddress", new MemoryInfo(new DataSize(1.0, DataSize.Unit.MEGABYTE), (Map)ImmutableMap.of()), 1, 1.0, 2.0, 1L, 2L, 3L);
    private static final int HEARTBEAT_INTERVAL = 100;
    private static final int SLEEP_DURATION = 1000;
    private static final int TARGET_HEARTBEATS = 10;
    private ResourceManagerClusterStatusSender sender;
    private TestingResourceManagerClient resourceManagerClient;

    @BeforeTest
    public void setup() {
        this.resourceManagerClient = new TestingResourceManagerClient();
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode("identifier", URI.create("http://localhost:80/identifier"), OptionalInt.of(1), "1", false, true)});
        this.sender = new ResourceManagerClusterStatusSender((addressSelectionContext, headers) -> this.resourceManagerClient, (InternalNodeManager)nodeManager, () -> NODE_STATUS, Executors.newSingleThreadScheduledExecutor(), new ResourceManagerConfig().setNodeHeartbeatInterval(new Duration(100.0, TimeUnit.MILLISECONDS)).setQueryHeartbeatInterval(new Duration(100.0, TimeUnit.MILLISECONDS)));
    }

    @AfterTest
    public void tearDown() {
        this.sender.stop();
    }

    @Test(timeOut=2000L)
    public void testNodeStatus() throws Exception {
        this.sender.init();
        Thread.sleep(1000L);
        int nodeHeartbeats = this.resourceManagerClient.getNodeHeartbeats();
        Assert.assertTrue(((double)nodeHeartbeats > 5.0 && (double)nodeHeartbeats <= 15.0 ? 1 : 0) != 0, (String)String.format("Expect number of heartbeats to fall within target range (%s), +/- 50%%.  Was: %s", 10, nodeHeartbeats));
    }

    @Test(timeOut=4000L)
    public void testQueryHeartbeat() throws Exception {
        MockManagedQueryExecution queryExecution = new MockManagedQueryExecution(1L);
        this.sender.registerQuery((ManagedQueryExecution)queryExecution);
        Thread.sleep(1000L);
        int queryHeartbeats = this.resourceManagerClient.getQueryHeartbeats();
        Assert.assertTrue(((double)queryHeartbeats > 5.0 && (double)queryHeartbeats <= 15.0 ? 1 : 0) != 0, (String)String.format("Expect number of heartbeats to fall within target range (%s), +/- 50%%.  Was: %s", 10, queryHeartbeats));
        queryExecution.complete();
        queryHeartbeats = this.resourceManagerClient.getQueryHeartbeats();
        Thread.sleep(1000L);
        Assert.assertTrue((this.resourceManagerClient.getQueryHeartbeats() <= queryHeartbeats + 1 ? 1 : 0) != 0);
    }
}

