/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestResourceManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ResourceManagerConfig)ConfigAssertions.recordDefaults(ResourceManagerConfig.class)).setCompletedQueryExpirationTimeout(new Duration(10.0, TimeUnit.MINUTES)).setQueryExpirationTimeout(new Duration(10.0, TimeUnit.SECONDS)).setMaxCompletedQueries(100).setHeartbeatConcurrency(3).setHeartbeatThreads(3).setNodeStatusTimeout(new Duration(30.0, TimeUnit.SECONDS)).setMemoryPoolInfoRefreshDuration(new Duration(1.0, TimeUnit.SECONDS)).setResourceManagerExecutorThreads(1000).setNodeHeartbeatInterval(new Duration(1.0, TimeUnit.SECONDS)).setQueryHeartbeatInterval(new Duration(1.0, TimeUnit.SECONDS)).setProxyAsyncTimeout(new Duration(60.0, TimeUnit.SECONDS)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"resource-manager.query-expiration-timeout", (Object)"2h").put((Object)"resource-manager.completed-query-expiration-timeout", (Object)"1h").put((Object)"resource-manager.max-completed-queries", (Object)"9").put((Object)"resource-manager.heartbeat-threads", (Object)"5").put((Object)"resource-manager.heartbeat-concurrency", (Object)"6").put((Object)"resource-manager.node-status-timeout", (Object)"1h").put((Object)"resource-manager.memory-pool-info-refresh-duration", (Object)"2h").put((Object)"resource-manager.executor-threads", (Object)"1234").put((Object)"resource-manager.node-heartbeat-interval", (Object)"25m").put((Object)"resource-manager.query-heartbeat-interval", (Object)"75m").put((Object)"resource-manager.proxy-async-timeout", (Object)"345m").build();
        ResourceManagerConfig expected = new ResourceManagerConfig().setCompletedQueryExpirationTimeout(new Duration(1.0, TimeUnit.HOURS)).setQueryExpirationTimeout(new Duration(2.0, TimeUnit.HOURS)).setMaxCompletedQueries(9).setHeartbeatThreads(5).setHeartbeatConcurrency(6).setNodeStatusTimeout(new Duration(1.0, TimeUnit.HOURS)).setMemoryPoolInfoRefreshDuration(new Duration(2.0, TimeUnit.HOURS)).setResourceManagerExecutorThreads(1234).setNodeHeartbeatInterval(new Duration(25.0, TimeUnit.MINUTES)).setQueryHeartbeatInterval(new Duration(75.0, TimeUnit.MINUTES)).setProxyAsyncTimeout(new Duration(345.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

