/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.resourcemanager.ResourceManagerClient;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class TestingResourceManagerClient
implements ResourceManagerClient {
    private final AtomicInteger queryHeartbeats = new AtomicInteger();
    private final AtomicInteger nodeHeartbeats = new AtomicInteger();
    private final Map<String, Integer> resourceGroupInfoCalls = new ConcurrentHashMap<String, Integer>();
    private volatile List<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfos = ImmutableList.of();

    TestingResourceManagerClient() {
    }

    public void queryHeartbeat(String internalNode, BasicQueryInfo basicQueryInfo) {
        this.queryHeartbeats.incrementAndGet();
    }

    public List<ResourceGroupRuntimeInfo> getResourceGroupInfo(InternalNode internalNode) {
        this.resourceGroupInfoCalls.putIfAbsent(internalNode.getNodeIdentifier(), 0);
        this.resourceGroupInfoCalls.compute(internalNode.getNodeIdentifier(), (s, integer) -> integer + 1);
        return this.resourceGroupRuntimeInfos;
    }

    public void setResourceGroupRuntimeInfos(List<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfos) {
        this.resourceGroupRuntimeInfos = ImmutableList.copyOf(resourceGroupRuntimeInfos);
    }

    public void nodeHeartbeat(NodeStatus nodeStatus) {
        this.nodeHeartbeats.incrementAndGet();
    }

    public Map<MemoryPoolId, ClusterMemoryPoolInfo> getMemoryPoolInfo() {
        return ImmutableMap.of();
    }

    public int getQueryHeartbeats() {
        return this.queryHeartbeats.get();
    }

    public int getNodeHeartbeats() {
        return this.nodeHeartbeats.get();
    }

    public int getResourceGroupInfoCalls(String identifier) {
        return this.resourceGroupInfoCalls.get(identifier);
    }
}

