/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.server.QueryProgressStats;
import java.util.OptionalDouble;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryProgressStats {
    @Test
    public void testJson() {
        QueryProgressStats expected = new QueryProgressStats(123456L, 1111L, 22222L, 3333L, 100000L, 34230492L, 34230493L, 34230494L, 1000L, 100000L, false, OptionalDouble.of(33.33));
        JsonCodec codec = JsonCodec.jsonCodec(QueryProgressStats.class);
        String json = codec.toJson((Object)expected);
        QueryProgressStats actual = (QueryProgressStats)codec.fromJson(json);
        Assert.assertEquals((long)actual.getElapsedTimeMillis(), (long)123456L);
        Assert.assertEquals((long)actual.getQueuedTimeMillis(), (long)1111L);
        Assert.assertEquals((long)actual.getCpuTimeMillis(), (long)22222L);
        Assert.assertEquals((long)actual.getScheduledTimeMillis(), (long)3333L);
        Assert.assertEquals((long)actual.getCurrentMemoryBytes(), (long)100000L);
        Assert.assertEquals((long)actual.getPeakMemoryBytes(), (long)34230492L);
        Assert.assertEquals((long)actual.getPeakTotalMemoryBytes(), (long)34230493L);
        Assert.assertEquals((long)actual.getPeakTaskTotalMemoryBytes(), (long)34230494L);
        Assert.assertEquals((long)actual.getInputRows(), (long)1000L);
        Assert.assertEquals((long)actual.getInputBytes(), (long)100000L);
        Assert.assertFalse((boolean)actual.isBlocked());
        Assert.assertEquals((Object)actual.getProgressPercentage(), (Object)OptionalDouble.of(33.33));
    }
}

