/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.http.client.UnexpectedResponseException;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tpch.TpchPlugin;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestQueryStateInfoResource {
    private static final String LONG_LASTING_QUERY = "SELECT * FROM tpch.sf1.lineitem";
    private static final JsonCodec<QueryResults> QUERY_RESULTS_JSON_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private TestingPrestoServer server = new TestingPrestoServer();
    private HttpClient client;
    private QueryResults queryResults;

    TestQueryStateInfoResource() throws Exception {
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("tpch", "tpch");
        this.client = new JettyHttpClient();
    }

    @BeforeClass
    public void setup() {
        List queryInfos;
        Request request1 = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)LONG_LASTING_QUERY, (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user1").build();
        this.queryResults = (QueryResults)this.client.execute(request1, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        this.client.execute(Request.Builder.prepareGet().setUri(this.queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        Request request2 = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)LONG_LASTING_QUERY, (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user2").build();
        QueryResults queryResults2 = (QueryResults)this.client.execute(request2, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        this.client.execute(Request.Builder.prepareGet().setUri(queryResults2.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        while ((queryInfos = (List)this.client.execute(Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").build()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(BasicQueryInfo.class)))).size() != 2 || !queryInfos.stream().allMatch(info -> info.getState() == QueryState.RUNNING)) {
        }
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testGetAllQueryStateInfos() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState")).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assert.assertEquals((int)infos.size(), (int)2);
    }

    @Test
    public void testGetQueryStateInfosForUser() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState?user=user2")).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assert.assertEquals((int)infos.size(), (int)1);
    }

    @Test
    public void testGetQueryStateInfosForUserNoResult() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState?user=user3")).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        org.testng.Assert.assertTrue((boolean)infos.isEmpty());
    }

    @Test
    public void testGetQueryStateInfo() {
        QueryStateInfo info = (QueryStateInfo)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState/" + this.queryResults.getId())).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryStateInfo.class)));
        org.testng.Assert.assertNotNull((Object)info);
    }

    @Test(expectedExceptions={UnexpectedResponseException.class}, expectedExceptionsMessageRegExp=".*404: Not Found")
    public void testGetQueryStateInfoNo() {
        this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState/123")).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryStateInfo.class)));
    }
}

