/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.drift.client.DriftClientFactory;
import com.facebook.drift.client.ExceptionClassifier;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelector;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.server.DriftServer;
import com.facebook.drift.server.guice.DriftServerBinder;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.facebook.drift.transport.netty.client.DriftNettyClientConfig;
import com.facebook.drift.transport.netty.client.DriftNettyMethodInvokerFactory;
import com.facebook.drift.transport.netty.server.DriftNettyServerModule;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransport;
import com.facebook.presto.Session;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.ThriftBufferResult;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.server.ForAsyncRpc;
import com.facebook.presto.server.thrift.ThriftTaskClient;
import com.facebook.presto.server.thrift.ThriftTaskService;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Singleton;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestThriftTaskIntegration {
    private LifeCycleManager lifeCycleManager;
    private int thriftServerPort;

    @BeforeClass
    public void setup() throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new DriftNettyServerModule(), new TestingTaskThriftModule()});
        Injector injector = app.doNotInitializeLogging().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.thriftServerPort = TestThriftTaskIntegration.driftServerPort((DriftServer)injector.getInstance(DriftServer.class));
    }

    @AfterClass
    public void teardown() {
        if (this.lifeCycleManager != null) {
            this.lifeCycleManager.stop();
        }
    }

    @Test
    public void testServer() {
        SimpleAddressSelector addressSelector = new SimpleAddressSelector((Iterable)ImmutableSet.of((Object)HostAndPort.fromParts((String)"localhost", (int)this.thriftServerPort)), true);
        try (DriftNettyMethodInvokerFactory invokerFactory = DriftNettyMethodInvokerFactory.createStaticDriftNettyMethodInvokerFactory((DriftNettyClientConfig)new DriftNettyClientConfig());){
            DriftClientFactory clientFactory = new DriftClientFactory(new ThriftCodecManager(new ThriftCodec[0]), (MethodInvokerFactory)invokerFactory, (AddressSelector)addressSelector, ExceptionClassifier.NORMAL_RESULT);
            ThriftTaskClient client = (ThriftTaskClient)clientFactory.createDriftClient(ThriftTaskClient.class).get();
            ListenableFuture result = client.getResults(TaskId.valueOf((String)"queryid.0.0.0"), new OutputBuffers.OutputBufferId(1), 0L, 100L);
            Assert.assertTrue((boolean)((ThriftBufferResult)result.get()).isBufferComplete());
            Assert.assertTrue((boolean)((ThriftBufferResult)result.get()).getSerializedPages().isEmpty());
            Assert.assertEquals((long)((ThriftBufferResult)result.get()).getToken(), (long)1L);
            Assert.assertEquals((String)((ThriftBufferResult)result.get()).getTaskInstanceId(), (String)"test");
            client.acknowledgeResults(TaskId.valueOf((String)"queryid.0.0.0"), new OutputBuffers.OutputBufferId(1), 42L).get();
            client.acknowledgeResults(TaskId.valueOf((String)"queryid.0.0.0"), new OutputBuffers.OutputBufferId(1), 42L);
            client.abortResults(TaskId.valueOf((String)"queryid.0.0.0"), new OutputBuffers.OutputBufferId(1)).get();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    private static int driftServerPort(DriftServer server) {
        return ((DriftNettyServerTransport)server.getServerTransport()).getPort();
    }

    public static class TestingTaskThriftModule
    implements Module {
        public void configure(Binder binder) {
            binder.bind(ThriftTaskService.class).in(Scopes.SINGLETON);
            DriftServerBinder.driftServerBinder((Binder)binder).bindService(ThriftTaskService.class);
        }

        @Provides
        @Singleton
        @ForAsyncRpc
        public static ExecutorService createAsyncHttpResponseCoreExecutor() {
            return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"async-http-response-%s"));
        }

        @Provides
        @Singleton
        @ForAsyncRpc
        public static BoundedExecutor createAsyncHttpResponseExecutor(@ForAsyncRpc ExecutorService coreExecutor) {
            return new BoundedExecutor((Executor)coreExecutor, 100);
        }

        @Provides
        @Singleton
        @ForAsyncRpc
        public static ScheduledExecutorService createAsyncHttpTimeoutExecutor() {
            return Executors.newScheduledThreadPool(10, Threads.daemonThreadsNamed((String)"async-http-timeout-%s"));
        }

        @Provides
        @Singleton
        public static TaskManager createTaskManager() {
            return new TaskManager(){

                public List<TaskInfo> getAllTaskInfo() {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo getTaskInfo(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public TaskStatus getTaskStatus(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public ListenableFuture<TaskInfo> getTaskInfo(TaskId taskId, TaskState currentState) {
                    throw new UnsupportedOperationException();
                }

                public String getTaskInstanceId(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public ListenableFuture<TaskStatus> getTaskStatus(TaskId taskId, TaskState currentState) {
                    throw new UnsupportedOperationException();
                }

                public void updateMemoryPoolAssignments(MemoryPoolAssignmentsRequest assignments) {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo updateTask(Session session, TaskId taskId, Optional<PlanFragment> fragment, List<TaskSource> sources, OutputBuffers outputBuffers, Optional<TableWriteInfo> tableWriteInfo) {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo cancelTask(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo abortTask(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public ListenableFuture<BufferResult> getTaskResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId, long startingSequenceId, DataSize maxSize) {
                    return Futures.immediateFuture((Object)BufferResult.emptyResults((String)"test", (long)1L, (boolean)true));
                }

                public void acknowledgeTaskResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId, long sequenceId) {
                    Assert.assertEquals((Object)taskId, (Object)TaskId.valueOf((String)"queryid.0.0.0"));
                    Assert.assertEquals((Object)bufferId, (Object)new OutputBuffers.OutputBufferId(1));
                    Assert.assertEquals((long)sequenceId, (long)42L);
                }

                public TaskInfo abortTaskResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId) {
                    Assert.assertEquals((Object)taskId, (Object)TaskId.valueOf((String)"queryid.0.0.0"));
                    Assert.assertEquals((Object)bufferId, (Object)new OutputBuffers.OutputBufferId(1));
                    return null;
                }

                public void addStateChangeListener(TaskId taskId, StateMachine.StateChangeListener<TaskState> stateChangeListener) {
                    throw new UnsupportedOperationException();
                }

                public void removeRemoteSource(TaskId taskId, TaskId remoteSourceTaskId) {
                    throw new UnsupportedOperationException();
                }

                public void updateMetadataResults(TaskId taskId, MetadataUpdates metadataUpdates) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

