/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.smile;

import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.testing.TestingResponse;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.airlift.json.smile.SmileCodecFactory;
import com.facebook.presto.server.smile.FullSmileResponseHandler;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFullSmileResponseHandler {
    private static final MediaType MEDIA_TYPE_SMILE = MediaType.create((String)"application", (String)"x-jackson-smile");
    private final SmileCodecFactory codecFactory = new SmileCodecFactory();
    private final SmileCodec<User> codec = this.codecFactory.smileCodec(User.class);
    private final FullSmileResponseHandler<User> handler = FullSmileResponseHandler.createFullSmileResponseHandler(this.codec);

    @Test
    public void testValidSmile() {
        User user = new User("Joe", 25);
        byte[] smileBytes = this.codec.toBytes((Object)user);
        FullSmileResponseHandler.SmileResponse response = this.handler.handle(null, TestFullSmileResponseHandler.mockResponse(HttpStatus.OK, MEDIA_TYPE_SMILE, smileBytes));
        Assert.assertTrue((boolean)response.hasValue());
        Assert.assertEquals((Object)response.getSmileBytes(), (Object)smileBytes);
        Assert.assertEquals((String)((User)response.getValue()).getName(), (String)user.getName());
        Assert.assertEquals((int)((User)response.getValue()).getAge(), (int)user.getAge());
        Assert.assertNotSame((Object)response.getSmileBytes(), (Object)response.getSmileBytes());
        Assert.assertNotSame((Object)response.getResponseBytes(), (Object)response.getResponseBytes());
        Assert.assertEquals((Object)response.getResponseBytes(), (Object)response.getSmileBytes());
    }

    @Test
    public void testInvalidSmile() {
        byte[] invalidSmileBytes = "test".getBytes(StandardCharsets.UTF_8);
        FullSmileResponseHandler.SmileResponse response = this.handler.handle(null, TestFullSmileResponseHandler.mockResponse(HttpStatus.OK, MEDIA_TYPE_SMILE, invalidSmileBytes));
        Assert.assertFalse((boolean)response.hasValue());
        Assert.assertEquals((String)response.getException().getMessage(), (String)String.format("Unable to create %s from SMILE response", User.class));
        Assert.assertTrue((boolean)(response.getException().getCause() instanceof IllegalArgumentException));
        Assert.assertEquals((String)response.getException().getCause().getMessage(), (String)"Invalid SMILE bytes for [simple type, class com.facebook.presto.server.smile.TestFullSmileResponseHandler$User]");
        Assert.assertEquals((Object)response.getSmileBytes(), (Object)invalidSmileBytes);
        Assert.assertEquals((Object)response.getResponseBytes(), (Object)response.getSmileBytes());
    }

    @Test
    public void testInvalidSmileGetValue() {
        byte[] invalidSmileBytes = "test".getBytes(StandardCharsets.UTF_8);
        FullSmileResponseHandler.SmileResponse response = this.handler.handle(null, TestFullSmileResponseHandler.mockResponse(HttpStatus.OK, MEDIA_TYPE_SMILE, invalidSmileBytes));
        try {
            response.getValue();
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Response does not contain a SMILE value");
            Assert.assertEquals((Object)e.getCause(), (Object)response.getException());
            Assert.assertEquals((Object)response.getSmileBytes(), (Object)invalidSmileBytes);
            Assert.assertEquals((Object)response.getResponseBytes(), (Object)response.getSmileBytes());
        }
    }

    @Test
    public void testNonSmileResponse() {
        FullSmileResponseHandler.SmileResponse response = this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"hello"));
        Assert.assertFalse((boolean)response.hasValue());
        Assert.assertNull((Object)response.getException());
        Assert.assertNull((Object)response.getSmileBytes());
        Assert.assertEquals((Object)response.getResponseBytes(), (Object)"hello".getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void testMissingContentType() {
        FullSmileResponseHandler.SmileResponse response = this.handler.handle(null, (Response)new TestingResponse(HttpStatus.OK, (ListMultimap)ImmutableListMultimap.of(), "hello".getBytes(StandardCharsets.UTF_8)));
        Assert.assertFalse((boolean)response.hasValue());
        Assert.assertNull((Object)response.getException());
        Assert.assertNull((Object)response.getSmileBytes());
        Assert.assertEquals((Object)response.getResponseBytes(), (Object)"hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)response.getHeaders().isEmpty());
    }

    @Test
    public void testSmileErrorResponse() {
        User user = new User("Joe", 25);
        byte[] smileBytes = this.codec.toBytes((Object)user);
        FullSmileResponseHandler.SmileResponse response = this.handler.handle(null, TestFullSmileResponseHandler.mockResponse(HttpStatus.INTERNAL_SERVER_ERROR, MEDIA_TYPE_SMILE, smileBytes));
        Assert.assertTrue((boolean)response.hasValue());
        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.INTERNAL_SERVER_ERROR.code());
        Assert.assertEquals((Object)response.getResponseBytes(), (Object)response.getSmileBytes());
    }

    private static Response mockResponse(HttpStatus status, MediaType type, byte[] content) {
        return new TestingResponse(status, TestingResponse.contentType((MediaType)type), content);
    }

    public static class User {
        private final String name;
        private final int age;

        @JsonCreator
        public User(@JsonProperty(value="name") String name, @JsonProperty(value="age") int age) {
            this.name = name;
            this.age = age;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public int getAge() {
            return this.age;
        }
    }
}

