/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spiller.AesSpillCipher;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAesSpillCipher {
    @Test
    public void test() {
        AesSpillCipher spillCipher = new AesSpillCipher();
        for (int size = 0; size <= 257; ++size) {
            byte[] data = TestAesSpillCipher.randomBytes(size);
            Assert.assertEquals((Object)data, (Object)spillCipher.decrypt(spillCipher.encrypt((byte[])data.clone())));
            Assert.assertEquals((Object)ByteBuffer.wrap(data), (Object)spillCipher.decrypt(spillCipher.encrypt(ByteBuffer.wrap((byte[])data.clone()))));
        }
        Assert.assertNotEquals((Object)spillCipher.encrypt(new byte[0]), (Object)spillCipher.encrypt(new byte[0]), (String)"IV values must not be reused");
        Assert.assertFalse((boolean)spillCipher.isDestroyed());
        byte[] encrypted = spillCipher.encrypt(TestAesSpillCipher.randomBytes(1));
        spillCipher.destroy();
        Assert.assertTrue((boolean)spillCipher.isDestroyed());
        spillCipher.destroy();
        TestAesSpillCipher.assertFailure(() -> spillCipher.decrypt(encrypted), "Spill cipher already destroyed");
        TestAesSpillCipher.assertFailure(() -> spillCipher.encrypt(TestAesSpillCipher.randomBytes(1)), "Spill cipher already destroyed");
    }

    private static void assertFailure(Assert.ThrowingRunnable runnable, String expectedErrorMessage) {
        PrestoException exception = (PrestoException)Assert.expectThrows(PrestoException.class, (Assert.ThrowingRunnable)runnable);
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        Assert.assertEquals((String)exception.getMessage(), (String)expectedErrorMessage);
    }

    private static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }
}

