/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.io.OutputStreamDataSink;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.page.PageCodecMarker;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spiller.SingleStreamSpiller;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.spiller.TempStorageSingleStreamSpiller;
import com.facebook.presto.spiller.TempStorageSingleStreamSpillerFactory;
import com.facebook.presto.spiller.TestingSpillContext;
import com.facebook.presto.storage.TempStorageManager;
import com.facebook.presto.testing.TestingTempStorageManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTempStorageSingleStreamSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY);
    private ListeningExecutorService executor;
    private final File tempDirectory = com.google.common.io.Files.createTempDir();

    @BeforeClass
    public void setUp() {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.executor.shutdown();
        MoreFiles.deleteRecursively((Path)this.tempDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testSpill() throws Exception {
        this.assertSpill(false, false);
    }

    @Test
    public void testSpillCompression() throws Exception {
        this.assertSpill(true, false);
    }

    @Test
    public void testSpillEncryption() throws Exception {
        this.assertSpill(false, true);
    }

    @Test
    public void testSpillEncryptionWithCompression() throws Exception {
        this.assertSpill(true, true);
    }

    private void assertSpill(boolean compression, boolean encryption) throws Exception {
        File spillPath = new File(this.tempDirectory, UUID.randomUUID().toString());
        TempStorageSingleStreamSpillerFactory spillerFactory = new TempStorageSingleStreamSpillerFactory((TempStorageManager)new TestingTempStorageManager(spillPath.toString()), this.executor, (BlockEncodingSerde)new BlockEncodingManager(), new SpillerStats(), compression, encryption, "local");
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test");
        SingleStreamSpiller singleStreamSpiller = spillerFactory.create(TYPES, (SpillContext)new TestingSpillContext(), memoryContext);
        Assert.assertTrue((boolean)(singleStreamSpiller instanceof TempStorageSingleStreamSpiller));
        TempStorageSingleStreamSpiller spiller = (TempStorageSingleStreamSpiller)singleStreamSpiller;
        Page page = this.buildPage();
        int retainedSizeForEmptyDataSink = Math.toIntExact(new OutputStreamDataSink((OutputStream)new DynamicSliceOutput(0)).getRetainedSizeInBytes());
        Assert.assertEquals((long)memoryContext.getBytes(), (long)retainedSizeForEmptyDataSink);
        spiller.spill(page).get();
        spiller.spill((Iterator)Iterators.forArray((Object[])new Page[]{page, page, page})).get();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)spillPath.toPath()).size(), (int)1);
        Iterator spilledPagesIterator = spiller.getSpilledPages();
        Assert.assertEquals((long)memoryContext.getBytes(), (long)retainedSizeForEmptyDataSink);
        ImmutableList spilledPages = ImmutableList.copyOf((Iterator)spilledPagesIterator);
        Assert.assertEquals((int)4, (int)spilledPages.size());
        for (int i = 0; i < 4; ++i) {
            PageAssertions.assertPageEquals(TYPES, page, (Page)spilledPages.get(i));
        }
        try (InputStream is = Files.newInputStream((Path)MoreFiles.listFiles((Path)spillPath.toPath()).get(0), new OpenOption[0]);){
            Iterator serializedPages = PagesSerdeUtil.readSerializedPages((SliceInput)new InputStreamSliceInput(is));
            Assert.assertTrue((boolean)serializedPages.hasNext(), (String)"at least one page should be successfully read back");
            byte markers = ((SerializedPage)serializedPages.next()).getPageCodecMarkers();
            Assert.assertEquals((boolean)PageCodecMarker.COMPRESSED.isSet(markers), (boolean)compression);
            Assert.assertEquals((boolean)PageCodecMarker.ENCRYPTED.isSet(markers), (boolean)encryption);
        }
        spiller.close();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)spillPath.toPath()).size(), (int)0);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
    }

    private Page buildPage() {
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        BlockBuilder col2 = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        BlockBuilder col3 = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        col1.writeLong(42L).closeEntry();
        col2.writeLong(Double.doubleToLongBits(43.0)).closeEntry();
        col3.writeLong(Double.doubleToLongBits(43.0)).writeLong(1L).closeEntry();
        return new Page(new Block[]{col1.build(), col2.build(), col3.build()});
    }
}

