/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockJsonSerde;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.slice.Slice;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRowExpressionSerde {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private JsonCodec<RowExpression> codec;

    @BeforeClass
    public void setUp() throws Exception {
        this.codec = this.getJsonCodec();
    }

    @Test
    public void testSimpleLiteral() {
        this.assertLiteral("TRUE", Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN));
        this.assertLiteral("FALSE", Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN));
        this.assertLiteral("CAST(NULL AS BOOLEAN)", Expressions.constant(null, (Type)BooleanType.BOOLEAN));
        this.assertLiteral("TINYINT '1'", Expressions.constant((Object)1L, (Type)TinyintType.TINYINT));
        this.assertLiteral("SMALLINT '1'", Expressions.constant((Object)1L, (Type)SmallintType.SMALLINT));
        this.assertLiteral("1", Expressions.constant((Object)1L, (Type)IntegerType.INTEGER));
        this.assertLiteral("BIGINT '1'", Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
        this.assertLiteral("1.1", Expressions.constant((Object)1.1, (Type)DoubleType.DOUBLE));
        this.assertLiteral("nan()", Expressions.constant((Object)Double.NaN, (Type)DoubleType.DOUBLE));
        this.assertLiteral("infinity()", Expressions.constant((Object)Double.POSITIVE_INFINITY, (Type)DoubleType.DOUBLE));
        this.assertLiteral("-infinity()", Expressions.constant((Object)Double.NEGATIVE_INFINITY, (Type)DoubleType.DOUBLE));
        this.assertLiteral("CAST(1.1 AS REAL)", Expressions.constant((Object)Float.floatToIntBits(1.1f), (Type)RealType.REAL));
        this.assertLiteral("CAST(nan() AS REAL)", Expressions.constant((Object)Float.floatToIntBits(Float.NaN), (Type)RealType.REAL));
        this.assertLiteral("CAST(infinity() AS REAL)", Expressions.constant((Object)Float.floatToIntBits(Float.POSITIVE_INFINITY), (Type)RealType.REAL));
        this.assertLiteral("CAST(-infinity() AS REAL)", Expressions.constant((Object)Float.floatToIntBits(Float.NEGATIVE_INFINITY), (Type)RealType.REAL));
        this.assertStringLiteral("'String Literal'", "String Literal", (Type)VarcharType.createVarcharType((int)14));
        this.assertLiteral("CAST(NULL AS VARCHAR)", Expressions.constant(null, (Type)VarcharType.VARCHAR));
        this.assertLiteral("DATE '1991-01-01'", Expressions.constant((Object)7670L, (Type)DateType.DATE));
        this.assertLiteral("TIMESTAMP '1991-01-01 00:00:00.000'", Expressions.constant((Object)662727600000L, (Type)TimestampType.TIMESTAMP));
    }

    @Test
    public void testArrayLiteral() {
        RowExpression rowExpression = this.getRoundTrip("ARRAY [1, 2, 3]", true);
        Assert.assertTrue((boolean)(rowExpression instanceof ConstantExpression));
        Object value = ((ConstantExpression)rowExpression).getValue();
        Assert.assertTrue((boolean)(value instanceof IntArrayBlock));
        IntArrayBlock block = (IntArrayBlock)value;
        Assert.assertEquals((int)block.getPositionCount(), (int)3);
        Assert.assertEquals((int)block.getInt(0), (int)1);
        Assert.assertEquals((int)block.getInt(1), (int)2);
        Assert.assertEquals((int)block.getInt(2), (int)3);
    }

    @Test
    public void testArrayGet() {
        Assert.assertEquals((Object)this.getRoundTrip("(ARRAY [1, 2, 3])[1]", false), (Object)Expressions.call((String)OperatorType.SUBSCRIPT.name(), (FunctionHandle)this.operator(OperatorType.SUBSCRIPT, new Type[]{new ArrayType((Type)IntegerType.INTEGER), BigintType.BIGINT}), (Type)IntegerType.INTEGER, (RowExpression[])new RowExpression[]{Expressions.call((String)"array_constructor", (FunctionHandle)this.function("array_constructor", new Type[]{IntegerType.INTEGER, IntegerType.INTEGER, IntegerType.INTEGER}), (Type)new ArrayType((Type)IntegerType.INTEGER), (RowExpression[])new RowExpression[]{Expressions.constant((Object)1L, (Type)IntegerType.INTEGER), Expressions.constant((Object)2L, (Type)IntegerType.INTEGER), Expressions.constant((Object)3L, (Type)IntegerType.INTEGER)}), Expressions.constant((Object)1L, (Type)IntegerType.INTEGER)}));
        Assert.assertEquals((Object)this.getRoundTrip("(ARRAY [1, 2, 3])[1]", true), (Object)Expressions.constant((Object)1L, (Type)IntegerType.INTEGER));
    }

    @Test
    public void testRowLiteral() {
        Assert.assertEquals((Object)this.getRoundTrip("ROW(1, 1.1)", false), (Object)Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.ROW_CONSTRUCTOR, (Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE)), (RowExpression[])new RowExpression[]{Expressions.constant((Object)1L, (Type)IntegerType.INTEGER), Expressions.constant((Object)1.1, (Type)DoubleType.DOUBLE)}));
    }

    @Test
    public void testDereference() {
        String sql = "CAST(ROW(1) AS ROW(col1 integer)).col1";
        RowExpression before = this.translate(PlanBuilder.expression(sql, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)), false);
        RowExpression after = this.getRoundTrip(sql, false);
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testHllLiteral() {
        RowExpression rowExpression = this.getRoundTrip("empty_approx_set()", true);
        Assert.assertTrue((boolean)(rowExpression instanceof ConstantExpression));
        Object value = ((ConstantExpression)rowExpression).getValue();
        Assert.assertEquals((long)HyperLogLog.newInstance((Slice)((Slice)value)).cardinality(), (long)0L);
    }

    @Test
    public void testUnserializableType() {
        this.assertThrowsWhenSerialize("CAST('$.a' AS JsonPath)", true);
    }

    private void assertThrowsWhenSerialize(@Language(value="SQL") String sql, boolean optimize) {
        RowExpression rowExpression = this.translate(PlanBuilder.expression(sql, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)), optimize);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.codec.toJson((Object)rowExpression));
    }

    private void assertLiteral(@Language(value="SQL") String sql, ConstantExpression expected) {
        Assert.assertEquals((Object)this.getRoundTrip(sql, true), (Object)expected);
    }

    private void assertStringLiteral(@Language(value="SQL") String sql, String expectedString, Type expectedType) {
        RowExpression roundTrip = this.getRoundTrip(sql, true);
        Assert.assertTrue((boolean)(roundTrip instanceof ConstantExpression));
        String roundTripValue = ((Slice)((ConstantExpression)roundTrip).getValue()).toStringUtf8();
        Type roundTripType = roundTrip.getType();
        Assert.assertEquals((String)roundTripValue, (String)expectedString);
        Assert.assertEquals((Object)roundTripType, (Object)expectedType);
    }

    private RowExpression getRoundTrip(String sql, boolean optimize) {
        RowExpression rowExpression = this.translate(PlanBuilder.expression(sql, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE)), optimize);
        String json = this.codec.toJson((Object)rowExpression);
        return (RowExpression)this.codec.fromJson(json);
    }

    private FunctionHandle operator(OperatorType operatorType, Type ... types) {
        return this.metadata.getFunctionAndTypeManager().resolveOperator(operatorType, TypeSignatureProvider.fromTypes((Type[])types));
    }

    private FunctionHandle function(String name, Type ... types) {
        return this.metadata.getFunctionAndTypeManager().lookupFunction(name, TypeSignatureProvider.fromTypes((Type[])types));
    }

    private JsonCodec<RowExpression> getJsonCodec() throws Exception {
        Module module = binder -> {
            binder.install((Module)new JsonModule());
            binder.install((Module)new HandleJsonModule());
            ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
            FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            binder.bind(TypeManager.class).toInstance((Object)functionAndTypeManager);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
            Multibinder.newSetBinder((Binder)binder, Type.class);
            binder.bind(BlockEncodingSerde.class).to(BlockEncodingManager.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)binder, BlockEncoding.class);
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Block.class).to(BlockJsonSerde.Serializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Block.class).to(BlockJsonSerde.Deserializer.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(RowExpression.class);
        };
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.of((Object)module));
        Injector injector = app.doNotInitializeLogging().quiet().initialize();
        return (JsonCodec)injector.getInstance((Key)new Key<JsonCodec<RowExpression>>(){});
    }

    private RowExpression translate(Expression expression, boolean optimize) {
        RowExpression rowExpression = SqlToRowExpressionTranslator.translate((Expression)expression, this.getExpressionTypes(expression), (Map)ImmutableMap.of(), (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)SessionTestUtils.TEST_SESSION);
        if (optimize) {
            RowExpressionOptimizer optimizer = new RowExpressionOptimizer(this.metadata);
            return optimizer.optimize(rowExpression, ExpressionOptimizer.Level.OPTIMIZED, SessionTestUtils.TEST_SESSION.toConnectorSession());
        }
        return rowExpression;
    }

    private Map<NodeRef<Expression>, Type> getExpressionTypes(Expression expression) {
        ExpressionAnalyzer expressionAnalyzer = ExpressionAnalyzer.createWithoutSubqueries((FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)SessionTestUtils.TEST_SESSION, (TypeProvider)TypeProvider.empty(), Collections.emptyList(), node -> new IllegalStateException("Unexpected node: %s" + node), (WarningCollector)WarningCollector.NOOP, (boolean)false);
        expressionAnalyzer.analyze(expression, Scope.create());
        return expressionAnalyzer.getExpressionTypes();
    }
}

