/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedName;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestScope {
    @Test
    public void test() {
        Scope root = Scope.create();
        Field outerColumn1 = Field.newQualified((QualifiedName)QualifiedName.of((String)"outer", (String[])new String[]{"column1"}), Optional.of("c1"), (Type)BigintType.BIGINT, (boolean)false, Optional.empty(), Optional.empty(), (boolean)false);
        Field outerColumn2 = Field.newQualified((QualifiedName)QualifiedName.of((String)"outer", (String[])new String[]{"column2"}), Optional.of("c2"), (Type)BigintType.BIGINT, (boolean)false, Optional.empty(), Optional.empty(), (boolean)false);
        Scope outer = Scope.builder().withParent(root).withRelationType(RelationId.anonymous(), new RelationType(new Field[]{outerColumn1, outerColumn2})).build();
        Field innerColumn2 = Field.newQualified((QualifiedName)QualifiedName.of((String)"inner", (String[])new String[]{"column2"}), Optional.of("c2"), (Type)BigintType.BIGINT, (boolean)false, Optional.empty(), Optional.empty(), (boolean)false);
        Field innerColumn3 = Field.newQualified((QualifiedName)QualifiedName.of((String)"inner", (String[])new String[]{"column3"}), Optional.of("c3"), (Type)BigintType.BIGINT, (boolean)false, Optional.empty(), Optional.empty(), (boolean)false);
        Scope inner = Scope.builder().withOuterQueryParent(outer).withRelationType(RelationId.anonymous(), new RelationType(new Field[]{innerColumn2, innerColumn3})).build();
        Expression c1 = TestScope.name("c1", new String[0]);
        Expression c2 = TestScope.name("c2", new String[0]);
        Expression c3 = TestScope.name("c3", new String[0]);
        Expression c4 = TestScope.name("c4", new String[0]);
        Assert.assertFalse((boolean)root.tryResolveField(c1).isPresent());
        Assert.assertTrue((boolean)outer.tryResolveField(c1).isPresent());
        Assert.assertEquals((Object)((ResolvedField)outer.tryResolveField(c1).get()).getField(), (Object)outerColumn1);
        Assert.assertEquals((boolean)((ResolvedField)outer.tryResolveField(c1).get()).isLocal(), (boolean)true);
        Assert.assertEquals((int)((ResolvedField)outer.tryResolveField(c1).get()).getHierarchyFieldIndex(), (int)0);
        Assert.assertTrue((boolean)outer.tryResolveField(c2).isPresent());
        Assert.assertEquals((Object)((ResolvedField)outer.tryResolveField(c2).get()).getField(), (Object)outerColumn2);
        Assert.assertEquals((boolean)((ResolvedField)outer.tryResolveField(c2).get()).isLocal(), (boolean)true);
        Assert.assertEquals((int)((ResolvedField)outer.tryResolveField(c2).get()).getHierarchyFieldIndex(), (int)1);
        Assert.assertFalse((boolean)outer.tryResolveField(c3).isPresent());
        Assert.assertFalse((boolean)outer.tryResolveField(c4).isPresent());
        Assert.assertTrue((boolean)inner.tryResolveField(c1).isPresent());
        Assert.assertEquals((Object)((ResolvedField)inner.tryResolveField(c1).get()).getField(), (Object)outerColumn1);
        Assert.assertEquals((boolean)((ResolvedField)inner.tryResolveField(c1).get()).isLocal(), (boolean)false);
        Assert.assertEquals((int)((ResolvedField)inner.tryResolveField(c1).get()).getHierarchyFieldIndex(), (int)2);
        Assert.assertEquals((int)((ResolvedField)inner.tryResolveField(c1).get()).getRelationFieldIndex(), (int)0);
        Assert.assertTrue((boolean)inner.tryResolveField(c2).isPresent());
        Assert.assertEquals((Object)((ResolvedField)inner.tryResolveField(c2).get()).getField(), (Object)innerColumn2);
        Assert.assertEquals((boolean)((ResolvedField)inner.tryResolveField(c2).get()).isLocal(), (boolean)true);
        Assert.assertEquals((int)((ResolvedField)inner.tryResolveField(c2).get()).getHierarchyFieldIndex(), (int)0);
        Assert.assertTrue((boolean)inner.tryResolveField(c2).isPresent());
        Assert.assertEquals((Object)((ResolvedField)inner.tryResolveField(c3).get()).getField(), (Object)innerColumn3);
        Assert.assertEquals((boolean)((ResolvedField)inner.tryResolveField(c3).get()).isLocal(), (boolean)true);
        Assert.assertEquals((int)((ResolvedField)inner.tryResolveField(c3).get()).getHierarchyFieldIndex(), (int)1);
        Assert.assertFalse((boolean)inner.tryResolveField(c4).isPresent());
        Assert.assertEquals((Object)inner.getOuterQueryParent(), Optional.of(outer));
    }

    private static Expression name(String first, String ... parts) {
        return DereferenceExpression.from((QualifiedName)QualifiedName.of((String)first, (String[])parts));
    }
}

