/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=10)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class InCodeGeneratorBenchmark {
    @Param(value={"1", "5", "10", "25", "50", "75", "100", "150", "200", "250", "300", "350", "400", "450", "500", "750", "1000", "10000"})
    private int inListCount = 1;
    @Param(value={"bigint", "double", "varchar"})
    private String type = "bigint";
    private Page inputPage;
    private PageProcessor processor;
    private Type prestoType;

    @Setup
    public void setup() {
        int i;
        Random random = new Random();
        RowExpression[] arguments = new RowExpression[1 + this.inListCount];
        switch (this.type) {
            case "bigint": {
                this.prestoType = BigintType.BIGINT;
                for (i = 1; i <= this.inListCount; ++i) {
                    arguments[i] = Expressions.constant((Object)random.nextInt(), (Type)BigintType.BIGINT);
                }
                break;
            }
            case "double": {
                this.prestoType = DoubleType.DOUBLE;
                for (i = 1; i <= this.inListCount; ++i) {
                    arguments[i] = Expressions.constant((Object)random.nextDouble(), (Type)DoubleType.DOUBLE);
                }
                break;
            }
            case "varchar": {
                this.prestoType = VarcharType.VARCHAR;
                for (i = 1; i <= this.inListCount; ++i) {
                    arguments[i] = Expressions.constant((Object)Slices.utf8Slice((String)Long.toString(random.nextLong())), (Type)VarcharType.VARCHAR);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        arguments[0] = Expressions.field((int)0, (Type)this.prestoType);
        InputReferenceExpression project = Expressions.field((int)0, (Type)this.prestoType);
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.prestoType));
        block23: for (i = 0; i < 10000; ++i) {
            pageBuilder.declarePosition();
            switch (this.type) {
                case "bigint": {
                    BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), (long)random.nextInt());
                    continue block23;
                }
                case "double": {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), random.nextDouble());
                    continue block23;
                }
                case "varchar": {
                    VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(0), Slices.utf8Slice((String)Long.toString(random.nextLong())));
                }
            }
        }
        this.inputPage = pageBuilder.build();
        SpecialFormExpression filter = Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.IN, (Type)BooleanType.BOOLEAN, (RowExpression[])arguments);
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        this.processor = (PageProcessor)new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0)).compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.of(filter), (List)ImmutableList.of((Object)project)).get();
    }

    @Benchmark
    public List<Optional<Page>> benchmark() {
        return ImmutableList.copyOf((Iterator)this.processor.process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), this.inputPage));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + InCodeGeneratorBenchmark.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

