/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.relation.Predicate;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.gen.RowExpressionPredicateCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowExpressionPredicateCompiler {
    private Metadata metadata = MetadataManager.createTestMetadataManager();
    private FunctionResolution functionResolution = new FunctionResolution(this.metadata.getFunctionAndTypeManager());

    @Test
    public void test() {
        InputReferenceExpression a = new InputReferenceExpression(0, (Type)BigintType.BIGINT);
        InputReferenceExpression b = new InputReferenceExpression(1, (Type)BigintType.BIGINT);
        Block aBlock = TestRowExpressionPredicateCompiler.createLongBlock(5L, 5L, 5L, 5L, 5L);
        Block bBlock = TestRowExpressionPredicateCompiler.createLongBlock(1L, 3L, 5L, 7L, 0L);
        CallExpression sum = Expressions.call((String)"<", (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.GREATER_THAN_OR_EQUAL, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)"b - a", (FunctionHandle)this.functionResolution.arithmeticFunction(OperatorType.SUBTRACT, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{b, a}), Expressions.constant((Object)0L, (Type)BigintType.BIGINT)});
        RowExpressionPredicateCompiler compiler = new RowExpressionPredicateCompiler(this.metadata, 10000);
        Predicate compiledSum = (Predicate)compiler.compilePredicate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), TestingConnectorSession.SESSION.getSessionFunctions(), (RowExpression)sum).get();
        Assert.assertEquals(Arrays.asList(1, 0), (Collection)Ints.asList((int[])compiledSum.getInputChannels()));
        Page page = new Page(new Block[]{bBlock, aBlock});
        Assert.assertFalse((boolean)compiledSum.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 0));
        Assert.assertFalse((boolean)compiledSum.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 1));
        Assert.assertTrue((boolean)compiledSum.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 2));
        Assert.assertTrue((boolean)compiledSum.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 3));
        Assert.assertFalse((boolean)compiledSum.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 4));
        CallExpression timesTwo = Expressions.call((String)"=", (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.LESS_THAN, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)"b * 2", (FunctionHandle)this.functionResolution.arithmeticFunction(OperatorType.MULTIPLY, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{b, Expressions.constant((Object)2L, (Type)BigintType.BIGINT)}), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        Predicate compiledTimesTwo = (Predicate)compiler.compilePredicate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), TestingConnectorSession.SESSION.getSessionFunctions(), (RowExpression)timesTwo).get();
        Assert.assertEquals(Arrays.asList(1), (Collection)Ints.asList((int[])compiledTimesTwo.getInputChannels()));
        page = new Page(new Block[]{bBlock});
        Assert.assertTrue((boolean)compiledTimesTwo.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 0));
        Assert.assertTrue((boolean)compiledTimesTwo.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 1));
        Assert.assertFalse((boolean)compiledTimesTwo.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 2));
        Assert.assertFalse((boolean)compiledTimesTwo.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 3));
        Assert.assertTrue((boolean)compiledTimesTwo.evaluate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), page, 4));
    }

    @Test
    public void testCache() {
        CallExpression predicate = Expressions.call((String)"=", (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.LESS_THAN, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((String)"a * 2", (FunctionHandle)this.functionResolution.arithmeticFunction(OperatorType.MULTIPLY, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{new InputReferenceExpression(1, (Type)BigintType.BIGINT), Expressions.constant((Object)2L, (Type)BigintType.BIGINT)}), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        RowExpressionPredicateCompiler compiler = new RowExpressionPredicateCompiler(this.metadata, 10000);
        Assert.assertSame((Object)compiler.compilePredicate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), TestingConnectorSession.SESSION.getSessionFunctions(), (RowExpression)predicate), (Object)compiler.compilePredicate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), TestingConnectorSession.SESSION.getSessionFunctions(), (RowExpression)predicate));
        RowExpressionPredicateCompiler noCacheCompiler = new RowExpressionPredicateCompiler(this.metadata, 0);
        Assert.assertNotSame((Object)noCacheCompiler.compilePredicate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), TestingConnectorSession.SESSION.getSessionFunctions(), (RowExpression)predicate), (Object)noCacheCompiler.compilePredicate(TestingConnectorSession.SESSION.getSqlFunctionProperties(), TestingConnectorSession.SESSION.getSessionFunctions(), (RowExpression)predicate));
    }

    private static Block createLongBlock(long ... values) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(values.length);
        for (long value : values) {
            BigintType.BIGINT.writeLong(builder, value);
        }
        return builder.build();
    }
}

