/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.HyperLogLogType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.type.ColorType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestExpressionDomainTranslator {
    private static final String C_BIGINT = "c_bigint";
    private static final String C_DOUBLE = "c_double";
    private static final String C_VARCHAR = "c_varchar";
    private static final String C_BOOLEAN = "c_boolean";
    private static final String C_BIGINT_1 = "c_bigint_1";
    private static final String C_DOUBLE_1 = "c_double_1";
    private static final String C_VARCHAR_1 = "c_varchar_1";
    private static final String C_TIMESTAMP = "c_timestamp";
    private static final String C_DATE = "c_date";
    private static final String C_COLOR = "c_color";
    private static final String C_HYPER_LOG_LOG = "c_hyper_log_log";
    private static final String C_VARBINARY = "c_varbinary";
    private static final String C_DECIMAL_26_5 = "c_decimal_26_5";
    private static final String C_DECIMAL_23_4 = "c_decimal_23_4";
    private static final String C_INTEGER = "c_integer";
    private static final String C_CHAR = "c_char";
    private static final String C_DECIMAL_21_3 = "c_decimal_21_3";
    private static final String C_DECIMAL_12_2 = "c_decimal_12_2";
    private static final String C_DECIMAL_6_1 = "c_decimal_6_1";
    private static final String C_DECIMAL_3_0 = "c_decimal_3_0";
    private static final String C_DECIMAL_2_0 = "c_decimal_2_0";
    private static final String C_SMALLINT = "c_smallint";
    private static final String C_TINYINT = "c_tinyint";
    private static final String C_REAL = "c_real";
    private static final TypeProvider TYPES = TypeProvider.viewOf((Map)ImmutableMap.builder().put((Object)"c_bigint", (Object)BigintType.BIGINT).put((Object)"c_double", (Object)DoubleType.DOUBLE).put((Object)"c_varchar", (Object)VarcharType.VARCHAR).put((Object)"c_boolean", (Object)BooleanType.BOOLEAN).put((Object)"c_bigint_1", (Object)BigintType.BIGINT).put((Object)"c_double_1", (Object)DoubleType.DOUBLE).put((Object)"c_varchar_1", (Object)VarcharType.VARCHAR).put((Object)"c_timestamp", (Object)TimestampType.TIMESTAMP).put((Object)"c_date", (Object)DateType.DATE).put((Object)"c_color", (Object)ColorType.COLOR).put((Object)"c_hyper_log_log", (Object)HyperLogLogType.HYPER_LOG_LOG).put((Object)"c_varbinary", (Object)VarbinaryType.VARBINARY).put((Object)"c_decimal_26_5", (Object)DecimalType.createDecimalType((int)26, (int)5)).put((Object)"c_decimal_23_4", (Object)DecimalType.createDecimalType((int)23, (int)4)).put((Object)"c_integer", (Object)IntegerType.INTEGER).put((Object)"c_char", (Object)CharType.createCharType((long)10L)).put((Object)"c_decimal_21_3", (Object)DecimalType.createDecimalType((int)21, (int)3)).put((Object)"c_decimal_12_2", (Object)DecimalType.createDecimalType((int)12, (int)2)).put((Object)"c_decimal_6_1", (Object)DecimalType.createDecimalType((int)6, (int)1)).put((Object)"c_decimal_3_0", (Object)DecimalType.createDecimalType((int)3, (int)0)).put((Object)"c_decimal_2_0", (Object)DecimalType.createDecimalType((int)2, (int)0)).put((Object)"c_smallint", (Object)SmallintType.SMALLINT).put((Object)"c_tinyint", (Object)TinyintType.TINYINT).put((Object)"c_real", (Object)RealType.REAL).build());
    private static final long TIMESTAMP_VALUE = new DateTime(2013, 3, 30, 1, 5, 0, 0, DateTimeZone.UTC).getMillis();
    private static final long DATE_VALUE = TimeUnit.MILLISECONDS.toDays(new DateTime(2001, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC).getMillis());
    private static final long COLOR_VALUE_1 = 1L;
    private static final long COLOR_VALUE_2 = 2L;
    private Metadata metadata;
    private LiteralEncoder literalEncoder;
    private ExpressionDomainTranslator domainTranslator;

    @BeforeClass
    public void setup() {
        this.metadata = MetadataManager.createTestMetadataManager();
        this.literalEncoder = new LiteralEncoder(this.metadata.getBlockEncodingSerde());
        this.domainTranslator = new ExpressionDomainTranslator(this.literalEncoder);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.metadata = null;
        this.literalEncoder = null;
        this.domainTranslator = null;
    }

    @Test
    public void testNoneRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.none();
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<String>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testAllRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.all();
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<String>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true)).put((Object)C_BIGINT_1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)C_DOUBLE_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)1.1), (Range[])new Range[]{Range.equal((Type)DoubleType.DOUBLE, (Object)2.0), Range.range((Type)DoubleType.DOUBLE, (Object)3.0, (boolean)false, (Object)3.5, (boolean)true)}), (boolean)true)).put((Object)C_VARCHAR_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-01-01")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-10-01"))}), (boolean)false)).put((Object)C_TIMESTAMP, (Object)Domain.singleValue((Type)TimestampType.TIMESTAMP, (Object)TIMESTAMP_VALUE)).put((Object)C_DATE, (Object)Domain.singleValue((Type)DateType.DATE, (Object)DATE_VALUE)).put((Object)C_COLOR, (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)1L)).put((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)).build());
        this.assertPredicateTranslates(this.toPredicate((TupleDomain<String>)tupleDomain), (TupleDomain<String>)tupleDomain);
    }

    @Test
    public void testInOptimization() {
        Domain testDomain = Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)})), (boolean)false);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(4L)), TestExpressionDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)true, (Object)7L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)true)}), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestExpressionDomainTranslator.between(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L), (Expression)TestExpressionDomainTranslator.bigintLiteral(3L)), TestExpressionDomainTranslator.between(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(5L), (Expression)TestExpressionDomainTranslator.bigintLiteral(7L)), TestExpressionDomainTranslator.between(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(9L), (Expression)TestExpressionDomainTranslator.bigintLiteral(11L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)true, (Object)9L, (boolean)true), (Range[])new Range[0])), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(4L)), TestExpressionDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), TestExpressionDomainTranslator.between(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(7L), (Expression)TestExpressionDomainTranslator.bigintLiteral(9L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)false, (Object)9L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)11L, (boolean)false, (Object)13L, (boolean)false)})), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(4L)), TestExpressionDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(7L)), TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(9L))}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(11L)), TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(13L))})}));
    }

    @Test
    public void testToPredicateNone() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.none((Type)BooleanType.BOOLEAN)).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testToPredicateAllIgnored() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.all((Type)BooleanType.BOOLEAN)).build());
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<String>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).build()));
    }

    @Test
    public void testToPredicate() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.isNotNull(C_BIGINT));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.isNull(C_BIGINT));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.none((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)BooleanLiteral.FALSE_LITERAL);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.all((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)BooleanLiteral.TRUE_LITERAL);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(0L)), TestExpressionDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L))}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.isNull(C_BIGINT)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_COLOR, (Expression)TestExpressionDomainTranslator.colorLiteral(1L)), TestExpressionDomainTranslator.isNull(C_COLOR)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.equal(C_COLOR, (Expression)TestExpressionDomainTranslator.colorLiteral(1L))), TestExpressionDomainTranslator.isNull(C_COLOR)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.isNull(C_HYPER_LOG_LOG));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)tupleDomain), (Object)TestExpressionDomainTranslator.isNotNull(C_HYPER_LOG_LOG));
    }

    @Test
    public void testFromUnknownPredicate() {
        this.assertUnsupportedPredicate(TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.not(TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)));
    }

    @Test
    public void testFromAndPredicate() {
        Expression originalPredicate = ExpressionUtils.and((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(5L)), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)}));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false))));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(5L)), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)})})));
        originalPredicate = TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(5L)), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
    }

    @Test
    public void testFromOrPredicate() {
        Expression originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(5L)), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertUnsupportedPredicate(ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_DOUBLE, (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)})}));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestExpressionDomainTranslator.doubleLiteral(1.0)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), TestExpressionDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false), (Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)1.0), (Range[])new Range[0]), (boolean)false))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.randPredicate(C_BIGINT, (Type)BigintType.BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), TestExpressionDomainTranslator.randPredicate(C_BIGINT, (Type)BigintType.BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        originalPredicate = TestExpressionDomainTranslator.not(ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(5L)), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)})}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(5L)), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalPredicate = TestExpressionDomainTranslator.not(ExpressionUtils.or((Expression[])new Expression[]{TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(5L)), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)}));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromNotPredicate() {
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L)), TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)})));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.not(TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)BooleanLiteral.TRUE_LITERAL));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false))));
    }

    @Test
    public void testFromUnprocessableComparison() {
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT)));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT), TestExpressionDomainTranslator.unprocessableExpression2(C_BIGINT))));
    }

    @Test
    public void testFromBasicComparisons() {
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.notEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.isDistinctFrom(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.equal(C_COLOR, (Expression)TestExpressionDomainTranslator.colorLiteral(1L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestExpressionDomainTranslator.colorLiteral(1L), (Object)TestExpressionDomainTranslator.colorLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.isDistinctFrom(C_COLOR, (Expression)TestExpressionDomainTranslator.colorLiteral(1L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.lessThan(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.equal(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.notEqual(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.isDistinctFrom(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.equal(C_COLOR, (Expression)TestExpressionDomainTranslator.colorLiteral(1L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestExpressionDomainTranslator.colorLiteral(1L), (Object)TestExpressionDomainTranslator.colorLiteral(2L)))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.isDistinctFrom(C_COLOR, (Expression)TestExpressionDomainTranslator.colorLiteral(1L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
    }

    @Test
    public void testFromFlippedBasicComparisons() {
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Expression)new SymbolReference(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Expression)new SymbolReference(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Expression)new SymbolReference(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Expression)new SymbolReference(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Expression)new SymbolReference(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, (Expression)TestExpressionDomainTranslator.colorLiteral(1L), (Expression)new SymbolReference(C_COLOR)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Expression)new SymbolReference(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestExpressionDomainTranslator.colorLiteral(1L), (Expression)new SymbolReference(C_COLOR)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Expression)new SymbolReference(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)TestExpressionDomainTranslator.colorLiteral(1L), (Expression)new SymbolReference(C_COLOR)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT), (Expression)new SymbolReference(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
    }

    @Test
    public void testFromBasicComparisonsWithNulls() {
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.greaterThan(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThan(C_VARCHAR, TestExpressionDomainTranslator.nullLiteral((Type)VarcharType.VARCHAR)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.none((Type)VarcharType.VARCHAR), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.lessThan(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.lessThanOrEqual(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.equal(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.equal(C_COLOR, TestExpressionDomainTranslator.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.notEqual(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.notEqual(C_COLOR, TestExpressionDomainTranslator.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.isDistinctFrom(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.isDistinctFrom(C_COLOR, TestExpressionDomainTranslator.nullLiteral((Type)ColorType.COLOR)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.notNull((Type)ColorType.COLOR))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThan(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.lessThan(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.lessThanOrEqual(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.equal(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.equal(C_COLOR, TestExpressionDomainTranslator.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.notEqual(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.notEqual(C_COLOR, TestExpressionDomainTranslator.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.isDistinctFrom(C_BIGINT, TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.isDistinctFrom(C_COLOR, TestExpressionDomainTranslator.nullLiteral((Type)ColorType.COLOR))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.onlyNull((Type)ColorType.COLOR))));
    }

    @Test
    void testNonImplictCastOnSymbolSide() {
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.equal((Expression)new Cast((Expression)new SymbolReference(C_TIMESTAMP), DateType.DATE.toString()), this.toExpression(DATE_VALUE, (Type)DateType.DATE)));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.equal((Expression)new Cast((Expression)new SymbolReference(C_DECIMAL_12_2), BigintType.BIGINT.toString()), (Expression)TestExpressionDomainTranslator.bigintLiteral(135L)));
    }

    @Test
    void testNoSaturatedFloorCastFromUnsupportedApproximateDomain() {
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.equal((Expression)new Cast((Expression)new SymbolReference(C_DECIMAL_12_2), DoubleType.DOUBLE.toString()), this.toExpression(12345.56, (Type)DoubleType.DOUBLE)));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.equal((Expression)new Cast((Expression)new SymbolReference(C_BIGINT), DoubleType.DOUBLE.toString()), this.toExpression(12345.56, (Type)DoubleType.DOUBLE)));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.equal((Expression)new Cast((Expression)new SymbolReference(C_BIGINT), RealType.REAL.toString()), this.toExpression(TestExpressionDomainTranslator.realValue(12345.56f), (Type)RealType.REAL)));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.equal((Expression)new Cast((Expression)new SymbolReference(C_INTEGER), RealType.REAL.toString()), this.toExpression(TestExpressionDomainTranslator.realValue(12345.56f), (Type)RealType.REAL)));
    }

    @Test
    public void testFromComparisonsWithCoercions() {
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThan(C_DOUBLE, TestExpressionDomainTranslator.cast((Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Type)DoubleType.DOUBLE)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)2.0), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThan(C_VARCHAR, TestExpressionDomainTranslator.stringLiteral("test", (Type)VarcharType.VARCHAR)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThan(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThan(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.lessThan(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.lessThan(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.lessThanOrEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.lessThanOrEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.equal(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.equal(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.none((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.notEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.notEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.notNull((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.isDistinctFrom(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)true))));
        this.assertPredicateIsAlwaysTrue((Expression)TestExpressionDomainTranslator.isDistinctFrom(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1)));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThan(C_DOUBLE, TestExpressionDomainTranslator.cast((Expression)TestExpressionDomainTranslator.bigintLiteral(2L), (Type)DoubleType.DOUBLE))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)2.0), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThan(C_VARCHAR, TestExpressionDomainTranslator.stringLiteral("test", (Type)VarcharType.VARCHAR))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThan(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThan(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.lessThan(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.lessThan(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.lessThanOrEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.lessThanOrEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.equal(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.equal(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.notNull((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.notEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.notEqual(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.none((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.isDistinctFrom(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.0))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.isDistinctFrom(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1))));
    }

    @Test
    public void testFromUnprocessableInPredicate() {
        this.assertUnsupportedPredicate((Expression)new InPredicate(TestExpressionDomainTranslator.unprocessableExpression1(C_BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL))));
        this.assertUnsupportedPredicate((Expression)new InPredicate((Expression)new SymbolReference(C_BOOLEAN), (Expression)new InListExpression((List)ImmutableList.of((Object)TestExpressionDomainTranslator.unprocessableExpression1(C_BOOLEAN)))));
        this.assertUnsupportedPredicate((Expression)new InPredicate((Expression)new SymbolReference(C_BOOLEAN), (Expression)new InListExpression((List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)TestExpressionDomainTranslator.unprocessableExpression1(C_BOOLEAN)))));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.not((Expression)new InPredicate((Expression)new SymbolReference(C_BOOLEAN), (Expression)new InListExpression((List)ImmutableList.of((Object)TestExpressionDomainTranslator.unprocessableExpression1(C_BOOLEAN))))));
    }

    @Test
    public void testFromInPredicate() {
        this.assertPredicateTranslates((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestExpressionDomainTranslator.colorLiteral(1L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)1L))));
        this.assertPredicateTranslates((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestExpressionDomainTranslator.colorLiteral(1L), (Object)TestExpressionDomainTranslator.colorLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)false), Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestExpressionDomainTranslator.colorLiteral(1L), (Object)TestExpressionDomainTranslator.colorLiteral(2L)))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false))));
    }

    @Test
    public void testInPredicateWithNull() {
        this.assertPredicateTranslates((Expression)this.in(C_BIGINT, Arrays.asList(1L, 2L, null)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)this.in(C_BIGINT, Arrays.asList(1L, 2L, null))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(C_BIGINT, Arrays.asList(new Long[]{null})));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)this.in(C_BIGINT, Arrays.asList(new Long[]{null}))));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.isNull((Expression)this.in(C_BIGINT, Arrays.asList(1L, 2L, null))));
        this.assertUnsupportedPredicate(TestExpressionDomainTranslator.isNotNull((Expression)this.in(C_BIGINT, Arrays.asList(1L, 2L, null))));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.isNull((Expression)this.in(C_BIGINT, Arrays.asList(new Long[]{null}))));
        this.assertUnsupportedPredicate(TestExpressionDomainTranslator.isNotNull((Expression)this.in(C_BIGINT, Arrays.asList(new Long[]{null}))));
    }

    @Test
    public void testInPredicateWithCasts() {
        this.assertPredicateTranslates((Expression)new InPredicate((Expression)new SymbolReference(C_BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)TestExpressionDomainTranslator.cast(this.toExpression(1L, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT)))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertPredicateTranslates((Expression)new InPredicate(TestExpressionDomainTranslator.cast(C_SMALLINT, (Type)BigintType.BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)this.toExpression(1L, (Type)BigintType.BIGINT)))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_SMALLINT, (Object)Domain.singleValue((Type)SmallintType.SMALLINT, (Object)1L))));
        this.assertUnsupportedPredicate((Expression)new InPredicate(TestExpressionDomainTranslator.cast(C_BIGINT, (Type)IntegerType.INTEGER), (Expression)new InListExpression((List)ImmutableList.of((Object)this.toExpression(1L, (Type)IntegerType.INTEGER)))));
    }

    @Test
    public void testFromInPredicateWithCastsAndNulls() {
        this.assertPredicateIsAlwaysFalse((Expression)new InPredicate((Expression)new SymbolReference(C_BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)TestExpressionDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT)))));
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.not((Expression)new InPredicate(TestExpressionDomainTranslator.cast(C_SMALLINT, (Type)BigintType.BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)this.toExpression(null, (Type)BigintType.BIGINT))))));
        this.assertPredicateTranslates((Expression)new InPredicate((Expression)new SymbolReference(C_BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)TestExpressionDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT), (Object)this.toExpression(1L, (Type)BigintType.BIGINT)))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)new InPredicate((Expression)new SymbolReference(C_BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)TestExpressionDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT), (Object)this.toExpression(1L, (Type)SmallintType.SMALLINT))))));
    }

    @Test
    public void testFromBetweenPredicate() {
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.between(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L), (Expression)TestExpressionDomainTranslator.bigintLiteral(2L)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.between(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), TestExpressionDomainTranslator.cast((Expression)TestExpressionDomainTranslator.bigintLiteral(1L), (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.between(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L), TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.between(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L), (Expression)TestExpressionDomainTranslator.bigintLiteral(2L))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.between(TestExpressionDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), TestExpressionDomainTranslator.cast((Expression)TestExpressionDomainTranslator.bigintLiteral(1L), (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(2.1))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.between(C_BIGINT, (Expression)TestExpressionDomainTranslator.bigintLiteral(1L), TestExpressionDomainTranslator.nullLiteral((Type)BigintType.BIGINT))), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromIsNullPredicate() {
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.isNull(C_BIGINT), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.isNull(C_HYPER_LOG_LOG), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.isNull(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.isNull(C_HYPER_LOG_LOG)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
    }

    @Test
    public void testFromIsNotNullPredicate() {
        this.assertPredicateTranslates(TestExpressionDomainTranslator.isNotNull(C_BIGINT), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates(TestExpressionDomainTranslator.isNotNull(C_HYPER_LOG_LOG), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not(TestExpressionDomainTranslator.isNotNull(C_BIGINT)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.not(TestExpressionDomainTranslator.isNotNull(C_HYPER_LOG_LOG)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
    }

    @Test
    public void testFromBooleanLiteralPredicate() {
        this.assertPredicateIsAlwaysTrue((Expression)BooleanLiteral.TRUE_LITERAL);
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)BooleanLiteral.TRUE_LITERAL));
        this.assertPredicateIsAlwaysFalse((Expression)BooleanLiteral.FALSE_LITERAL);
        this.assertPredicateIsAlwaysTrue((Expression)TestExpressionDomainTranslator.not((Expression)BooleanLiteral.FALSE_LITERAL));
    }

    @Test
    public void testFromNullLiteralPredicate() {
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.nullLiteral());
        this.assertPredicateIsAlwaysFalse((Expression)TestExpressionDomainTranslator.not((Expression)TestExpressionDomainTranslator.nullLiteral()));
    }

    @Test
    public void testExpressionConstantFolding() {
        ComparisonExpression originalExpression = TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(C_VARBINARY), (Expression)TestExpressionDomainTranslator.function("from_hex", new Expression[]{TestExpressionDomainTranslator.stringLiteral("123456")}));
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Slice value = Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)"123456"));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARBINARY, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarbinaryType.VARBINARY, (Object)value), (Range[])new Range[0]), (boolean)false))));
        Expression expression = this.toPredicate((TupleDomain<String>)result.getTupleDomain());
        Assert.assertEquals((Object)expression, (Object)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(C_VARBINARY), this.varbinaryLiteral(value)));
    }

    @Test
    public void testConjunctExpression() {
        Expression expression = ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(C_DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(0.0)), TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(C_BIGINT), (Expression)TestExpressionDomainTranslator.bigintLiteral(0L))});
        this.assertPredicateTranslates(expression, (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)false), (Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)false))));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<String>)this.fromPredicate(expression).getTupleDomain()), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(C_BIGINT), (Expression)TestExpressionDomainTranslator.bigintLiteral(0L)), TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(C_DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(0.0))}));
    }

    @Test
    void testMultipleCoercionsOnSymbolSide() {
        this.assertPredicateTranslates((Expression)TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestExpressionDomainTranslator.cast(TestExpressionDomainTranslator.cast(C_SMALLINT, (Type)RealType.REAL), (Type)DoubleType.DOUBLE), (Expression)TestExpressionDomainTranslator.doubleLiteral(3.7)), (TupleDomain<String>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_SMALLINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)SmallintType.SMALLINT, (Object)3L), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testNumericTypeTranslation() {
        this.testNumericTypeTranslationChain(new NumericValues(C_DECIMAL_26_5, TestExpressionDomainTranslator.longDecimal("-999999999999999999999.99999"), TestExpressionDomainTranslator.longDecimal("-22.00000"), TestExpressionDomainTranslator.longDecimal("-44.55569"), TestExpressionDomainTranslator.longDecimal("23.00000"), TestExpressionDomainTranslator.longDecimal("44.55567"), TestExpressionDomainTranslator.longDecimal("999999999999999999999.99999")), new NumericValues(C_DECIMAL_23_4, TestExpressionDomainTranslator.longDecimal("-9999999999999999999.9999"), TestExpressionDomainTranslator.longDecimal("-22.0000"), TestExpressionDomainTranslator.longDecimal("-44.5557"), TestExpressionDomainTranslator.longDecimal("23.0000"), TestExpressionDomainTranslator.longDecimal("44.5556"), TestExpressionDomainTranslator.longDecimal("9999999999999999999.9999")), new NumericValues(C_BIGINT, Long.MIN_VALUE, -22L, -45L, 23L, 44L, Long.MAX_VALUE), new NumericValues(C_DECIMAL_21_3, TestExpressionDomainTranslator.longDecimal("-999999999999999999.999"), TestExpressionDomainTranslator.longDecimal("-22.000"), TestExpressionDomainTranslator.longDecimal("-44.556"), TestExpressionDomainTranslator.longDecimal("23.000"), TestExpressionDomainTranslator.longDecimal("44.555"), TestExpressionDomainTranslator.longDecimal("999999999999999999.999")), new NumericValues(C_DECIMAL_12_2, TestExpressionDomainTranslator.shortDecimal("-9999999999.99"), TestExpressionDomainTranslator.shortDecimal("-22.00"), TestExpressionDomainTranslator.shortDecimal("-44.56"), TestExpressionDomainTranslator.shortDecimal("23.00"), TestExpressionDomainTranslator.shortDecimal("44.55"), TestExpressionDomainTranslator.shortDecimal("9999999999.99")), new NumericValues(C_INTEGER, Integer.MIN_VALUE, -22L, -45L, 23L, 44L, Integer.MAX_VALUE), new NumericValues(C_DECIMAL_6_1, TestExpressionDomainTranslator.shortDecimal("-99999.9"), TestExpressionDomainTranslator.shortDecimal("-22.0"), TestExpressionDomainTranslator.shortDecimal("-44.6"), TestExpressionDomainTranslator.shortDecimal("23.0"), TestExpressionDomainTranslator.shortDecimal("44.5"), TestExpressionDomainTranslator.shortDecimal("99999.9")), new NumericValues(C_SMALLINT, -32768L, -22L, -45L, 23L, 44L, 32767L), new NumericValues(C_DECIMAL_3_0, TestExpressionDomainTranslator.shortDecimal("-999"), TestExpressionDomainTranslator.shortDecimal("-22"), TestExpressionDomainTranslator.shortDecimal("-45"), TestExpressionDomainTranslator.shortDecimal("23"), TestExpressionDomainTranslator.shortDecimal("44"), TestExpressionDomainTranslator.shortDecimal("999")), new NumericValues(C_TINYINT, -128L, -22L, -45L, 23L, 44L, 127L), new NumericValues(C_DECIMAL_2_0, TestExpressionDomainTranslator.shortDecimal("-99"), TestExpressionDomainTranslator.shortDecimal("-22"), TestExpressionDomainTranslator.shortDecimal("-45"), TestExpressionDomainTranslator.shortDecimal("23"), TestExpressionDomainTranslator.shortDecimal("44"), TestExpressionDomainTranslator.shortDecimal("99")));
        this.testNumericTypeTranslationChain(new NumericValues(C_DOUBLE, -1.7976931348623157E308, -22.0, -44.5556836, 23.0, 44.5556789, Double.MAX_VALUE), new NumericValues(C_REAL, TestExpressionDomainTranslator.realValue(-3.4028235E38f), TestExpressionDomainTranslator.realValue(-22.0f), TestExpressionDomainTranslator.realValue(-44.555687f), TestExpressionDomainTranslator.realValue(23.0f), TestExpressionDomainTranslator.realValue(44.555676f), TestExpressionDomainTranslator.realValue(Float.MAX_VALUE)));
    }

    private void testNumericTypeTranslationChain(NumericValues ... translationChain) {
        for (int literalIndex = 0; literalIndex < translationChain.length; ++literalIndex) {
            for (int columnIndex = literalIndex + 1; columnIndex < translationChain.length; ++columnIndex) {
                NumericValues literal = translationChain[literalIndex];
                NumericValues column = translationChain[columnIndex];
                this.testNumericTypeTranslation(column, literal);
            }
        }
    }

    private void testNumericTypeTranslation(NumericValues columnValues, NumericValues literalValues) {
        Type columnType = columnValues.getType();
        Type literalType = literalValues.getType();
        Type superType = (Type)this.metadata.getFunctionAndTypeManager().getCommonSuperType(columnType, literalType).orElseThrow(() -> new IllegalArgumentException("incompatible types in test (" + columnType + ", " + literalType + ")"));
        Expression max = this.toExpression(literalValues.getMax(), literalType);
        Expression min = this.toExpression(literalValues.getMin(), literalType);
        Expression integerPositive = this.toExpression(literalValues.getIntegerPositive(), literalType);
        Expression integerNegative = this.toExpression(literalValues.getIntegerNegative(), literalType);
        Expression fractionalPositive = this.toExpression(literalValues.getFractionalPositive(), literalType);
        Expression fractionalNegative = this.toExpression(literalValues.getFractionalNegative(), literalType);
        if (!literalType.equals(superType)) {
            max = TestExpressionDomainTranslator.cast(max, superType);
            min = TestExpressionDomainTranslator.cast(min, superType);
            integerPositive = TestExpressionDomainTranslator.cast(integerPositive, superType);
            integerNegative = TestExpressionDomainTranslator.cast(integerNegative, superType);
            fractionalPositive = TestExpressionDomainTranslator.cast(fractionalPositive, superType);
            fractionalNegative = TestExpressionDomainTranslator.cast(fractionalNegative, superType);
        }
        String columnName = columnValues.getColumn();
        SymbolReference columnExpression = new SymbolReference(columnName);
        if (!columnType.equals(superType)) {
            columnExpression = TestExpressionDomainTranslator.cast((Expression)columnExpression, superType);
        }
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerPositive), columnName, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerNegative), columnName, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual((Expression)columnExpression, max), columnName, Range.greaterThan((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual((Expression)columnExpression, min), columnName, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalPositive), columnName, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalNegative), columnName, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan((Expression)columnExpression, integerPositive), columnName, Range.greaterThan((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan((Expression)columnExpression, integerNegative), columnName, Range.greaterThan((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan((Expression)columnExpression, max), columnName, Range.greaterThan((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan((Expression)columnExpression, min), columnName, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan((Expression)columnExpression, fractionalPositive), columnName, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan((Expression)columnExpression, fractionalNegative), columnName, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerPositive), columnName, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerNegative), columnName, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual((Expression)columnExpression, max), columnName, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual((Expression)columnExpression, min), columnName, Range.lessThan((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalPositive), columnName, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalNegative), columnName, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan((Expression)columnExpression, integerPositive), columnName, Range.lessThan((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan((Expression)columnExpression, integerNegative), columnName, Range.lessThan((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan((Expression)columnExpression, max), columnName, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan((Expression)columnExpression, min), columnName, Range.lessThan((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan((Expression)columnExpression, fractionalPositive), columnName, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan((Expression)columnExpression, fractionalNegative), columnName, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal((Expression)columnExpression, integerPositive), columnName, Range.equal((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal((Expression)columnExpression, integerNegative), columnName, Range.equal((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal((Expression)columnExpression, max), columnName, Domain.none((Type)columnType));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal((Expression)columnExpression, min), columnName, Domain.none((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal((Expression)columnExpression, fractionalPositive), columnName, Domain.none((Type)columnType));
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal((Expression)columnExpression, fractionalNegative), columnName, Domain.none((Type)columnType));
        }
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual((Expression)columnExpression, integerPositive), columnName, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)false));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual((Expression)columnExpression, integerNegative), columnName, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)false));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual((Expression)columnExpression, max), columnName, Domain.notNull((Type)columnType));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual((Expression)columnExpression, min), columnName, Domain.notNull((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual((Expression)columnExpression, fractionalPositive), columnName, Domain.notNull((Type)columnType));
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual((Expression)columnExpression, fractionalNegative), columnName, Domain.notNull((Type)columnType));
        }
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom((Expression)columnExpression, integerPositive), columnName, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)true));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom((Expression)columnExpression, integerNegative), columnName, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)true));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom((Expression)columnExpression, max), columnName, Domain.all((Type)columnType));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom((Expression)columnExpression, min), columnName, Domain.all((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalPositive), columnName, Domain.all((Type)columnType));
            this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalNegative), columnName, Domain.all((Type)columnType));
        }
    }

    @Test
    public void testLegacyCharComparedToVarcharExpression() {
        this.metadata = MetadataManager.createTestMetadataManager((FeaturesConfig)new FeaturesConfig().setLegacyCharToVarcharCoercion(true));
        this.literalEncoder = new LiteralEncoder(this.metadata.getBlockEncodingSerde());
        this.domainTranslator = new ExpressionDomainTranslator(this.literalEncoder);
        String maxCodePoint = new String(Character.toChars(0x10FFFF));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("123456789", (Type)VarcharType.VARCHAR)), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)("123456788" + maxCodePoint))));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("1234567890", (Type)VarcharType.VARCHAR)), C_CHAR, Range.greaterThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThanOrEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("12345678901", (Type)VarcharType.VARCHAR)), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("123456789", (Type)VarcharType.VARCHAR)), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)("123456788" + maxCodePoint))));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("1234567890", (Type)VarcharType.VARCHAR)), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.greaterThan(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("12345678901", (Type)VarcharType.VARCHAR)), C_CHAR, Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("123456789", (Type)VarcharType.VARCHAR)), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)("123456788" + maxCodePoint))));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("1234567890", (Type)VarcharType.VARCHAR)), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThanOrEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("12345678901", (Type)VarcharType.VARCHAR)), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("123456789", (Type)VarcharType.VARCHAR)), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)("123456788" + maxCodePoint))));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("1234567890", (Type)VarcharType.VARCHAR)), C_CHAR, Range.lessThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.lessThan(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("12345678901", (Type)VarcharType.VARCHAR)), C_CHAR, Range.lessThanOrEqual((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("123456789", (Type)VarcharType.VARCHAR)), C_CHAR, Domain.none((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("1234567890", (Type)VarcharType.VARCHAR)), C_CHAR, Range.equal((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("12345678901", (Type)VarcharType.VARCHAR)), C_CHAR, Domain.none((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("123456789", (Type)VarcharType.VARCHAR)), C_CHAR, Domain.notNull((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("1234567890", (Type)VarcharType.VARCHAR)), C_CHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")), (Range[])new Range[]{Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890"))}), (boolean)false));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.notEqual(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("12345678901", (Type)VarcharType.VARCHAR)), C_CHAR, Domain.notNull((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("123456789", (Type)VarcharType.VARCHAR)), C_CHAR, Domain.all((Type)CharType.createCharType((long)10L)));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("1234567890", (Type)VarcharType.VARCHAR)), C_CHAR, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890")), (Range[])new Range[]{Range.greaterThan((Type)CharType.createCharType((long)10L), (Object)Slices.utf8Slice((String)"1234567890"))}), (boolean)true));
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.isDistinctFrom(TestExpressionDomainTranslator.cast(C_CHAR, (Type)VarcharType.VARCHAR), TestExpressionDomainTranslator.stringLiteral("12345678901", (Type)VarcharType.VARCHAR)), C_CHAR, Domain.all((Type)CharType.createCharType((long)10L)));
    }

    @Test
    public void testCharComparedToVarcharExpression() {
        CharType charType = CharType.createCharType((long)10L);
        this.testSimpleComparison((Expression)TestExpressionDomainTranslator.equal(C_CHAR, TestExpressionDomainTranslator.cast((Expression)TestExpressionDomainTranslator.stringLiteral("abc"), (Type)charType)), C_CHAR, Range.equal((Type)charType, (Object)Slices.utf8Slice((String)"abc")));
        charType = CharType.createCharType((long)11L);
        this.assertUnsupportedPredicate((Expression)TestExpressionDomainTranslator.equal(TestExpressionDomainTranslator.cast(C_CHAR, (Type)charType), TestExpressionDomainTranslator.cast((Expression)TestExpressionDomainTranslator.stringLiteral("abc12345678"), (Type)charType)));
    }

    private void assertPredicateIsAlwaysTrue(Expression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<String>)TupleDomain.all());
    }

    private void assertPredicateIsAlwaysFalse(Expression expression) {
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
    }

    private void assertUnsupportedPredicate(Expression expression) {
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)expression);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.all());
    }

    private void assertPredicateTranslates(Expression expression, TupleDomain<String> tupleDomain) {
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), tupleDomain);
    }

    private ExpressionDomainTranslator.ExtractionResult fromPredicate(Expression originalPredicate) {
        return ExpressionDomainTranslator.fromPredicate((Metadata)this.metadata, (Session)SessionTestUtils.TEST_SESSION, (Expression)originalPredicate, (TypeProvider)TYPES);
    }

    private Expression toPredicate(TupleDomain<String> tupleDomain) {
        return this.domainTranslator.toPredicate(tupleDomain);
    }

    private static Expression unprocessableExpression1(String symbol) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(symbol), (Expression)new SymbolReference(symbol));
    }

    private static Expression unprocessableExpression2(String symbol) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference(symbol), (Expression)new SymbolReference(symbol));
    }

    private static Expression randPredicate(String symbol, Type type) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(symbol), TestExpressionDomainTranslator.cast((Expression)new FunctionCall(QualifiedName.of((String)"rand"), (List)ImmutableList.of()), type));
    }

    private static ComparisonExpression equal(String symbol, Expression expression) {
        return TestExpressionDomainTranslator.equal((Expression)new SymbolReference(symbol), expression);
    }

    private static ComparisonExpression notEqual(String symbol, Expression expression) {
        return TestExpressionDomainTranslator.notEqual((Expression)new SymbolReference(symbol), expression);
    }

    private static ComparisonExpression greaterThan(String symbol, Expression expression) {
        return TestExpressionDomainTranslator.greaterThan((Expression)new SymbolReference(symbol), expression);
    }

    private static ComparisonExpression greaterThanOrEqual(String symbol, Expression expression) {
        return TestExpressionDomainTranslator.greaterThanOrEqual((Expression)new SymbolReference(symbol), expression);
    }

    private static ComparisonExpression lessThan(String symbol, Expression expression) {
        return TestExpressionDomainTranslator.lessThan((Expression)new SymbolReference(symbol), expression);
    }

    private static ComparisonExpression lessThanOrEqual(String symbol, Expression expression) {
        return TestExpressionDomainTranslator.lessThanOrEqual((Expression)new SymbolReference(symbol), expression);
    }

    private static ComparisonExpression isDistinctFrom(String symbol, Expression expression) {
        return TestExpressionDomainTranslator.isDistinctFrom((Expression)new SymbolReference(symbol), expression);
    }

    private static Expression isNotNull(String symbol) {
        return TestExpressionDomainTranslator.isNotNull((Expression)new SymbolReference(symbol));
    }

    private static IsNullPredicate isNull(String symbol) {
        return new IsNullPredicate((Expression)new SymbolReference(symbol));
    }

    private InPredicate in(String symbol, List<?> values) {
        return this.in((Expression)new SymbolReference(symbol), TYPES.get((Expression)new SymbolReference(symbol)), values);
    }

    private static BetweenPredicate between(String symbol, Expression min, Expression max) {
        return TestExpressionDomainTranslator.between((Expression)new SymbolReference(symbol), min, max);
    }

    private static Expression isNotNull(Expression expression) {
        return new NotExpression((Expression)new IsNullPredicate(expression));
    }

    private static IsNullPredicate isNull(Expression expression) {
        return new IsNullPredicate(expression);
    }

    private InPredicate in(Expression expression, Type expressisonType, List<?> values) {
        List<Type> types = Collections.nCopies(values.size(), expressisonType);
        List expressions = this.literalEncoder.toExpressions(values, types);
        return new InPredicate(expression, (Expression)new InListExpression(expressions));
    }

    private static BetweenPredicate between(Expression expression, Expression min, Expression max) {
        return new BetweenPredicate(expression, min, max);
    }

    private static ComparisonExpression equal(Expression left, Expression right) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, left, right);
    }

    private static ComparisonExpression notEqual(Expression left, Expression right) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, left, right);
    }

    private static ComparisonExpression greaterThan(Expression left, Expression right) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, left, right);
    }

    private static ComparisonExpression greaterThanOrEqual(Expression left, Expression right) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, left, right);
    }

    private static ComparisonExpression lessThan(Expression left, Expression expression) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, left, expression);
    }

    private static ComparisonExpression lessThanOrEqual(Expression left, Expression right) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, left, right);
    }

    private static ComparisonExpression isDistinctFrom(Expression left, Expression right) {
        return TestExpressionDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, left, right);
    }

    private static NotExpression not(Expression expression) {
        return new NotExpression(expression);
    }

    private static ComparisonExpression comparison(ComparisonExpression.Operator operator, Expression expression1, Expression expression2) {
        return new ComparisonExpression(operator, expression1, expression2);
    }

    private static Literal bigintLiteral(long value) {
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return new GenericLiteral("BIGINT", Long.toString(value));
        }
        return new LongLiteral(Long.toString(value));
    }

    private static DoubleLiteral doubleLiteral(double value) {
        return new DoubleLiteral(Double.toString(value));
    }

    private static StringLiteral stringLiteral(String value) {
        return new StringLiteral(value);
    }

    private static Expression stringLiteral(String value, Type type) {
        return TestExpressionDomainTranslator.cast((Expression)TestExpressionDomainTranslator.stringLiteral(value), type);
    }

    private static NullLiteral nullLiteral() {
        return new NullLiteral();
    }

    private static Expression nullLiteral(Type type) {
        return TestExpressionDomainTranslator.cast((Expression)new NullLiteral(), type);
    }

    private static Expression cast(String symbol, Type type) {
        return TestExpressionDomainTranslator.cast((Expression)new SymbolReference(symbol), type);
    }

    private static Expression cast(Expression expression, Type type) {
        return new Cast(expression, type.getTypeSignature().toString());
    }

    private static FunctionCall colorLiteral(long value) {
        return new FunctionCall(QualifiedName.of((String)LiteralEncoder.getMagicLiteralFunctionSignature((Type)ColorType.COLOR).getNameSuffix()), (List)ImmutableList.of((Object)TestExpressionDomainTranslator.bigintLiteral(value)));
    }

    private Expression varbinaryLiteral(Slice value) {
        return this.toExpression(value, (Type)VarbinaryType.VARBINARY);
    }

    private static FunctionCall function(String functionName, Expression ... args) {
        return new FunctionCall(QualifiedName.of((String)functionName), (List)ImmutableList.copyOf((Object[])args));
    }

    private static Long shortDecimal(String value) {
        return new BigDecimal(value).unscaledValue().longValueExact();
    }

    private static Slice longDecimal(String value) {
        return Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
    }

    private static Long realValue(float value) {
        return Float.floatToIntBits(value);
    }

    private void testSimpleComparison(Expression expression, String symbol, Range expectedDomainRange) {
        this.testSimpleComparison(expression, symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)expectedDomainRange, (Range[])new Range[0]), (boolean)false));
    }

    private void testSimpleComparison(Expression expression, String symbol, Domain domain) {
        ExpressionDomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        TupleDomain actual = result.getTupleDomain();
        TupleDomain expected = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain));
        if (!actual.equals((Object)expected)) {
            Assert.fail((String)String.format("for comparison [%s] expected %s but found %s", expression.toString(), expected.toString(TestingConnectorSession.SESSION.getSqlFunctionProperties()), actual.toString(TestingConnectorSession.SESSION.getSqlFunctionProperties())));
        }
    }

    private Expression toExpression(Object object, Type type) {
        return this.literalEncoder.toExpression(object, type);
    }

    private static class NumericValues<T> {
        private final String column;
        private final Type type;
        private final T min;
        private final T integerNegative;
        private final T fractionalNegative;
        private final T integerPositive;
        private final T fractionalPositive;
        private final T max;

        private NumericValues(String column, T min, T integerNegative, T fractionalNegative, T integerPositive, T fractionalPositive, T max) {
            this.column = Objects.requireNonNull(column, "column is null");
            this.type = Objects.requireNonNull(TYPES.get((Expression)new SymbolReference(column)), "type for column not found: " + column);
            this.min = Objects.requireNonNull(min, "min is null");
            this.integerNegative = Objects.requireNonNull(integerNegative, "integerNegative is null");
            this.fractionalNegative = Objects.requireNonNull(fractionalNegative, "fractionalNegative is null");
            this.integerPositive = Objects.requireNonNull(integerPositive, "integerPositive is null");
            this.fractionalPositive = Objects.requireNonNull(fractionalPositive, "fractionalPositive is null");
            this.max = Objects.requireNonNull(max, "max is null");
        }

        public String getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }

        public T getMin() {
            return this.min;
        }

        public T getIntegerNegative() {
            return this.integerNegative;
        }

        public T getFractionalNegative() {
            return this.fractionalNegative;
        }

        public T getIntegerPositive() {
            return this.integerPositive;
        }

        public T getFractionalPositive() {
            return this.fractionalPositive;
        }

        public T getMax() {
            return this.max;
        }

        public boolean isFractional() {
            return this.type == DoubleType.DOUBLE || this.type == RealType.REAL || this.type instanceof DecimalType && ((DecimalType)this.type).getScale() > 0;
        }
    }
}

