/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.LocalDynamicFiltersCollector;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestLocalDynamicFiltersCollector {
    @Test
    public void testCollector() {
        VariableReferenceExpression variable = new VariableReferenceExpression("variable", (Type)BigintType.BIGINT);
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector();
        Assert.assertEquals((Object)collector.getPredicate(), (Object)TupleDomain.all());
        collector.intersect(TupleDomain.all());
        Assert.assertEquals((Object)collector.getPredicate(), (Object)TupleDomain.all());
        collector.intersect(this.tupleDomain(variable, 1L, 2L));
        Assert.assertEquals((Object)collector.getPredicate(), this.tupleDomain(variable, 1L, 2L));
        collector.intersect(this.tupleDomain(variable, 2L, 3L));
        Assert.assertEquals((Object)collector.getPredicate(), this.tupleDomain(variable, 2L));
        collector.intersect(this.tupleDomain(variable, 0L));
        Assert.assertEquals((Object)collector.getPredicate(), (Object)TupleDomain.none());
    }

    private TupleDomain<VariableReferenceExpression> tupleDomain(VariableReferenceExpression variable, Long ... values) {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)variable, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.copyOf((Object[])values))));
    }
}

