/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.FragmentResultCacheContext;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLocalExecutionPlanner {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    private LocalQueryRunner runner;

    @BeforeClass
    public void setUp() {
        this.runner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);
        this.runner.createCatalog((String)this.runner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.runner});
        this.runner = null;
    }

    @Test
    public void testCompilerFailure() {
        String inner = "(" + Joiner.on((String)" + ").join(Collections.nCopies(100, "rand()")) + ")";
        String outer = Joiner.on((String)" + ").join(Collections.nCopies(100, inner));
        this.assertFails("SELECT " + outer, (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR);
    }

    private void assertFails(@Language(value="SQL") String sql, ErrorCodeSupplier supplier) {
        try {
            this.runner.execute(sql);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)supplier.toErrorCode());
        }
    }

    @Test
    public void testCreatingFragmentResultCacheContext() {
        Session session = Session.builder((Session)this.runner.getDefaultSession()).setSystemProperty("fragment_result_caching_enabled", "true").build();
        LocalExecutionPlanner.LocalExecutionPlan planWithoutIntermediateAggregation = this.getLocalExecutionPlan(session);
        Assert.assertEquals((int)planWithoutIntermediateAggregation.getDriverFactories().size(), (int)1);
        Optional contextWithoutIntermediateAggregation = ((DriverFactory)planWithoutIntermediateAggregation.getDriverFactories().get(0)).getFragmentResultCacheContext();
        Assert.assertTrue((boolean)contextWithoutIntermediateAggregation.isPresent());
        session = Session.builder((Session)this.runner.getDefaultSession()).setSystemProperty("fragment_result_caching_enabled", "true").setSystemProperty("enable_intermediate_aggregations", "true").build();
        LocalExecutionPlanner.LocalExecutionPlan planWithIntermediateAggregation = this.getLocalExecutionPlan(session);
        Assert.assertEquals((int)planWithIntermediateAggregation.getDriverFactories().size(), (int)2);
        Optional contextWithIntermediateAggregation = ((DriverFactory)planWithIntermediateAggregation.getDriverFactories().get(0)).getFragmentResultCacheContext();
        Assert.assertTrue((boolean)contextWithIntermediateAggregation.isPresent());
        Assert.assertEquals((String)((FragmentResultCacheContext)contextWithIntermediateAggregation.get()).getHashedCanonicalPlanFragment(), (String)((FragmentResultCacheContext)contextWithoutIntermediateAggregation.get()).getHashedCanonicalPlanFragment());
    }

    private LocalExecutionPlanner.LocalExecutionPlan getLocalExecutionPlan(Session session) {
        SubPlan subPlan = (SubPlan)this.runner.inTransaction(session, transactionSession -> {
            Plan plan = this.runner.createPlan(transactionSession, "SELECT avg(totalprice) FROM orders", LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, WarningCollector.NOOP);
            return this.runner.createSubPlans(transactionSession, plan, false);
        });
        Assert.assertEquals((int)subPlan.getChildren().size(), (int)1);
        PlanFragment leafFragment = ((SubPlan)subPlan.getChildren().get(0)).getFragment();
        return TaskTestUtils.createTestingPlanner().plan(TestingTaskContext.createTaskContext((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULED_EXECUTOR, (Session)session), leafFragment.getRoot(), leafFragment.getPartitioningScheme(), leafFragment.getStageExecutionDescriptor(), leafFragment.getTableScanSchedulingOrder(), (OutputBuffer)new TestingOutputBuffer(), (RemoteSourceFactory)new TestingRemoteSourceFactory(), new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty()));
    }

    private static class TestingSourceOperatorFactory
    implements SourceOperatorFactory {
        private TestingSourceOperatorFactory() {
        }

        public PlanNodeId getSourceId() {
            return new PlanNodeId("test");
        }

        public SourceOperator createOperator(DriverContext driverContext) {
            throw new UnsupportedOperationException();
        }

        public void noMoreOperators() {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestingRemoteSourceFactory
    implements RemoteSourceFactory {
        private TestingRemoteSourceFactory() {
        }

        public SourceOperatorFactory createRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types) {
            return new TestingSourceOperatorFactory();
        }

        public SourceOperatorFactory createMergeRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestingOutputBuffer
    implements OutputBuffer {
        private TestingOutputBuffer() {
        }

        public OutputBufferInfo getInfo() {
            throw new UnsupportedOperationException();
        }

        public boolean isFinished() {
            throw new UnsupportedOperationException();
        }

        public double getUtilization() {
            throw new UnsupportedOperationException();
        }

        public boolean isOverutilized() {
            throw new UnsupportedOperationException();
        }

        public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
            throw new UnsupportedOperationException();
        }

        public void setOutputBuffers(OutputBuffers newOutputBuffers) {
            throw new UnsupportedOperationException();
        }

        public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId bufferId, long token, DataSize maxSize) {
            throw new UnsupportedOperationException();
        }

        public void acknowledge(OutputBuffers.OutputBufferId bufferId, long token) {
            throw new UnsupportedOperationException();
        }

        public void abort(OutputBuffers.OutputBufferId bufferId) {
            throw new UnsupportedOperationException();
        }

        public ListenableFuture<?> isFull() {
            throw new UnsupportedOperationException();
        }

        public void enqueue(Lifespan lifespan, List<SerializedPage> pages) {
            throw new UnsupportedOperationException();
        }

        public void enqueue(Lifespan lifespan, int partition, List<SerializedPage> pages) {
            throw new UnsupportedOperationException();
        }

        public void setNoMorePages() {
            throw new UnsupportedOperationException();
        }

        public void destroy() {
            throw new UnsupportedOperationException();
        }

        public void fail() {
            throw new UnsupportedOperationException();
        }

        public void setNoMorePagesForLifespan(Lifespan lifespan) {
            throw new UnsupportedOperationException();
        }

        public void registerLifespanCompletionCallback(Consumer<Lifespan> callback) {
            throw new UnsupportedOperationException();
        }

        public boolean isFinishedForLifespan(Lifespan lifespan) {
            throw new UnsupportedOperationException();
        }

        public long getPeakMemoryUsage() {
            throw new UnsupportedOperationException();
        }
    }
}

