/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.block.LongArrayBlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.planPrinter.RowExpressionFormatter;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.type.ColorType;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowExpressionFormatter {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final RowExpressionFormatter FORMATTER = new RowExpressionFormatter(FUNCTION_AND_TYPE_MANAGER);
    private static final VariableReferenceExpression C_BIGINT = new VariableReferenceExpression("c_bigint", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression C_BIGINT_ARRAY = new VariableReferenceExpression("c_bigint_array", (Type)new ArrayType((Type)BigintType.BIGINT));

    @Test
    public void testConstants() {
        ConstantExpression constantExpression = Expressions.constantNull((Type)UnknownType.UNKNOWN);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"null");
        constantExpression = Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"BOOLEAN true");
        constantExpression = Expressions.constant((Object)1.1, (Type)DoubleType.DOUBLE);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"DOUBLE 1.1");
        constantExpression = Expressions.constant((Object)Double.NaN, (Type)DoubleType.DOUBLE);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"DOUBLE NaN");
        constantExpression = Expressions.constant((Object)Double.POSITIVE_INFINITY, (Type)DoubleType.DOUBLE);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"DOUBLE Infinity");
        constantExpression = Expressions.constant((Object)Float.floatToIntBits(1.1f), (Type)RealType.REAL);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"REAL 1.1");
        constantExpression = Expressions.constant((Object)Float.floatToIntBits(Float.NaN), (Type)RealType.REAL);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"REAL NaN");
        constantExpression = Expressions.constant((Object)Float.floatToIntBits(Float.POSITIVE_INFINITY), (Type)RealType.REAL);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"REAL Infinity");
        constantExpression = Expressions.constant((Object)Slices.utf8Slice((String)"abcde"), (Type)VarcharType.VARCHAR);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"VARCHAR abcde");
        constantExpression = Expressions.constant((Object)Slices.utf8Slice((String)"fgh"), (Type)CharType.createCharType((long)3L));
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"CHAR(3) fgh");
        constantExpression = Expressions.constant((Object)1L, (Type)TinyintType.TINYINT);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"TINYINT 1");
        constantExpression = Expressions.constant((Object)1L, (Type)SmallintType.SMALLINT);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"SMALLINT 1");
        constantExpression = Expressions.constant((Object)1L, (Type)IntegerType.INTEGER);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"INTEGER 1");
        constantExpression = Expressions.constant((Object)1L, (Type)BigintType.BIGINT);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"BIGINT 1");
        Slice value = Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)"123456"));
        constantExpression = Expressions.constant((Object)value, (Type)VarbinaryType.VARBINARY);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"VARBINARY 12 34 56");
        constantExpression = Expressions.constant((Object)256L, (Type)ColorType.COLOR);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"COLOR 256");
        constantExpression = Expressions.constant((Object)TestRowExpressionFormatter.decimal("1.2345678910"), (Type)DecimalType.createDecimalType((int)11, (int)10));
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"DECIMAL(11,10) 1.2345678910");
        constantExpression = Expressions.constant((Object)TestRowExpressionFormatter.decimal("1.281734081274028174012432412423134"), (Type)DecimalType.createDecimalType((int)34, (int)33));
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"DECIMAL(34,33) 1.281734081274028174012432412423134");
        constantExpression = Expressions.constant((Object)662727600000L, (Type)TimestampType.TIMESTAMP);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"TIMESTAMP 1991-01-01 00:00:00.000");
        constantExpression = Expressions.constant((Object)7670L, (Type)DateType.DATE);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"DATE 1991-01-01");
        constantExpression = Expressions.constant((Object)24L, (Type)IntervalDayTimeType.INTERVAL_DAY_TIME);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"INTERVAL DAY TO SECOND 0 00:00:00.024");
        constantExpression = Expressions.constant((Object)25L, (Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"INTERVAL YEAR TO MONTH 2-1");
        constantExpression = Expressions.constant((Object)new LongArrayBlockBuilder(null, 4).writeLong(1L).writeLong(2L).build(), (Type)new ArrayType((Type)BigintType.BIGINT));
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)constantExpression), (String)"[Block: position count: 2; size: 96 bytes]");
    }

    @Test
    public void testCalls() {
        CallExpression subscriptExpression;
        CallExpression callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.ADD);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) + (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.SUBTRACT);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) - (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.MULTIPLY);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) * (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.DIVIDE);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) / (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.MODULUS);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) % (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.GREATER_THAN);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) > (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.LESS_THAN);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) < (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.GREATER_THAN_OR_EQUAL);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) >= (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.LESS_THAN_OR_EQUAL);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) <= (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.EQUAL);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) = (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.NOT_EQUAL);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) <> (BIGINT 5)");
        callExpression = TestRowExpressionFormatter.createCallExpression(OperatorType.IS_DISTINCT_FROM);
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"(c_bigint) IS DISTINCT FROM (BIGINT 5)");
        CallExpression expression = TestRowExpressionFormatter.createCallExpression(OperatorType.ADD);
        callExpression = Expressions.call((String)OperatorType.NEGATION.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.NEGATION, TypeSignatureProvider.fromTypes((Type[])new Type[]{expression.getType()})), (Type)expression.getType(), (RowExpression[])new RowExpression[]{expression});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"-((c_bigint) + (BIGINT 5))");
        ArrayType arrayType = (ArrayType)C_BIGINT_ARRAY.getType();
        Type elementType = arrayType.getElementType();
        callExpression = subscriptExpression = Expressions.call((String)OperatorType.SUBSCRIPT.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.SUBSCRIPT, TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, elementType})), (Type)elementType, (List)ImmutableList.of((Object)C_BIGINT_ARRAY, (Object)Expressions.constant((Object)0L, (Type)IntegerType.INTEGER)));
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"c_bigint_array[INTEGER 0]");
        callExpression = Expressions.call((String)OperatorType.CAST.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.lookupCast(CastType.CAST, TinyintType.TINYINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature()), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.constant((Object)1L, (Type)TinyintType.TINYINT)});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"CAST(TINYINT 1 AS bigint)");
        callExpression = Expressions.call((String)OperatorType.BETWEEN.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.BETWEEN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{subscriptExpression, Expressions.constant((Object)1L, (Type)BigintType.BIGINT), Expressions.constant((Object)5L, (Type)BigintType.BIGINT)});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"c_bigint_array[INTEGER 0] BETWEEN (BIGINT 1) AND (BIGINT 5)");
        callExpression = Expressions.call((String)OperatorType.HASH_CODE.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.HASH_CODE, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.constant((Object)1L, (Type)BigintType.BIGINT)});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)callExpression), (String)"HASH_CODE(BIGINT 1)");
    }

    @Test
    public void testSpecialForm() {
        SpecialFormExpression specialFormExpression = new SpecialFormExpression(SpecialFormExpression.Form.OR, (Type)BooleanType.BOOLEAN, new RowExpression[]{TestRowExpressionFormatter.createCallExpression(OperatorType.NOT_EQUAL), TestRowExpressionFormatter.createCallExpression(OperatorType.IS_DISTINCT_FROM)});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)specialFormExpression), (String)"((c_bigint) <> (BIGINT 5)) OR ((c_bigint) IS DISTINCT FROM (BIGINT 5))");
        specialFormExpression = new SpecialFormExpression(SpecialFormExpression.Form.AND, (Type)BooleanType.BOOLEAN, new RowExpression[]{TestRowExpressionFormatter.createCallExpression(OperatorType.EQUAL), TestRowExpressionFormatter.createCallExpression(OperatorType.GREATER_THAN)});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)specialFormExpression), (String)"((c_bigint) = (BIGINT 5)) AND ((c_bigint) > (BIGINT 5))");
        specialFormExpression = new SpecialFormExpression(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{TestRowExpressionFormatter.createCallExpression(OperatorType.ADD)});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)specialFormExpression), (String)"IS_NULL((c_bigint) + (BIGINT 5))");
    }

    @Test
    public void testComplex() {
        CallExpression expression = TestRowExpressionFormatter.createCallExpression(OperatorType.ADD);
        CallExpression complexExpression = Expressions.call((String)OperatorType.SUBTRACT.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.SUBTRACT, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{C_BIGINT, expression});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)complexExpression), (String)"(c_bigint) - ((c_bigint) + (BIGINT 5))");
        CallExpression expression1 = TestRowExpressionFormatter.createCallExpression(OperatorType.ADD);
        CallExpression expression2 = Expressions.call((String)OperatorType.MULTIPLY.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.MULTIPLY, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{expression1, C_BIGINT});
        CallExpression expression3 = TestRowExpressionFormatter.createCallExpression(OperatorType.GREATER_THAN);
        complexExpression = new SpecialFormExpression(SpecialFormExpression.Form.OR, (Type)BooleanType.BOOLEAN, new RowExpression[]{expression2, expression3});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)complexExpression), (String)"(((c_bigint) + (BIGINT 5)) * (c_bigint)) OR ((c_bigint) > (BIGINT 5))");
        ArrayType arrayType = (ArrayType)C_BIGINT_ARRAY.getType();
        Type elementType = arrayType.getElementType();
        expression1 = Expressions.call((String)OperatorType.SUBSCRIPT.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.SUBSCRIPT, TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, elementType})), (Type)elementType, (List)ImmutableList.of((Object)C_BIGINT_ARRAY, (Object)Expressions.constant((Object)5L, (Type)IntegerType.INTEGER)));
        expression2 = Expressions.call((String)OperatorType.NEGATION.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.NEGATION, TypeSignatureProvider.fromTypes((Type[])new Type[]{expression1.getType()})), (Type)expression1.getType(), (RowExpression[])new RowExpression[]{expression1});
        expression3 = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{expression2.getType(), BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{expression2, Expressions.constant((Object)5L, (Type)BigintType.BIGINT)});
        Assert.assertEquals((String)TestRowExpressionFormatter.format((RowExpression)expression3), (String)"(-(c_bigint_array[INTEGER 5])) + (BIGINT 5)");
    }

    protected static Object decimal(String decimalString) {
        return Decimals.parseIncludeLeadingZerosInPrecision((String)decimalString).getObject();
    }

    private static CallExpression createCallExpression(OperatorType type) {
        return Expressions.call((String)type.name(), (FunctionHandle)FUNCTION_AND_TYPE_MANAGER.resolveOperator(type, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{C_BIGINT, Expressions.constant((Object)5L, (Type)BigintType.BIGINT)});
    }

    private static String format(RowExpression expression) {
        return FORMATTER.formatRowExpression(SessionTestUtils.TEST_SESSION.toConnectorSession(), expression);
    }
}

