/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AggregationMatcher
implements Matcher {
    private final PlanMatchPattern.GroupingSetDescriptor groupingSets;
    private final Map<Symbol, Symbol> masks;
    private final List<String> preGroupedSymbols;
    private final Optional<Symbol> groupId;
    private final AggregationNode.Step step;

    public AggregationMatcher(PlanMatchPattern.GroupingSetDescriptor groupingSets, List<String> preGroupedSymbols, Map<Symbol, Symbol> masks, Optional<Symbol> groupId, AggregationNode.Step step) {
        this.groupingSets = groupingSets;
        this.masks = masks;
        this.preGroupedSymbols = preGroupedSymbols;
        this.groupId = groupId;
        this.step = step;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof AggregationNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        AggregationNode aggregationNode = (AggregationNode)node;
        if (this.groupId.isPresent() != aggregationNode.getGroupIdVariable().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.groupingSets.getGroupingKeys(), aggregationNode.getGroupingKeys(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        if (this.groupingSets.getGroupingSetCount() != aggregationNode.getGroupingSetCount()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.groupingSets.getGlobalGroupingSets().equals(aggregationNode.getGlobalGroupingSets())) {
            return MatchResult.NO_MATCH;
        }
        List aggregationsWithMask = aggregationNode.getAggregations().entrySet().stream().filter(entry -> ((AggregationNode.Aggregation)entry.getValue()).isDistinct()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (aggregationsWithMask.size() != this.masks.keySet().size()) {
            return MatchResult.NO_MATCH;
        }
        for (VariableReferenceExpression variable : aggregationsWithMask) {
            if (this.masks.keySet().contains(new Symbol(variable.getName()))) continue;
            return MatchResult.NO_MATCH;
        }
        if (this.step != aggregationNode.getStep()) {
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.preGroupedSymbols, aggregationNode.getPreGroupedVariables(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    static boolean matches(Collection<String> expectedAliases, Collection<VariableReferenceExpression> actualVariables, SymbolAliases symbolAliases) {
        if (expectedAliases.size() != actualVariables.size()) {
            return false;
        }
        List expectedSymbolNames = (List)expectedAliases.stream().map(alias -> symbolAliases.get((String)alias).getName()).collect(ImmutableList.toImmutableList());
        Set actualVariableNames = (Set)actualVariables.stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet());
        for (String symbolName : expectedSymbolNames) {
            if (actualVariableNames.contains(symbolName)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupingSets", (Object)this.groupingSets).add("preGroupedSymbols", this.preGroupedSymbols).add("masks", this.masks).add("groudId", this.groupId).add("step", (Object)this.step).toString();
    }
}

