/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public class CorrelationMatcher
implements Matcher {
    private final List<String> correlation;

    CorrelationMatcher(List<String> correlation) {
        this.correlation = Objects.requireNonNull(correlation, "correlation is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof ApplyNode || node instanceof LateralJoinNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        List<VariableReferenceExpression> actualCorrelation = this.getCorrelation(node);
        if (this.correlation.size() != actualCorrelation.size()) {
            return MatchResult.NO_MATCH;
        }
        int i = 0;
        for (String alias : this.correlation) {
            if (symbolAliases.get(alias).equals((Object)new SymbolReference(actualCorrelation.get(i++).getName()))) continue;
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    private List<VariableReferenceExpression> getCorrelation(PlanNode node) {
        if (node instanceof ApplyNode) {
            return ((ApplyNode)node).getCorrelation();
        }
        if (node instanceof LateralJoinNode) {
            return ((LateralJoinNode)node).getCorrelation();
        }
        throw new IllegalStateException("Unexpected plan node: " + node);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("correlation", this.correlation).toString();
    }
}

