/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.RowExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class SpatialJoinMatcher
implements Matcher {
    private final SpatialJoinNode.Type type;
    private final Expression filter;
    private final Optional<String> kdbTree;

    public SpatialJoinMatcher(SpatialJoinNode.Type type, Expression filter, Optional<String> kdbTree) {
        this.type = type;
        this.filter = Objects.requireNonNull(filter, "filter can not be null");
        this.kdbTree = Objects.requireNonNull(kdbTree, "kdbTree can not be null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof SpatialJoinNode)) {
            return false;
        }
        SpatialJoinNode joinNode = (SpatialJoinNode)node;
        return joinNode.getType() == this.type;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        SpatialJoinNode joinNode = (SpatialJoinNode)node;
        if (OriginalExpressionUtils.isExpression((RowExpression)joinNode.getFilter()) ? (Boolean)new ExpressionVerifier(symbolAliases).process((Node)OriginalExpressionUtils.castToExpression((RowExpression)joinNode.getFilter()), this.filter) == false : (Boolean)new RowExpressionVerifier(symbolAliases, metadata, session).process((Node)this.filter, joinNode.getFilter()) == false) {
            return MatchResult.NO_MATCH;
        }
        if (!joinNode.getKdbTree().equals(this.kdbTree)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).toString();
    }
}

