/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.PlanTestSymbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.AddIntermediateAggregations;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestAddIntermediateAggregations
extends BaseRuleTest {
    public TestAddIntermediateAggregations() {
        super(new Plugin[0]);
    }

    @Test
    public void testBasic() {
        ExpectedValueProvider<FunctionCall> aggregationPattern = PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> {
            p.variable("a", (Type)BigintType.BIGINT);
            p.variable("b", (Type)BigintType.BIGINT);
            p.variable("c", (Type)BigintType.BIGINT);
            af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.variable("c"), p.rowExpression("count(b)")).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.variable("b"), p.rowExpression("count(a)")).source((PlanNode)p.values(p.variable("a"))))));
        })).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)))))))))));
    }

    @Test
    public void testNoInputCount() {
        ExpectedValueProvider<FunctionCall> rawInputCount = PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of());
        ExpectedValueProvider<FunctionCall> partialInputCount = PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> {
            p.variable("b");
            af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.variable("c"), p.rowExpression("count(b)")).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.variable("b"), p.rowExpression("count(*)")).source((PlanNode)p.values(p.variable("a"))))));
        })).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), partialInputCount), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), partialInputCount), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), partialInputCount), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), rawInputCount), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)))))))))));
    }

    @Test
    public void testMultipleExchanges() {
        ExpectedValueProvider<FunctionCall> aggregationPattern = PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> {
            p.variable("a");
            p.variable("b");
            af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.variable("c"), p.rowExpression("count(b)")).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.variable("b"), p.rowExpression("count(a)")).source((PlanNode)p.values(p.variable("a")))))));
        })).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0))))))))))));
    }

    @Test
    public void testSessionDisable() {
        this.tester().assertThat((Rule)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "false").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.variable("c"), PlanBuilder.expression("count(b)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.variable("b"), PlanBuilder.expression("count(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("a")))))))).doesNotFire();
    }

    @Test
    public void testNoLocalParallel() {
        ExpectedValueProvider<FunctionCall> aggregationPattern = PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "1").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.variable("c"), PlanBuilder.expression("count(b)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.variable("b"), PlanBuilder.expression("count(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("a")))))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0))))))));
    }

    @Test
    public void testWithGroups() {
        this.tester().assertThat((Rule)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.singleGroupingSet(p.variable("c")).step(AggregationNode.Step.FINAL).addAggregation(p.variable("c"), PlanBuilder.expression("count(b)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p.aggregation(ap -> ap.singleGroupingSet(p.variable("b")).step(AggregationNode.Step.PARTIAL).addAggregation(p.variable("b"), PlanBuilder.expression("count(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("a")))))))).doesNotFire();
    }

    @Test
    public void testInterimProject() {
        ExpectedValueProvider<FunctionCall> aggregationPattern = PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.anySymbol()));
        this.tester().assertThat((Rule)new AddIntermediateAggregations()).setSystemProperty("enable_intermediate_aggregations", "true").setSystemProperty("task_concurrency", "4").on(p -> p.aggregation(af -> af.globalGrouping().step(AggregationNode.Step.FINAL).addAggregation(p.variable("c"), PlanBuilder.expression("count(b)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.gatheringExchange(ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((VariableReferenceExpression[])new VariableReferenceExpression[]{p.variable("b")}), (PlanNode)p.aggregation(ap -> ap.globalGrouping().step(AggregationNode.Step.PARTIAL).addAggregation(p.variable("b"), PlanBuilder.expression("count(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("a"))))))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE_STREAMING, ExchangeNode.Type.GATHER, PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.INTERMEDIATE, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), aggregationPattern), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.PARTIAL, PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0))))))))))));
    }
}

