/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.rule.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import org.testng.annotations.Test;

public class TestCanonicalizeExpressions
extends BaseRuleTest {
    private static final CanonicalizeExpressions canonicalizeExpressions = new CanonicalizeExpressions();

    public TestCanonicalizeExpressions() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireForExpressionsInCanonicalForm() {
        this.tester().assertThat(canonicalizeExpressions.filterExpressionRewrite()).on(p -> p.filter((Expression)BooleanLiteral.FALSE_LITERAL, (PlanNode)p.values())).doesNotFire();
    }

    @Test
    public void testDoesNotFireForUnfilteredJoin() {
        this.tester().assertThat(canonicalizeExpressions.joinExpressionRewrite()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(), (PlanNode)p.values(), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireForCanonicalExpressions() {
        this.tester().assertThat(canonicalizeExpressions.joinExpressionRewrite()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(), (PlanNode)p.values(), OriginalExpressionUtils.castToRowExpression((Expression)BooleanLiteral.FALSE_LITERAL), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }
}

