/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJoinNodeFlattener {
    private static final int DEFAULT_JOIN_LIMIT = 10;
    private DeterminismEvaluator determinismEvaluator;
    private FunctionResolution functionResolution;
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        this.queryRunner = new LocalQueryRunner(TestingSession.testSessionBuilder().build());
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(this.queryRunner.getMetadata());
        this.functionResolution = new FunctionResolution(this.queryRunner.getMetadata().getFunctionAndTypeManager());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testDoesNotAllowOuterJoin() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        JoinNode outerJoin = p.join(JoinNode.Type.FULL, (PlanNode)p.values(a1), (PlanNode)p.values(b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)outerJoin, (Lookup)Lookup.noLookup(), (int)10, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator);
    }

    @Test
    public void testDoesNotConvertNestedOuterJoins() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression c1 = p.variable("C1");
        JoinNode leftJoin = p.join(JoinNode.Type.LEFT, (PlanNode)p.values(a1), (PlanNode)p.values(b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        ValuesNode valuesC = p.values(c1);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)leftJoin, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{leftJoin, valuesC}).setFilter(this.createEqualsExpression(a1, c1)).setOutputVariables(new VariableReferenceExpression[]{a1, b1, c1}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testRetainsOutputSymbols() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression b2 = p.variable("B2");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression c2 = p.variable("C2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1, b2);
        ValuesNode valuesC = p.values(c1, c2);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesB, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.empty()), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC}).setFilter(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression(b1, c1), this.createEqualsExpression(a1, b1)})).setOutputVariables(new VariableReferenceExpression[]{a1, b1}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testCombinesCriteriaAndFilters() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression b2 = p.variable("B2");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression c2 = p.variable("C2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1, b2);
        ValuesNode valuesC = p.values(c1, c2);
        RowExpression bcFilter = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{Expressions.call((String)OperatorType.GREATER_THAN.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.GREATER_THAN, c2.getType(), (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)c2, (Object)Expressions.constant((Object)0L, (Type)BigintType.BIGINT))), Expressions.call((String)OperatorType.NOT_EQUAL.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.NOT_EQUAL, c2.getType(), (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)c2, (Object)Expressions.constant((Object)7L, (Type)BigintType.BIGINT))), Expressions.call((String)OperatorType.GREATER_THAN.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.GREATER_THAN, b2.getType(), c2.getType()), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)b2, (Object)c2))});
        CallExpression add = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)this.functionResolution.arithmeticFunction(OperatorType.ADD, a1.getType(), c1.getType()), (Type)a1.getType(), (List)ImmutableList.of((Object)a1, (Object)c1));
        CallExpression abcFilter = Expressions.call((String)OperatorType.LESS_THAN.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.LESS_THAN, add.getType(), b1.getType()), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)add, (Object)b1));
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesB, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.of(bcFilter)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.of(abcFilter));
        ReorderJoins.MultiJoinNode expected = new ReorderJoins.MultiJoinNode(new LinkedHashSet(ImmutableList.of((Object)valuesA, (Object)valuesB, (Object)valuesC)), LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression(b1, c1), this.createEqualsExpression(a1, b1), bcFilter, abcFilter}), (List)ImmutableList.of((Object)a1, (Object)b1, (Object)b2, (Object)c1, (Object)c2));
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testConvertsBushyTrees() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression d1 = p.variable("D1");
        VariableReferenceExpression d2 = p.variable("D2");
        VariableReferenceExpression e1 = p.variable("E1");
        VariableReferenceExpression e2 = p.variable("E2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1, d2);
        ValuesNode valuesE = p.values(e1, e2);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty()), (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty()), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesD, (PlanNode)valuesE, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(d1, e1), (Object)this.equiJoinClause(d2, e2)), (List<VariableReferenceExpression>)ImmutableList.of((Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty()), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, e1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1, (Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC, valuesD, valuesE}).setFilter(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression(a1, b1), this.createEqualsExpression(a1, c1), this.createEqualsExpression(d1, e1), this.createEqualsExpression(d2, e2), this.createEqualsExpression(b1, e1)})).setOutputVariables(new VariableReferenceExpression[]{a1, b1, c1, d1, d2, e1, e2}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)5, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    @Test
    public void testMoreThanJoinLimit() {
        PlanBuilder p = this.planBuilder();
        VariableReferenceExpression a1 = p.variable("A1");
        VariableReferenceExpression b1 = p.variable("B1");
        VariableReferenceExpression c1 = p.variable("C1");
        VariableReferenceExpression d1 = p.variable("D1");
        VariableReferenceExpression d2 = p.variable("D2");
        VariableReferenceExpression e1 = p.variable("E1");
        VariableReferenceExpression e2 = p.variable("E2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1, d2);
        ValuesNode valuesE = p.values(e1, e2);
        JoinNode join1 = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        JoinNode join2 = p.join(JoinNode.Type.INNER, (PlanNode)valuesD, (PlanNode)valuesE, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(d1, e1), (Object)this.equiJoinClause(d2, e2)), (List<VariableReferenceExpression>)ImmutableList.of((Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)join1, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty()), (PlanNode)join2, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, e1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1, (Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{join1, join2, valuesC}).setFilter(LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.createEqualsExpression(a1, c1), this.createEqualsExpression(b1, e1)})).setOutputVariables(new VariableReferenceExpression[]{a1, b1, c1, d1, d2, e1, e2}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)2, (FunctionResolution)this.functionResolution, (DeterminismEvaluator)this.determinismEvaluator), (Object)expected);
    }

    private RowExpression createEqualsExpression(VariableReferenceExpression left, VariableReferenceExpression right) {
        return Expressions.call((String)OperatorType.EQUAL.name(), (FunctionHandle)this.functionResolution.comparisonFunction(OperatorType.EQUAL, left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)left, (Object)right));
    }

    private JoinNode.EquiJoinClause equiJoinClause(VariableReferenceExpression variable1, VariableReferenceExpression variable2) {
        return new JoinNode.EquiJoinClause(variable1, variable2);
    }

    private PlanBuilder planBuilder() {
        return new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), this.queryRunner.getMetadata());
    }
}

