/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import com.facebook.presto.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestMultipleDistinctAggregationToMarkDistinct
extends BaseRuleTest {
    public TestMultipleDistinctAggregationToMarkDistinct() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoDistinct() {
        this.tester().assertThat((Rule)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.variable("output1"), PlanBuilder.expression("count(input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.variable("output2"), PlanBuilder.expression("count(input2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))))).doesNotFire();
    }

    @Test
    public void testSingleDistinct() {
        this.tester().assertThat((Rule)new MultipleDistinctAggregationToMarkDistinct()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.variable("output1"), PlanBuilder.expression("count(DISTINCT input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))))).doesNotFire();
    }

    @Test
    public void testMultipleAggregations() {
        this.tester().assertThat((Rule)new MultipleDistinctAggregationToMarkDistinct()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.variable("output1"), PlanBuilder.expression("count(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.variable("output2"), PlanBuilder.expression("sum(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("input"))))).doesNotFire();
    }

    @Test
    public void testDistinctWithFilter() {
        this.tester().assertThat((Rule)new MultipleDistinctAggregationToMarkDistinct()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.variable("output1"), PlanBuilder.expression("count(DISTINCT input1) filter (where input2 > 0)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.variable("output2"), PlanBuilder.expression("count(DISTINCT input2) filter (where input1 > 0)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))))).doesNotFire();
        this.tester().assertThat((Rule)new MultipleDistinctAggregationToMarkDistinct()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.variable("output1"), PlanBuilder.expression("count(DISTINCT input1) filter (where input2 > 0)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.variable("output2"), PlanBuilder.expression("count(DISTINCT input2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.variable("input1"), p.variable("input2"))))).doesNotFire();
    }
}

