/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.PlanTestSymbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneAggregationColumns
extends BaseRuleTest {
    public TestPruneAggregationColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneAggregationColumns()).on(p -> this.buildProjectedAggregation((PlanBuilder)p, variable -> variable.getName().equals("b"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("b"), PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of())), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("key"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneAggregationColumns()).on(p -> this.buildProjectedAggregation((PlanBuilder)p, (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).doesNotFire();
    }

    private ProjectNode buildProjectedAggregation(PlanBuilder planBuilder, Predicate<VariableReferenceExpression> projectionFilter) {
        VariableReferenceExpression a = planBuilder.variable("a");
        VariableReferenceExpression b = planBuilder.variable("b");
        VariableReferenceExpression key = planBuilder.variable("key");
        return planBuilder.project(AssignmentUtils.identityAssignmentsAsSymbolReferences((Collection)((Collection)ImmutableList.of((Object)a, (Object)b).stream().filter(projectionFilter).collect(ImmutableSet.toImmutableSet()))), (PlanNode)planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.values(key)).singleGroupingSet(key).addAggregation(a, PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of()).addAggregation(b, PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of())));
    }
}

