/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneTableScanColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneTableScanColumns
extends BaseRuleTest {
    public TestPruneTableScanColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneTableScanColumns()).on(p -> {
            VariableReferenceExpression orderdate = p.variable("orderdate", (Type)DateType.DATE);
            VariableReferenceExpression totalprice = p.variable("totalprice", (Type)DoubleType.DOUBLE);
            return p.project(PlanBuilder.assignment(p.variable("x"), (Expression)new SymbolReference(totalprice.getName())), (PlanNode)p.tableScan(new TableHandle(new ConnectorId("local"), (ConnectorTableHandle)new TpchTableHandle("orders", 0.01), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), (List<VariableReferenceExpression>)ImmutableList.of((Object)orderdate, (Object)totalprice), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)orderdate, (Object)new TpchColumnHandle(orderdate.getName(), (Type)DateType.DATE), (Object)totalprice, (Object)new TpchColumnHandle(totalprice.getName(), (Type)DoubleType.DOUBLE))));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x_", (Object)PlanMatchPattern.expression("totalprice_")), PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice_", (Object)"totalprice"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneTableScanColumns()).on(p -> {
            VariableReferenceExpression xv = p.variable("x");
            return p.project(PlanBuilder.assignment(p.variable("y"), PlanBuilder.expression("x")), (PlanNode)p.tableScan((List<VariableReferenceExpression>)ImmutableList.of((Object)xv), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("x"), (Object)new TestingMetadata.TestingColumnHandle("x"))));
        }).doesNotFire();
    }
}

