/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughUnion;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import org.testng.annotations.Test;

public class TestPushLimitThroughUnion
extends BaseRuleTest {
    public TestPushLimitThroughUnion() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushLimitThroughUnion() {
        this.tester().assertThat((Rule)new PushLimitThroughUnion()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            return p.limit(1L, (PlanNode)p.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(10, a), (Object)p.values(10, b))));
        }).matches(PlanMatchPattern.limit(1L, PlanMatchPattern.union(PlanMatchPattern.limit(1L, true, PlanMatchPattern.values("a")), PlanMatchPattern.limit(1L, true, PlanMatchPattern.values("b")))));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule)new PushLimitThroughUnion()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            return p.limit(1L, (PlanNode)p.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.limit(1L, (PlanNode)p.values(5, a)), (Object)p.limit(1L, (PlanNode)p.values(5, b)))));
        }).doesNotFire();
        this.tester().assertThat((Rule)new PushLimitThroughUnion()).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            VariableReferenceExpression c = p.variable("c");
            return p.limit(2L, (PlanNode)p.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.limit(1L, (PlanNode)p.values(5, a)), (Object)p.limit(1L, (PlanNode)p.values(5, b)))));
        }).doesNotFire();
    }
}

