/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestReorderJoins {
    private RuleTester tester;
    private FunctionResolution functionResolution;
    private static final ImmutableList<List<RowExpression>> TWO_ROWS = ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of());
    private static final QualifiedName RANDOM = QualifiedName.of((String)"random");

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of((Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.AUTOMATIC.name(), (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name()), Optional.of(4));
        this.functionResolution = new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    @Test
    public void testKeepsOutputSymbols() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A2")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(5000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0), (Object)Expressions.variable((String)"A2", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).withExactOutputs("A2"));
    }

    @Test
    public void testReplicatesAndFlipsWhenOneTableMuchSmaller() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionsWhenRequiredBySession() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionsWhenBothTablesEqual() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesUnrestrictedWhenRequiredBySession() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).setSystemProperty("join_max_broadcast_table_size", "1kB").setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatedScalarJoinEvenWhereSessionRequiresRepartitioned() {
        PlanMatchPattern expectedPlan = PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)));
        PlanNodeStatsEstimate valuesA = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        PlanNodeStatsEstimate valuesB = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.variable("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).matches(expectedPlan);
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesA"), p.variable("A1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).matches(expectedPlan);
    }

    @Test
    public void testDoesNotFireForCrossJoin() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoStats() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), p.variable("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).doesNotFire();
    }

    @Test
    public void testDoesNotFireForNonDeterministicFilter() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.variable("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), p.variable("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.of(this.comparisonRowExpression(OperatorType.LESS_THAN, (RowExpression)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (RowExpression)Expressions.call((String)RANDOM.toString(), (FunctionHandle)this.tester.getMetadata().getFunctionAndTypeManager().resolveFunction(Optional.empty(), Optional.empty(), FunctionAndTypeManager.qualifyObjectName((QualifiedName)RANDOM), (List)ImmutableList.of()), (Type)BigintType.BIGINT, (List)ImmutableList.of()))))).doesNotFire();
    }

    @Test
    public void testPredicatesPushedDown() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1"), (Object)p.variable("B2")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1"), (Object)p.variable("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("C1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("B2"), p.variable("C1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), Optional.of(this.comparisonRowExpression(OperatorType.EQUAL, (RowExpression)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (RowExpression)Expressions.variable((String)"B1", (Type)BigintType.BIGINT))))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0), (Object)Expressions.variable((String)"B2", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"C1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "B2")), PlanMatchPattern.values("C1"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.values("B1", "B2"))));
    }

    @Test
    public void testSmallerJoinFirst() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1"), (Object)p.variable("B2")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1"), (Object)p.variable("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("C1")), (List<List<RowExpression>>)TWO_ROWS), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("B2"), p.variable("C1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), Optional.of(this.comparisonRowExpression(OperatorType.EQUAL, (RowExpression)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (RowExpression)Expressions.variable((String)"B1", (Type)BigintType.BIGINT))))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(40.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0), (Object)Expressions.variable((String)"B2", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"C1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(99.0, 199.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "B2")), PlanMatchPattern.values("C1"), PlanMatchPattern.values("B1", "B2"))));
    }

    @Test
    public void testReplicatesWhenNotRestricted() {
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    private RuleAssert assertReorderJoins() {
        return this.tester.assertThat((Rule)new ReorderJoins(new CostComparator(1.0, 1.0, 1.0), this.tester.getMetadata()));
    }

    private RowExpression comparisonRowExpression(OperatorType type, RowExpression left, RowExpression right) {
        return Expressions.call((String)type.name(), (FunctionHandle)this.functionResolution.comparisonFunction(type, left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{left, right});
    }
}

