/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.GatherAndMergeWindows;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Window;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public class TestSwapAdjacentWindowsBySpecifications
extends BaseRuleTest {
    private WindowNode.Frame frame = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.empty(), WindowNode.Frame.BoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty());
    private FunctionHandle functionHandle = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().lookupFunction("avg", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));

    public TestSwapAdjacentWindowsBySpecifications() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutWindowFunctions() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.values(p.variable("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnPlanWithSingleWindowNode() {
        this.tester().assertThat((Rule)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.variable("a")), Optional.empty()), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)new WindowNode.Function(Expressions.call((String)"avg", (FunctionHandle)this.functionHandle, (Type)DoubleType.DOUBLE, (List)ImmutableList.of()), this.frame, false)), (PlanNode)p.values(p.variable("a")))).doesNotFire();
    }

    @Test
    public void subsetComesFirst() {
        String columnAAlias = "ALIAS_A";
        String columnBAlias = "ALIAS_B";
        ExpectedValueProvider<WindowNode.Specification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)columnAAlias), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
        ExpectedValueProvider<WindowNode.Specification> specificationAB = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)columnAAlias, (Object)columnBAlias), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());
        Optional<Window> windowAB = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new SymbolReference("b")), Optional.empty(), Optional.empty()));
        Optional<Window> windowA = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()));
        this.tester().assertThat((Rule)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.variable("a")), Optional.empty()), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1", (Type)DoubleType.DOUBLE), (Object)this.newWindowNodeFunction((List<Symbol>)ImmutableList.of((Object)new Symbol("a")))), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.variable("a"), (Object)p.variable("b")), Optional.empty()), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_2", (Type)DoubleType.DOUBLE), (Object)this.newWindowNodeFunction((List<Symbol>)ImmutableList.of((Object)new Symbol("b")))), (PlanNode)p.values(p.variable("a"), p.variable("b"))))).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationAB).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnBAlias))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(PlanMatchPattern.functionCall("avg", Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)columnAAlias, (Object)0, (Object)columnBAlias, (Object)1)))));
    }

    @Test
    public void dependentWindowsAreNotReordered() {
        Optional<Window> windowA = Optional.of(new Window((List)ImmutableList.of((Object)new SymbolReference("a")), Optional.empty(), Optional.empty()));
        this.tester().assertThat((Rule)new GatherAndMergeWindows.SwapAdjacentWindowsBySpecifications(0)).on(p -> p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.variable("a")), Optional.empty()), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_1"), (Object)this.newWindowNodeFunction((List<Symbol>)ImmutableList.of((Object)new Symbol("avg_2")))), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)p.variable("a"), (Object)p.variable("b")), Optional.empty()), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)p.variable("avg_2"), (Object)this.newWindowNodeFunction((List<Symbol>)ImmutableList.of((Object)new Symbol("a")))), (PlanNode)p.values(p.variable("a"), p.variable("b"))))).doesNotFire();
    }

    private WindowNode.Function newWindowNodeFunction(List<Symbol> symbols) {
        return new WindowNode.Function(Expressions.call((String)"avg", (FunctionHandle)this.functionHandle, (Type)BigintType.BIGINT, symbols.stream().map(symbol -> new VariableReferenceExpression(symbol.getName(), (Type)BigintType.BIGINT)).collect(Collectors.toList())), this.frame, false);
    }
}

