/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.testing.TestingHandleResolver;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStatisticsWriterNode {
    private static final ImmutableList<String> COLUMNS = ImmutableList.of((Object)"", (Object)"col1", (Object)"$:###:;", (Object)"abc+dddd___");

    @Test
    public void testJsonCodec() throws Exception {
        JsonCodec<StatisticsWriterNode> jsonCodec = this.getJsonCodec();
        StatisticsWriterNode expected = this.createStatisticsWriterNode();
        StatisticsWriterNode deserialized = (StatisticsWriterNode)jsonCodec.fromJson(jsonCodec.toJson((Object)expected));
        Assert.assertEquals((Object)deserialized.getTableHandle(), (Object)expected.getTableHandle());
        Assert.assertEquals((Object)deserialized.getRowCountVariable(), (Object)expected.getRowCountVariable());
        Assert.assertEquals((boolean)deserialized.isRowCountEnabled(), (boolean)expected.isRowCountEnabled());
        Assert.assertEquals((Object)deserialized.getDescriptor(), (Object)expected.getDescriptor());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }

    private static StatisticAggregationsDescriptor<VariableReferenceExpression> createTestDescriptor() {
        StatisticAggregationsDescriptor.Builder builder = StatisticAggregationsDescriptor.builder();
        PlanVariableAllocator variableAllocator = new PlanVariableAllocator();
        for (String column : COLUMNS) {
            for (ColumnStatisticType type : ColumnStatisticType.values()) {
                builder.addColumnStatistic(new ColumnStatisticMetadata(column, type), (Object)TestStatisticsWriterNode.testVariable(variableAllocator));
            }
            builder.addGrouping(column, (Object)TestStatisticsWriterNode.testVariable(variableAllocator));
        }
        builder.addTableStatistic(TableStatisticType.ROW_COUNT, (Object)TestStatisticsWriterNode.testVariable(variableAllocator));
        return builder.build();
    }

    private static VariableReferenceExpression testVariable(PlanVariableAllocator allocator) {
        return allocator.newVariable("test", (Type)BigintType.BIGINT);
    }

    private StatisticsWriterNode createStatisticsWriterNode() {
        PlanVariableAllocator variableAllocator = new PlanVariableAllocator();
        return new StatisticsWriterNode(TestStatisticsWriterNode.newId(), (PlanNode)new ValuesNode(TestStatisticsWriterNode.newId(), (List)COLUMNS.stream().map(column -> new VariableReferenceExpression(column, (Type)BigintType.BIGINT)).collect(ImmutableList.toImmutableList()), (List)ImmutableList.of()), new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), variableAllocator.newVariable("count", (Type)BigintType.BIGINT), true, TestStatisticsWriterNode.createTestDescriptor());
    }

    private JsonCodec<StatisticsWriterNode> getJsonCodec() throws Exception {
        Module module = binder -> {
            SqlParser sqlParser = new SqlParser();
            FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            binder.install((Module)new JsonModule());
            binder.install((Module)new HandleJsonModule());
            binder.bind(SqlParser.class).toInstance((Object)sqlParser);
            binder.bind(TypeManager.class).toInstance((Object)functionAndTypeManager);
            Multibinder.newSetBinder((Binder)binder, Type.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(StatisticsWriterNode.class);
        };
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.of((Object)module));
        Injector injector = app.doNotInitializeLogging().quiet().initialize();
        HandleResolver handleResolver = (HandleResolver)injector.getInstance(HandleResolver.class);
        handleResolver.addConnectorName("test", (ConnectorHandleResolver)new TestingHandleResolver());
        return (JsonCodec)injector.getInstance((Key)new Key<JsonCodec<StatisticsWriterNode>>(){});
    }
}

