/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.server.SliceDeserializer;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWindowNode {
    private PlanVariableAllocator variableAllocator;
    private ValuesNode sourceNode;
    private VariableReferenceExpression columnA;
    private VariableReferenceExpression columnB;
    private VariableReferenceExpression columnC;
    private final JsonCodec<WindowNode> codec = this.getJsonCodec();

    @BeforeClass
    public void setUp() {
        this.variableAllocator = new PlanVariableAllocator();
        this.columnA = this.variableAllocator.newVariable("a", (Type)BigintType.BIGINT);
        this.columnB = this.variableAllocator.newVariable("b", (Type)BigintType.BIGINT);
        this.columnC = this.variableAllocator.newVariable("c", (Type)BigintType.BIGINT);
        this.sourceNode = new ValuesNode(TestWindowNode.newId(), (List)ImmutableList.of((Object)this.columnA, (Object)this.columnB, (Object)this.columnC), (List)ImmutableList.of());
    }

    @Test
    public void testSerializationRoundtrip() {
        VariableReferenceExpression windowVariable = this.variableAllocator.newVariable("sum", (Type)BigintType.BIGINT);
        FunctionHandle functionHandle = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager().lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        WindowNode.Frame frame = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING, Optional.empty(), WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty());
        PlanNodeId id = TestWindowNode.newId();
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of((Object)this.columnA), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Ordering(this.columnB, SortOrder.ASC_NULLS_FIRST)))));
        CallExpression call = Expressions.call((String)"sum", (FunctionHandle)functionHandle, (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{new VariableReferenceExpression(this.columnC.getName(), (Type)BigintType.BIGINT)});
        ImmutableMap functions = ImmutableMap.of((Object)windowVariable, (Object)new WindowNode.Function(call, frame, false));
        Optional<VariableReferenceExpression> hashVariable = Optional.of(this.columnB);
        ImmutableSet prePartitionedInputs = ImmutableSet.of((Object)this.columnA);
        WindowNode windowNode = new WindowNode(id, (PlanNode)this.sourceNode, specification, (Map)functions, hashVariable, (Set)prePartitionedInputs, 0);
        String json = this.codec.toJson((Object)windowNode);
        WindowNode actualNode = (WindowNode)this.codec.fromJson(json);
        Assert.assertEquals((Object)actualNode.getId(), (Object)windowNode.getId());
        Assert.assertEquals((Object)actualNode.getSpecification(), (Object)windowNode.getSpecification());
        Assert.assertEquals((Map)actualNode.getWindowFunctions(), (Map)windowNode.getWindowFunctions());
        Assert.assertEquals((Collection)actualNode.getFrames(), (Collection)windowNode.getFrames());
        Assert.assertEquals((Object)actualNode.getHashVariable(), (Object)windowNode.getHashVariable());
        Assert.assertEquals((Set)actualNode.getPrePartitionedInputs(), (Set)windowNode.getPrePartitionedInputs());
        Assert.assertEquals((int)actualNode.getPreSortedOrderPrefix(), (int)windowNode.getPreSortedOrderPrefix());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }

    private JsonCodec<WindowNode> getJsonCodec() throws Exception {
        Module module = binder -> {
            SqlParser sqlParser = new SqlParser();
            FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            binder.install((Module)new JsonModule());
            binder.install((Module)new HandleJsonModule());
            binder.bind(SqlParser.class).toInstance((Object)sqlParser);
            binder.bind(TypeManager.class).toInstance((Object)functionAndTypeManager);
            ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
            Multibinder.newSetBinder((Binder)binder, Type.class);
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Slice.class).to(SliceSerializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Slice.class).to(SliceDeserializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Expression.class).to(Serialization.ExpressionSerializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Expression.class).to(Serialization.ExpressionDeserializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(FunctionCall.class).to(Serialization.FunctionCallDeserializer.class);
            JsonBinder.jsonBinder((Binder)binder).addKeySerializerBinding(VariableReferenceExpression.class).to(Serialization.VariableReferenceExpressionSerializer.class);
            JsonBinder.jsonBinder((Binder)binder).addKeyDeserializerBinding(VariableReferenceExpression.class).to(Serialization.VariableReferenceExpressionDeserializer.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(WindowNode.class);
        };
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.of((Object)module));
        Injector injector = app.doNotInitializeLogging().quiet().initialize();
        return (JsonCodec)injector.getInstance((Key)new Key<JsonCodec<WindowNode>>(){});
    }
}

