/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TestingWriterTarget;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.VerifyNoOriginalExpression;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestVerifyNoOriginalExpression
extends BasePlanTest {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final VariableReferenceExpression VARIABLE_REFERENCE_EXPRESSION = new VariableReferenceExpression("expr", (Type)BigintType.BIGINT);
    private static final ComparisonExpression COMPARISON_EXPRESSION = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("count"), (Expression)new Cast((Expression)new LongLiteral("5"), "bigint"));
    private Metadata metadata;
    private PlanBuilder builder;
    private ValuesNode valuesNode;
    private CallExpression comparisonCallExpression;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.builder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), this.metadata);
        this.valuesNode = this.builder.values();
        this.comparisonCallExpression = new CallExpression("LESS_THAN", this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.LESS_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)VARIABLE_REFERENCE_EXPRESSION, (Object)VARIABLE_REFERENCE_EXPRESSION));
    }

    @Test
    public void testValidateForJoin() {
        CallExpression predicate = this.comparisonCallExpression;
        this.validateJoin((RowExpression)predicate, null, true);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidateFailedForJoin() {
        ComparisonExpression predicate = COMPARISON_EXPRESSION;
        this.validateJoin(null, (Expression)predicate, false);
    }

    @Test
    public void testValidateForWindow() {
        Optional<VariableReferenceExpression> startValue = Optional.of(VARIABLE_REFERENCE_EXPRESSION);
        Optional<VariableReferenceExpression> endValue = Optional.of(VARIABLE_REFERENCE_EXPRESSION);
        Optional<String> originalStartValue = Optional.of("count");
        Optional<String> originalEndValue = Optional.of("count");
        WindowNode.Frame frame = new WindowNode.Frame(WindowNode.Frame.WindowType.RANGE, WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING, startValue, WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING, endValue, originalStartValue, originalEndValue);
        WindowNode.Function function = new WindowNode.Function(this.comparisonCallExpression, frame, false);
        ImmutableList partitionBy = ImmutableList.of((Object)VARIABLE_REFERENCE_EXPRESSION);
        Optional orderingScheme = Optional.empty();
        ImmutableMap functions = ImmutableMap.of((Object)VARIABLE_REFERENCE_EXPRESSION, (Object)function);
        WindowNode windowNode = this.builder.window(new WindowNode.Specification((List)partitionBy, orderingScheme), (Map<VariableReferenceExpression, WindowNode.Function>)functions, (PlanNode)this.valuesNode);
        this.testValidation((PlanNode)windowNode);
    }

    @Test
    public void testValidateSpatialJoin() {
        CallExpression filter = this.comparisonCallExpression;
        this.validateSpatialJoinWithFilter((RowExpression)filter);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidateFailedSpatialJoin() {
        ComparisonExpression predicate = COMPARISON_EXPRESSION;
        RowExpression filter = OriginalExpressionUtils.castToRowExpression((Expression)predicate);
        this.validateSpatialJoinWithFilter(filter);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidateFailedCompound() {
        ComparisonExpression predicate = COMPARISON_EXPRESSION;
        RowExpression rowExpression = OriginalExpressionUtils.castToRowExpression((Expression)predicate);
        FilterNode filterNode = this.builder.filter(rowExpression, (PlanNode)this.valuesNode);
        ImmutableMap map = ImmutableMap.of((Object)VARIABLE_REFERENCE_EXPRESSION, (Object)OriginalExpressionUtils.castToRowExpression((Expression)new SymbolReference("count")));
        ProjectNode projectNode = this.builder.project(new Assignments((Map)map), (PlanNode)filterNode);
        this.testValidation((PlanNode)projectNode);
    }

    @Test
    public void testAggregation() {
        ImmutableList groupingKeys = ImmutableList.of((Object)VARIABLE_REFERENCE_EXPRESSION);
        int groupingSetCount = 1;
        ImmutableMap orderings = ImmutableMap.of((Object)VARIABLE_REFERENCE_EXPRESSION, (Object)SortOrder.ASC_NULLS_FIRST);
        OrderingScheme orderingScheme = new OrderingScheme((List)groupingKeys.stream().map(variable -> new Ordering(variable, (SortOrder)orderings.get(variable))).collect(ImmutableList.toImmutableList()));
        ImmutableMap aggregations = ImmutableMap.of((Object)VARIABLE_REFERENCE_EXPRESSION, (Object)new AggregationNode.Aggregation(this.comparisonCallExpression, Optional.of(this.comparisonCallExpression), Optional.of(orderingScheme), false, Optional.of(new VariableReferenceExpression("orderkey", (Type)BigintType.BIGINT))));
        ImmutableSet globalGroupingSets = ImmutableSet.of((Object)1);
        AggregationNode.GroupingSetDescriptor groupingSets = new AggregationNode.GroupingSetDescriptor((List)groupingKeys, groupingSetCount, (Set)globalGroupingSets);
        ImmutableList preGroupedVariables = ImmutableList.of();
        Optional<VariableReferenceExpression> hashVariable = Optional.of(VARIABLE_REFERENCE_EXPRESSION);
        Optional<VariableReferenceExpression> groupIdVariable = Optional.of(VARIABLE_REFERENCE_EXPRESSION);
        AggregationNode aggregationNode = new AggregationNode(new PlanNodeId("1"), (PlanNode)this.valuesNode, (Map)aggregations, groupingSets, (List)preGroupedVariables, AggregationNode.Step.SINGLE, hashVariable, groupIdVariable);
        this.testValidation((PlanNode)aggregationNode);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidateForApplyFailed() {
        ImmutableMap map = ImmutableMap.of((Object)VARIABLE_REFERENCE_EXPRESSION, (Object)OriginalExpressionUtils.castToRowExpression((Expression)new SymbolReference("count")));
        Assignments assignments = new Assignments((Map)map);
        ImmutableList variableReferenceExpressions = ImmutableList.of((Object)VARIABLE_REFERENCE_EXPRESSION);
        ApplyNode applyNode = this.builder.apply(assignments, (List<VariableReferenceExpression>)variableReferenceExpressions, (PlanNode)this.valuesNode, (PlanNode)this.valuesNode);
        this.testValidation((PlanNode)applyNode);
    }

    @Test
    public void testTableFinish() {
        TableFinishNode tableFinishNode = new TableFinishNode(new PlanNodeId("1"), (PlanNode)this.valuesNode, Optional.of(new TestingWriterTarget()), VARIABLE_REFERENCE_EXPRESSION, Optional.empty(), Optional.empty());
        this.testValidation((PlanNode)tableFinishNode);
    }

    @Test
    public void testTableWriter() {
        ImmutableList variableReferenceExpressions = ImmutableList.of((Object)VARIABLE_REFERENCE_EXPRESSION);
        TableWriterNode tableWriterNode = this.builder.tableWriter((List<VariableReferenceExpression>)variableReferenceExpressions, (List<String>)ImmutableList.of((Object)""), (PlanNode)this.valuesNode);
        this.testValidation((PlanNode)tableWriterNode);
    }

    private void validateJoin(RowExpression rowExpressionPredicate, Expression expressionPredicate, boolean ifRowExpression) {
        ImmutableMap map = ImmutableMap.of((Object)VARIABLE_REFERENCE_EXPRESSION, (Object)VARIABLE_REFERENCE_EXPRESSION);
        ProjectNode projectNode = this.builder.project(new Assignments((Map)map), (PlanNode)this.valuesNode);
        JoinNode joinNode = ifRowExpression ? this.builder.join(JoinNode.Type.INNER, (PlanNode)projectNode, (PlanNode)projectNode, rowExpressionPredicate, new JoinNode.EquiJoinClause[0]) : this.builder.join(JoinNode.Type.INNER, (PlanNode)projectNode, (PlanNode)projectNode, OriginalExpressionUtils.castToRowExpression((Expression)expressionPredicate), new JoinNode.EquiJoinClause[0]);
        this.testValidation((PlanNode)joinNode);
    }

    private void validateSpatialJoinWithFilter(RowExpression filter) {
        ImmutableList outputVariables = ImmutableList.of((Object)VARIABLE_REFERENCE_EXPRESSION);
        Optional<VariableReferenceExpression> leftPartitionVariable = Optional.of(VARIABLE_REFERENCE_EXPRESSION);
        Optional<VariableReferenceExpression> rightPartitionVariable = Optional.of(VARIABLE_REFERENCE_EXPRESSION);
        Optional<String> kdbTree = Optional.of("");
        ImmutableMap map = ImmutableMap.of((Object)VARIABLE_REFERENCE_EXPRESSION, (Object)VARIABLE_REFERENCE_EXPRESSION);
        ProjectNode projectNode = this.builder.project(new Assignments((Map)map), (PlanNode)this.valuesNode);
        SpatialJoinNode spatialJoinNode = new SpatialJoinNode(new PlanNodeId("1"), SpatialJoinNode.Type.INNER, (PlanNode)projectNode, (PlanNode)projectNode, (List)outputVariables, filter, leftPartitionVariable, rightPartitionVariable, kdbTree);
        this.testValidation((PlanNode)spatialJoinNode);
    }

    private void testValidation(PlanNode node) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new VerifyNoOriginalExpression().validate(node, session, this.metadata, SQL_PARSER, this.builder.getTypes(), WarningCollector.NOOP);
            return null;
        });
    }
}

