/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.Session;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;

class QueryAssertions
implements Closeable {
    private final QueryRunner runner;

    public QueryAssertions() {
        this(TestingSession.testSessionBuilder().setCatalog("local").setSchema("default").build());
    }

    public QueryAssertions(Session session) {
        this.runner = new LocalQueryRunner(session);
    }

    public QueryRunner getQueryRunner() {
        return this.runner;
    }

    public void assertFails(@Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        block2: {
            try {
                this.runner.execute(this.runner.getDefaultSession(), sql).toTestTypes();
                Assert.fail((String)String.format("Expected query to fail: %s", sql));
            }
            catch (RuntimeException exception) {
                if (Strings.nullToEmpty((String)exception.getMessage()).matches(expectedMessageRegExp)) break block2;
                Assert.fail((String)String.format("Expected exception message '%s' to match '%s' for query: %s", exception.getMessage(), expectedMessageRegExp, sql), (Throwable)exception);
            }
        }
    }

    public void assertQueryAndPlan(@Language(value="SQL") String actual, @Language(value="SQL") String expected, PlanMatchPattern pattern, Consumer<Plan> planValidator) {
        this.assertQuery(actual, expected);
        Plan plan = this.runner.createPlan(this.runner.getDefaultSession(), actual, WarningCollector.NOOP);
        PlanAssert.assertPlan(this.runner.getDefaultSession(), this.runner.getMetadata(), this.runner.getStatsCalculator(), plan, pattern);
        planValidator.accept(plan);
    }

    public void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        this.assertQuery(actual, expected, false);
    }

    public void assertQuery(@Language(value="SQL") String actual, @Language(value="SQL") String expected, boolean ensureOrdering) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.runner.execute(this.runner.getDefaultSession(), actual).toTestTypes();
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        MaterializedResult expectedResults = null;
        try {
            expectedResults = this.runner.execute(this.runner.getDefaultSession(), expected).toTestTypes();
        }
        catch (RuntimeException ex) {
            Assert.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        Assert.assertEquals((Collection)actualResults.getTypes(), (Collection)expectedResults.getTypes(), (String)("Types mismatch for query: \n " + actual + "\n:"));
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                Assert.assertEquals((Collection)actualRows, (Collection)expectedRows, (String)("For query: \n " + actual + "\n:"));
            }
        } else {
            Assertions.assertEqualsIgnoreOrder((Iterable)actualRows, (Iterable)expectedRows, (String)("For query: \n " + actual));
        }
    }

    @Override
    public void close() {
        this.runner.close();
    }
}

