/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeterminismEvaluator {
    @Test
    public void testDeterminismEvaluator() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        RowExpressionDeterminismEvaluator determinismEvaluator = new RowExpressionDeterminismEvaluator(functionAndTypeManager);
        CallExpression random = new CallExpression("random", functionAndTypeManager.lookupFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (Type)BigintType.BIGINT, Collections.singletonList(Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)determinismEvaluator.isDeterministic((RowExpression)random));
        InputReferenceExpression col0 = Expressions.field((int)0, (Type)BigintType.BIGINT);
        FunctionHandle lessThan = functionAndTypeManager.resolveOperator(OperatorType.LESS_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        CallExpression lessThanExpression = new CallExpression(OperatorType.LESS_THAN.name(), lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)col0, (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)determinismEvaluator.isDeterministic((RowExpression)lessThanExpression));
        CallExpression lessThanRandomExpression = new CallExpression(OperatorType.LESS_THAN.name(), lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)col0, (Object)random));
        Assert.assertFalse((boolean)determinismEvaluator.isDeterministic((RowExpression)lessThanRandomExpression));
    }
}

