/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.sql.relational.FunctionResolution;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFunctionResolution {
    private FunctionResolution functionResolution;

    @BeforeClass
    public void setup() {
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        this.functionResolution = new FunctionResolution(functionAndTypeManager);
    }

    @Test
    public void testStandardFunctionResolution() {
        FunctionResolution standardFunctionResolution = this.functionResolution;
        Assert.assertTrue((boolean)standardFunctionResolution.isNotFunction(standardFunctionResolution.notFunction()));
        Assert.assertTrue((boolean)standardFunctionResolution.isNegateFunction(standardFunctionResolution.negateFunction((Type)DoubleType.DOUBLE)));
        Assert.assertFalse((boolean)standardFunctionResolution.isNotFunction(standardFunctionResolution.negateFunction((Type)DoubleType.DOUBLE)));
        Assert.assertTrue((boolean)standardFunctionResolution.isArithmeticFunction(standardFunctionResolution.arithmeticFunction(OperatorType.ADD, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)));
        Assert.assertFalse((boolean)standardFunctionResolution.isComparisonFunction(standardFunctionResolution.arithmeticFunction(OperatorType.ADD, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)));
        Assert.assertTrue((boolean)standardFunctionResolution.isComparisonFunction(standardFunctionResolution.comparisonFunction(OperatorType.GREATER_THAN, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)));
        Assert.assertFalse((boolean)standardFunctionResolution.isArithmeticFunction(standardFunctionResolution.comparisonFunction(OperatorType.GREATER_THAN, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)));
        Assert.assertTrue((boolean)standardFunctionResolution.isBetweenFunction(standardFunctionResolution.betweenFunction((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)));
        Assert.assertFalse((boolean)standardFunctionResolution.isNotFunction(standardFunctionResolution.betweenFunction((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)));
        Assert.assertTrue((boolean)standardFunctionResolution.isSubscriptFunction(standardFunctionResolution.subscriptFunction((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)standardFunctionResolution.isBetweenFunction(standardFunctionResolution.subscriptFunction((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)BigintType.BIGINT)));
    }
}

