/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSubExpressions {
    private static final FunctionAndTypeManager FUNCTION_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    void testExtract() {
        VariableReferenceExpression a = Expressions.variable((String)"a", (Type)BigintType.BIGINT);
        ConstantExpression b = Expressions.constant((Object)1L, (Type)BigintType.BIGINT);
        RowExpression c = this.call(OperatorType.ADD, (RowExpression)a, (RowExpression)b);
        LambdaDefinitionExpression d = new LambdaDefinitionExpression((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)"a"), c);
        ConstantExpression e = Expressions.constant((Object)1L, (Type)BigintType.BIGINT);
        SpecialFormExpression f = Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.BIND, (Type)new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT), (Type)BigintType.BIGINT), (RowExpression[])new RowExpression[]{e, d});
        Assert.assertEquals((Collection)Expressions.subExpressions((RowExpression)a), (Collection)ImmutableList.of((Object)a));
        Assert.assertEquals((Collection)Expressions.subExpressions((RowExpression)b), (Collection)ImmutableList.of((Object)b));
        Assert.assertEquals((Collection)Expressions.subExpressions((RowExpression)c), (Collection)ImmutableList.of((Object)c, (Object)a, (Object)b));
        Assert.assertEquals((Collection)Expressions.subExpressions((RowExpression)d), (Collection)ImmutableList.of((Object)d, (Object)c, (Object)a, (Object)b));
        Assert.assertEquals((Collection)Expressions.subExpressions((RowExpression)f), (Collection)ImmutableList.of((Object)f, (Object)e, (Object)d, (Object)c, (Object)a, (Object)b));
        Assertions.assertEqualsIgnoreOrder((Iterable)Expressions.uniqueSubExpressions((RowExpression)f), (Iterable)ImmutableSet.of((Object)a, (Object)b, (Object)c, (Object)d, (Object)f));
    }

    private RowExpression call(OperatorType operator, RowExpression left, RowExpression right) {
        FunctionHandle functionHandle = FUNCTION_MANAGER.resolveOperator(operator, TypeSignatureProvider.fromTypes((Type[])new Type[]{left.getType(), right.getType()}));
        return Expressions.call((String)operator.getOperator(), (FunctionHandle)functionHandle, (Type)left.getType(), (RowExpression[])new RowExpression[]{left, right});
    }
}

