/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.Convention;
import com.facebook.presto.spi.function.FunctionDependency;
import com.facebook.presto.spi.function.InvocationConvention;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConventionDependencies
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerParametricScalar(RegularConvention.class);
        this.registerParametricScalar(BlockPositionConvention.class);
        this.registerParametricScalar(Add.class);
    }

    @Test
    public void testConventionDependencies() {
        this.assertFunction("regular_convention(1, 1)", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("regular_convention(50, 10)", (Type)IntegerType.INTEGER, 60);
        this.assertFunction("regular_convention(1, 0)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("block_position_convention(ARRAY [1, 2, 3])", (Type)IntegerType.INTEGER, 6);
        this.assertFunction("block_position_convention(ARRAY [25, 0, 5])", (Type)IntegerType.INTEGER, 30);
        this.assertFunction("block_position_convention(ARRAY [56, 275, 36])", (Type)IntegerType.INTEGER, 367);
    }

    @ScalarFunction(value="add", calledOnNullInput=true)
    public static class Add {
        @SqlType(value="integer")
        public static long add(@SqlType(value="integer") long left, @SqlNullable @SqlType(value="integer") Long right) {
            return Math.addExact((int)left, (int)right.longValue());
        }

        @SqlType(value="integer")
        public static long addBlockPosition(@SqlType(value="integer") long first, @BlockPosition @SqlType(value="integer", nativeContainerType=long.class) Block block, @BlockIndex int position) {
            return Math.addExact((int)first, (int)IntegerType.INTEGER.getLong(block, position));
        }
    }

    @ScalarFunction(value="block_position_convention")
    public static class BlockPositionConvention {
        @SqlType(value="integer")
        public static long testBlockPositionConvention(@FunctionDependency(name="add", returnType="integer", argumentTypes={"integer", "integer"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle function, @SqlType(value="array(int)") Block array) {
            long sum = 0L;
            for (int i = 0; i < array.getPositionCount(); ++i) {
                try {
                    sum = function.invokeExact(sum, array, i);
                    continue;
                }
                catch (Throwable t) {
                    Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                    Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
                }
            }
            return sum;
        }
    }

    @ScalarFunction(value="regular_convention")
    public static class RegularConvention {
        @SqlType(value="integer")
        public static long testRegularConvention(@FunctionDependency(name="add", returnType="integer", argumentTypes={"integer", "integer"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle function, @SqlType(value="integer") long left, @SqlType(value="integer") long right) {
            try {
                return function.invokeExact(left, right);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }
}

