/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.type.IpAddressType;
import com.facebook.presto.type.IpPrefixType;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slices;
import org.testng.annotations.Test;

public class TestIpPrefixOperators
extends AbstractTestFunctions {
    @Test
    public void testVarcharToIpPrefixCast() {
        this.assertFunction("CAST('::ffff:1.2.3.4/24' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("CAST('192.168.0.0/24' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "192.168.0.0/24");
        this.assertFunction("CAST('255.2.3.4/0' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "0.0.0.0/0");
        this.assertFunction("CAST('255.2.3.4/1' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "128.0.0.0/1");
        this.assertFunction("CAST('255.2.3.4/2' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "192.0.0.0/2");
        this.assertFunction("CAST('255.2.3.4/4' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "240.0.0.0/4");
        this.assertFunction("CAST('1.2.3.4/8' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.0.0.0/8");
        this.assertFunction("CAST('1.2.3.4/16' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.0.0/16");
        this.assertFunction("CAST('1.2.3.4/24' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.0/24");
        this.assertFunction("CAST('1.2.3.255/25' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.128/25");
        this.assertFunction("CAST('1.2.3.255/26' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.192/26");
        this.assertFunction("CAST('1.2.3.255/28' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.240/28");
        this.assertFunction("CAST('1.2.3.255/30' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.252/30");
        this.assertFunction("CAST('1.2.3.255/32' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.255/32");
        this.assertFunction("CAST('2001:0db8:0000:0000:0000:ff00:0042:8329/128' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "2001:db8::ff00:42:8329/128");
        this.assertFunction("CAST('2001:db8::ff00:42:8329/128' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "2001:db8::ff00:42:8329/128");
        this.assertFunction("CAST('2001:db8:0:0:1:0:0:1/128' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "2001:db8::1:0:0:1/128");
        this.assertFunction("CAST('2001:db8:0:0:1::1/128' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "2001:db8::1:0:0:1/128");
        this.assertFunction("CAST('2001:db8::1:0:0:1/128' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "2001:db8::1:0:0:1/128");
        this.assertFunction("CAST('2001:DB8::FF00:ABCD:12EF/128' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "2001:db8::ff00:abcd:12ef/128");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/0' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "::/0");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/1' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "8000::/1");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/2' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "c000::/2");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/4' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "f000::/4");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/8' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ff00::/8");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/16' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff::/16");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/32' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff::/32");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/48' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff::/48");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/64' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff::/64");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/80' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff:ffff::/80");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/96' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff:ffff:ffff::/96");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/112' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:0/112");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/120' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ff00/120");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/124' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:fff0/124");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/126' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:fffc/126");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/127' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:fffe/127");
        this.assertFunction("CAST('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff/128");
        this.assertFunction("IPPREFIX '10.0.0.0/32'", (Type)IpPrefixType.IPPREFIX, "10.0.0.0/32");
        this.assertFunction("IPPREFIX '64:ff9b::10.0.0.0/128'", (Type)IpPrefixType.IPPREFIX, "64:ff9b::a00:0/128");
        this.assertInvalidCast("CAST('facebook.com/32' AS IPPREFIX)", "Cannot cast value to IPPREFIX: facebook.com/32");
        this.assertInvalidCast("CAST('localhost/32' AS IPPREFIX)", "Cannot cast value to IPPREFIX: localhost/32");
        this.assertInvalidCast("CAST('2001:db8::1::1/128' AS IPPREFIX)", "Cannot cast value to IPPREFIX: 2001:db8::1::1/128");
        this.assertInvalidCast("CAST('2001:zxy::1::1/128' AS IPPREFIX)", "Cannot cast value to IPPREFIX: 2001:zxy::1::1/128");
        this.assertInvalidCast("CAST('789.1.1.1/32' AS IPPREFIX)", "Cannot cast value to IPPREFIX: 789.1.1.1/32");
        this.assertInvalidCast("CAST('192.1.1.1' AS IPPREFIX)", "Cannot cast value to IPPREFIX: 192.1.1.1");
        this.assertInvalidCast("CAST('192.1.1.1/128' AS IPPREFIX)", "Cannot cast value to IPPREFIX: 192.1.1.1/128");
    }

    @Test
    public void testIpPrefixToVarcharCast() {
        this.assertFunction("CAST(IPPREFIX '::ffff:1.2.3.4/32' AS VARCHAR)", (Type)VarcharType.VARCHAR, "1.2.3.4/32");
        this.assertFunction("CAST(IPPREFIX '::ffff:102:304/32' AS VARCHAR)", (Type)VarcharType.VARCHAR, "1.2.3.4/32");
        this.assertFunction("CAST(IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128' AS VARCHAR)", (Type)VarcharType.VARCHAR, "2001:db8::ff00:42:8329/128");
        this.assertFunction("CAST(IPPREFIX '2001:db8::ff00:42:8329/128' AS VARCHAR)", (Type)VarcharType.VARCHAR, "2001:db8::ff00:42:8329/128");
        this.assertFunction("CAST(IPPREFIX '2001:db8:0:0:1:0:0:1/128' AS VARCHAR)", (Type)VarcharType.VARCHAR, "2001:db8::1:0:0:1/128");
        this.assertFunction("CAST(CAST('1.2.3.4/32' AS IPPREFIX) AS VARCHAR)", (Type)VarcharType.VARCHAR, "1.2.3.4/32");
        this.assertFunction("CAST(CAST('2001:db8:0:0:1::1/128' AS IPPREFIX) AS VARCHAR)", (Type)VarcharType.VARCHAR, "2001:db8::1:0:0:1/128");
        this.assertFunction("CAST(CAST('64:ff9b::10.0.0.0/128' AS IPPREFIX) AS VARCHAR)", (Type)VarcharType.VARCHAR, "64:ff9b::a00:0/128");
    }

    @Test
    public void testIpPrefixToIpAddressCast() {
        this.assertFunction("CAST(IPPREFIX '1.2.3.4/32' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "1.2.3.4");
        this.assertFunction("CAST(IPPREFIX '1.2.3.4/24' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "1.2.3.0");
        this.assertFunction("CAST(IPPREFIX '::1/128' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "::1");
        this.assertFunction("CAST(IPPREFIX '2001:db8::ff00:42:8329/128' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::ff00:42:8329");
        this.assertFunction("CAST(IPPREFIX '2001:db8::ff00:42:8329/64' AS IPADDRESS)", (Type)IpAddressType.IPADDRESS, "2001:db8::");
    }

    @Test
    public void testIpAddressToIpPrefixCast() {
        this.assertFunction("CAST(IPADDRESS '1.2.3.4' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.4/32");
        this.assertFunction("CAST(IPADDRESS '::ffff:102:304' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "1.2.3.4/32");
        this.assertFunction("CAST(IPADDRESS '::1' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "::1/128");
        this.assertFunction("CAST(IPADDRESS '2001:db8::ff00:42:8329' AS IPPREFIX)", (Type)IpPrefixType.IPPREFIX, "2001:db8::ff00:42:8329/128");
    }

    @Test
    public void testEquals() {
        this.assertFunction("IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128' = IPPREFIX '2001:db8::ff00:42:8329/128'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.4/32' AS IPPREFIX) = CAST('::ffff:1.2.3.4/32' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '192.168.0.0/32' = IPPREFIX '::ffff:192.168.0.0/32'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '10.0.0.0/32' = IPPREFIX '::ffff:a00:0/32'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.4/24' AS IPPREFIX) = IPPREFIX '1.2.3.5/24'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '2001:db8::ff00:42:8329/128' = IPPREFIX '2001:db8::ff00:42:8300/128'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('1.2.3.4/32' AS IPPREFIX) = IPPREFIX '1.2.3.5/32'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('1.2.0.0/24' AS IPPREFIX) = IPPREFIX '1.2.0.0/25'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128' IS DISTINCT FROM IPPREFIX '2001:db8::ff00:42:8329/128'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(NULL AS IPPREFIX) IS DISTINCT FROM CAST(NULL AS IPPREFIX)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128' IS DISTINCT FROM IPPREFIX '2001:db8::ff00:42:8328/128'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128' IS DISTINCT FROM CAST(NULL AS IPPREFIX)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(NULL AS IPPREFIX) IS DISTINCT FROM IPPREFIX '2001:db8::ff00:42:8328/128'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEquals() {
        this.assertFunction("IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128' != IPPREFIX '1.2.3.4/32'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.4/32' AS IPPREFIX) <> CAST('1.2.3.5/32' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.4/32' AS IPPREFIX) != IPPREFIX '1.2.3.4/32'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128' <> IPPREFIX '2001:db8::ff00:42:8329/128'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('1.2.3.4/32' AS IPPREFIX) <> CAST('::ffff:1.2.3.4/32' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testOrderOperators() {
        this.assertFunction("IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128' > IPPREFIX '1.2.3.4/32'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '1.2.3.4/32' > IPPREFIX '2001:0db8:0000:0000:0000:ff00:0042:8329/128'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('1.2.3.4/32' AS IPPREFIX) < CAST('1.2.3.5/32' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST('1.2.3.5/32' AS IPPREFIX) < CAST('1.2.3.4/32' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST('1.2.0.0/24' AS IPPREFIX) < CAST('1.2.0.0/25' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '::1/128' <= CAST('1.2.3.5/32' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '1.2.3.5/32' <= CAST('1.2.3.5/32' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '1.2.3.6/32' <= CAST('1.2.3.5/32' AS IPPREFIX)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPPREFIX '::1/128' >= IPPREFIX '::/128'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '::1/128' >= IPPREFIX '::1/128'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '::/128' >= IPPREFIX '::1/128'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("IPPREFIX '::1/128' BETWEEN IPPREFIX '::/128' AND IPPREFIX '::1234/128'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("IPPREFIX '::2222/128' BETWEEN IPPREFIX '::/128' AND IPPREFIX '::1234/128'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "CAST(null AS IPPREFIX)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "IPPREFIX '::2222/128'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testHash() {
        this.assertOperator(OperatorType.HASH_CODE, "CAST(null AS IPPREFIX)", (Type)BigintType.BIGINT, null);
        this.assertOperator(OperatorType.HASH_CODE, "IPPREFIX '::2222/128'", (Type)BigintType.BIGINT, TestIpPrefixOperators.hashFromType("::2222/128"));
    }

    private static long hashFromType(String address) {
        BlockBuilder blockBuilder = IpPrefixType.IPPREFIX.createBlockBuilder(null, 1);
        String[] parts = address.split("/");
        byte[] bytes = new byte[IpPrefixType.IPPREFIX.getFixedSize()];
        byte[] addressBytes = InetAddresses.forString((String)parts[0]).getAddress();
        System.arraycopy(addressBytes, 0, bytes, 0, 16);
        bytes[IpPrefixType.IPPREFIX.getFixedSize() - 1] = (byte)Integer.parseInt(parts[1]);
        IpPrefixType.IPPREFIX.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])bytes));
        Block block = blockBuilder.build();
        return IpPrefixType.IPPREFIX.hash(block, 0);
    }
}

