/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.type.AbstractTestType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongDecimalType
extends AbstractTestType {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)30, (int)10);

    public TestLongDecimalType() {
        super((Type)LONG_DECIMAL_TYPE, SqlDecimal.class, TestLongDecimalType.createTestBlock());
    }

    @Test
    public void testUnscaledValueToSlice() {
        Assert.assertEquals((Object)Decimals.encodeUnscaledValue((long)0L), (Object)Decimals.encodeUnscaledValue((BigInteger)BigInteger.valueOf(0L)));
        Assert.assertEquals((Object)Decimals.encodeUnscaledValue((long)1L), (Object)Decimals.encodeUnscaledValue((BigInteger)BigInteger.valueOf(1L)));
        Assert.assertEquals((Object)Decimals.encodeUnscaledValue((long)-1L), (Object)Decimals.encodeUnscaledValue((BigInteger)BigInteger.valueOf(-1L)));
        Assert.assertEquals((Object)Decimals.encodeUnscaledValue((long)Long.MAX_VALUE), (Object)Decimals.encodeUnscaledValue((BigInteger)BigInteger.valueOf(Long.MAX_VALUE)));
        Assert.assertEquals((Object)Decimals.encodeUnscaledValue((long)Long.MIN_VALUE), (Object)Decimals.encodeUnscaledValue((BigInteger)BigInteger.valueOf(Long.MIN_VALUE)));
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = LONG_DECIMAL_TYPE.createBlockBuilder(null, 15);
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("-12345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("-12345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("-12345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("32345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("32345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("42345678901234567890.1234567890"));
        return blockBuilder.build();
    }

    @Override
    protected Object getNonNullValue() {
        return Slices.wrappedBuffer((byte[])new byte[16]);
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Slice slice = (Slice)value;
        BigDecimal decimal = TestLongDecimalType.toBigDecimal(slice, 10);
        BigDecimal greaterDecimal = decimal.add(BigDecimal.ONE);
        return Decimals.encodeScaledValue((BigDecimal)greaterDecimal);
    }

    private static BigDecimal toBigDecimal(Slice valueSlice, int scale) {
        return new BigDecimal(UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((Slice)valueSlice), scale);
    }
}

