/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.SqlTimeWithTimeZone;
import com.facebook.presto.common.type.SqlTimestampWithTimeZone;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.time.ZoneId;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public abstract class TestTimeBase
extends AbstractTestFunctions {
    protected static final TimeZoneKey TIME_ZONE_KEY = TestingSession.DEFAULT_TIME_ZONE_KEY;
    protected static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);

    public TestTimeBase(boolean legacyTimestamp) {
        super(TestingSession.testSessionBuilder().setSystemProperty("legacy_timestamp", String.valueOf(legacyTimestamp)).setTimeZoneKey(TIME_ZONE_KEY).build());
    }

    @Test
    public void testLiteral() {
        this.assertFunction("TIME '03:04:05.321'", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05'", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)0, (Session)this.session));
        this.assertFunction("TIME '03:04'", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)0, (int)0, (Session)this.session));
        this.assertInvalidFunction("TIME 'text'", SemanticErrorCode.INVALID_LITERAL, "line 1:1: 'text' is not a valid time literal");
    }

    @Test
    public void testSubtract() {
        this.functionAssertions.assertFunctionString("TIME '14:15:16.432' - TIME '03:04:05.321'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "0 11:11:11.111");
        this.functionAssertions.assertFunctionString("TIME '03:04:05.321' - TIME '14:15:16.432'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "-0 11:11:11.111");
    }

    @Test
    public void testEqual() {
        this.assertFunction("TIME '03:04:05.321' = TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' = TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("TIME '03:04:05.321' <> TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' <> TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321' < TIME '03:04:05'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' <= TIME '03:04:05'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321' > TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' >= TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.111' and TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.321' and TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.111' and TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.321' and TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.322' and TIME '03:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.311' and TIME '03:04:05.312'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321' between TIME '03:04:05.333' and TIME '03:04:05.111'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToTimeWithTimeZone() {
        this.assertFunction("cast(TIME '03:04:05.321' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TimeZone.getTimeZone(ZoneId.of(DATE_TIME_ZONE.getID()))));
    }

    @Test
    public void testCastToTimeWithTimeZoneWithTZWithRulesChanged() {
        TimeZoneKey timeZoneThatChangedSince1970 = TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu");
        DateTimeZone dateTimeZoneThatChangedSince1970 = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)timeZoneThatChangedSince1970);
        Session session = Session.builder((Session)this.session).setTimeZoneKey(timeZoneThatChangedSince1970).build();
        try (FunctionAssertions localAssertions = new FunctionAssertions(session);){
            localAssertions.assertFunction("cast(TIME '03:04:05.321' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, dateTimeZoneThatChangedSince1970).getMillis(), TimeZone.getTimeZone(ZoneId.of(dateTimeZoneThatChangedSince1970.getID()))));
        }
    }

    @Test
    public void testCastToTimeWithTimeZoneDSTIsNotAppliedWhenTimeCrossesDST() {
        Session session = Session.builder((Session)this.session).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Australia/Sydney")).setStartTime(new DateTime(2017, 10, 1, 1, 59, 59, 999, DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Australia/Sydney"))).getMillis()).build();
        try (FunctionAssertions localAssertions = new FunctionAssertions(session);){
            localAssertions.assertFunctionString("cast(TIME '12:00:00.000' as time with time zone)", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "12:00:00.000 Australia/Sydney");
        }
    }

    @Test
    public void testCastToTimestamp() {
        this.assertFunction("cast(TIME '03:04:05.321' as timestamp)", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)1970, (int)1, (int)1, (int)3, (int)4, (int)5, (int)321, (Session)this.session));
    }

    @Test
    public void testCastToTimestampWithTimeZone() {
        this.assertFunction("cast(TIME '03:04:05.321' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(TIME '03:04:05.321' as varchar)", (Type)VarcharType.VARCHAR, "03:04:05.321");
        this.assertFunction("cast(TIME '03:04:05' as varchar)", (Type)VarcharType.VARCHAR, "03:04:05.000");
        this.assertFunction("cast(TIME '03:04' as varchar)", (Type)VarcharType.VARCHAR, "03:04:00.000");
    }

    @Test
    public void testCastFromSlice() {
        this.assertFunction("cast('03:04:05.321' as time) = TIME '03:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('03:04:05' as time) = TIME '03:04:05.000'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast('03:04' as time) = TIME '03:04:00.000'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as TIME)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "TIME '00:00:00'", (Type)BooleanType.BOOLEAN, false);
    }
}

