/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.SqlTimeWithTimeZone;
import com.facebook.presto.common.type.SqlTimestampWithTimeZone;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.type.IntervalDayTimeType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public abstract class TestTimeWithTimeZoneBase
extends AbstractTestFunctions {
    private static final DateTimeZone WEIRD_ZONE = DateTimeZone.forOffsetHoursMinutes((int)7, (int)9);
    private static final TimeZoneKey WEIRD_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)429L);

    protected TestTimeWithTimeZoneBase(boolean legacyTimestamp) {
        super(TestingSession.testSessionBuilder().setSystemProperty("legacy_timestamp", String.valueOf(legacyTimestamp)).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"+06:09")).build());
    }

    @Test
    public void testLiteral() {
        this.assertFunction("TIME '03:04:05.321 +07:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05 +07:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 0, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04 +07:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 0, 0, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '3:4:5.321+07:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '3:4:5+07:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 0, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '3:4+07:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 0, 0, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testSubtract() {
        this.functionAssertions.assertFunctionString("TIME '14:15:16.432 +07:09' - TIME '03:04:05.321 +08:09'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "0 12:11:11.111");
        this.functionAssertions.assertFunctionString("TIME '03:04:05.321 +08:09' - TIME '14:15:16.432 +07:09'", (Type)IntervalDayTimeType.INTERVAL_DAY_TIME, "-0 12:11:11.111");
    }

    @Test
    public void testEqual() {
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' = TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' <> TIME '02:04:05.321'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '03:04:05 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' < TIME '02:04:05'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '03:04:05 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' <= TIME '02:04:05'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '03:04:05.111 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.111 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.321'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' > TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '03:04:05.111 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.111 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.111'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' >= TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.111 +07:09' and TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.111 +06:09' and TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.111' and TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.321 +07:09' and TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.321 +06:09' and TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.321' and TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.111 +07:09' and TIME '03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.111 +06:09' and TIME '02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.111' and TIME '02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.321 +07:09' and TIME '03:04:05.321 +07:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.321 +06:09' and TIME '02:04:05.321 +06:09'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.321' and TIME '02:04:05.321'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.322 +07:09' and TIME '03:04:05.333 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.322 +06:09' and TIME '02:04:05.333 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.322' and TIME '02:04:05.333'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.311 +07:09' and TIME '03:04:05.312 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.311 +06:09' and TIME '02:04:05.312 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.311' and TIME '02:04:05.312'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '03:04:05.333 +07:09' and TIME '03:04:05.111 +07:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.333 +06:09' and TIME '02:04:05.111 +06:09'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("TIME '03:04:05.321 +07:09' between TIME '02:04:05.333' and TIME '02:04:05.111'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public abstract void testCastToTime();

    @Test
    public abstract void testCastToTimestamp();

    @Test
    public void testCastToTimestampWithTimeZone() {
        this.assertFunction("cast(TIME '03:04:05.321 +07:09' as timestamp with time zone)", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(TIME '03:04:05.321 +07:09' as varchar)", (Type)VarcharType.VARCHAR, "03:04:05.321 +07:09");
        this.assertFunction("cast(TIME '03:04:05 +07:09' as varchar)", (Type)VarcharType.VARCHAR, "03:04:05.000 +07:09");
        this.assertFunction("cast(TIME '03:04 +07:09' as varchar)", (Type)VarcharType.VARCHAR, "03:04:00.000 +07:09");
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as TIME WITH TIME ZONE)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "TIME '03:04:05 +07:09'", (Type)BooleanType.BOOLEAN, false);
    }
}

